/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi.stubs.impl;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.psi.stubs.StubBase;
import org.jetbrains.jet.internal.com.intellij.psi.stubs.StubElement;
import org.jetbrains.jet.internal.com.intellij.util.io.StringRef;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.stubs.PsiJetClassStub;
import org.jetbrains.jet.lang.psi.stubs.elements.JetClassElementType;

public class PsiJetClassStubImpl
extends StubBase<JetClass>
implements PsiJetClassStub {
    private final StringRef qualifiedName;
    private final StringRef name;
    private final StringRef[] superNames;

    public PsiJetClassStubImpl(JetClassElementType type, StubElement parent, @Nullable String qualifiedName, String name, List<String> superNames) {
        this(type, parent, StringRef.fromString(qualifiedName), StringRef.fromString(name), PsiJetClassStubImpl.wrapStrings(superNames));
    }

    private static StringRef[] wrapStrings(List<String> names) {
        StringRef[] refs = new StringRef[names.size()];
        for (int i = 0; i < names.size(); ++i) {
            refs[i] = StringRef.fromString(names.get(i));
        }
        return refs;
    }

    public PsiJetClassStubImpl(JetClassElementType type, StubElement parent, StringRef qualifiedName, StringRef name, StringRef[] superNames) {
        super(parent, type);
        this.qualifiedName = qualifiedName;
        this.name = name;
        this.superNames = superNames;
    }

    @Override
    public String getQualifiedName() {
        return StringRef.toString(this.qualifiedName);
    }

    @Override
    public boolean isDeprecated() {
        return false;
    }

    @Override
    public boolean hasDeprecatedAnnotation() {
        return false;
    }

    @Override
    public String getName() {
        return StringRef.toString(this.name);
    }

    @Override
    @NotNull
    public List<String> getSuperNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (StringRef ref : this.superNames) {
            result.add(ref.toString());
        }
        return result;
    }
}

