/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi.stubs.elements;

import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.lang.ASTNode;
import org.jetbrains.jet.internal.com.intellij.lang.LighterAST;
import org.jetbrains.jet.internal.com.intellij.lang.LighterASTNode;
import org.jetbrains.jet.internal.com.intellij.psi.stubs.IndexSink;
import org.jetbrains.jet.internal.com.intellij.psi.stubs.StubElement;
import org.jetbrains.jet.internal.com.intellij.psi.stubs.StubInputStream;
import org.jetbrains.jet.internal.com.intellij.psi.stubs.StubOutputStream;
import org.jetbrains.jet.internal.com.intellij.util.io.StringRef;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.stubs.PsiJetClassStub;
import org.jetbrains.jet.lang.psi.stubs.elements.JetStubElementType;
import org.jetbrains.jet.lang.psi.stubs.elements.JetStubElementTypes;
import org.jetbrains.jet.lang.psi.stubs.elements.StubIndexServiceFactory;
import org.jetbrains.jet.lang.psi.stubs.impl.PsiJetClassStubImpl;
import org.jetbrains.jet.lang.resolve.name.FqName;

public class JetClassElementType
extends JetStubElementType<PsiJetClassStub, JetClass> {
    public JetClassElementType(@NotNull @NonNls String debugName) {
        super(debugName);
    }

    @Override
    public PsiJetClassStub createStub(LighterAST tree, LighterASTNode node, StubElement parentStub) {
        return null;
    }

    @Override
    public JetClass createPsi(@NotNull PsiJetClassStub stub) {
        return null;
    }

    @Override
    public JetClass createPsiFromAst(@NotNull ASTNode node) {
        return new JetClass(node);
    }

    @Override
    public PsiJetClassStub createStub(@NotNull JetClass psi, StubElement parentStub) {
        FqName fqName = JetPsiUtil.getFQName(psi);
        return new PsiJetClassStubImpl(JetStubElementTypes.CLASS, parentStub, fqName != null ? fqName.getFqName() : null, psi.getName(), psi.getSuperNames());
    }

    @Override
    public void serialize(PsiJetClassStub stub, StubOutputStream dataStream) throws IOException {
        dataStream.writeName(stub.getName());
        dataStream.writeName(stub.getQualifiedName());
        List<String> superNames = stub.getSuperNames();
        dataStream.writeVarInt(superNames.size());
        for (String name : superNames) {
            dataStream.writeName(name);
        }
    }

    @Override
    public PsiJetClassStub deserialize(StubInputStream dataStream, StubElement parentStub) throws IOException {
        StringRef name = dataStream.readName();
        StringRef qualifiedName = dataStream.readName();
        int superCount = dataStream.readVarInt();
        StringRef[] superNames = StringRef.createArray(superCount);
        for (int i = 0; i < superCount; ++i) {
            superNames[i] = dataStream.readName();
        }
        JetClassElementType type = JetStubElementTypes.CLASS;
        PsiJetClassStubImpl classStub = new PsiJetClassStubImpl(type, parentStub, qualifiedName, name, superNames);
        return classStub;
    }

    @Override
    public void indexStub(PsiJetClassStub stub, IndexSink sink) {
        StubIndexServiceFactory.getInstance().indexClass(stub, sink);
    }
}

