/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.JetNodeTypes;
import org.jetbrains.jet.internal.com.intellij.lang.ASTNode;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetVisitor;
import org.jetbrains.jet.lang.psi.JetVisitorVoid;
import org.jetbrains.jet.lang.psi.JetWhenCondition;
import org.jetbrains.jet.lexer.JetTokens;

public class JetWhenConditionInRange
extends JetWhenCondition {
    public JetWhenConditionInRange(@NotNull ASTNode node) {
        super(node);
    }

    public boolean isNegated() {
        return this.getNode().findChildByType(JetTokens.NOT_IN) != null;
    }

    @JetElement.IfNotParsed
    @Nullable
    public JetExpression getRangeExpression() {
        for (ASTNode node = this.getOperationReference().getNode().getTreeNext(); node != null; node = node.getTreeNext()) {
            PsiElement psi = node.getPsi();
            if (!(psi instanceof JetExpression)) continue;
            return (JetExpression)psi;
        }
        return null;
    }

    @Override
    public void accept(@NotNull JetVisitorVoid visitor) {
        visitor.visitWhenConditionInRange(this);
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor, D data) {
        return visitor.visitWhenConditionInRange(this, data);
    }

    public JetSimpleNameExpression getOperationReference() {
        return (JetSimpleNameExpression)this.findChildByType(JetNodeTypes.OPERATION_REFERENCE);
    }
}

