/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.JetNodeTypes;
import org.jetbrains.jet.internal.com.intellij.lang.ASTNode;
import org.jetbrains.jet.internal.com.intellij.psi.tree.IElementType;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.psi.JetVisitor;
import org.jetbrains.jet.lang.psi.JetVisitorVoid;
import org.jetbrains.jet.lexer.JetTokens;

public class JetTypeConstraint
extends JetElement {
    public JetTypeConstraint(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    public void accept(@NotNull JetVisitorVoid visitor) {
        visitor.visitTypeConstraint(this);
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor, D data) {
        return visitor.visitTypeConstraint(this, data);
    }

    public boolean isClassObjectContraint() {
        return this.findChildByType(JetTokens.CLASS_KEYWORD) != null && this.findChildByType(JetTokens.OBJECT_KEYWORD) != null;
    }

    @JetElement.IfNotParsed
    @Nullable
    public JetSimpleNameExpression getSubjectTypeParameterName() {
        return (JetSimpleNameExpression)this.findChildByType(JetNodeTypes.REFERENCE_EXPRESSION);
    }

    @JetElement.IfNotParsed
    @Nullable
    public JetTypeReference getBoundTypeReference() {
        boolean passedColon = false;
        for (ASTNode node = this.getNode().getFirstChildNode(); node != null; node = node.getTreeNext()) {
            IElementType tt = node.getElementType();
            if (tt == JetTokens.COLON) {
                passedColon = true;
            }
            if (!passedColon || tt != JetNodeTypes.TYPE_REFERENCE) continue;
            return (JetTypeReference)node.getPsi();
        }
        return null;
    }
}

