/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.JetNodeTypes;
import org.jetbrains.jet.internal.com.intellij.lang.ASTNode;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetDeclarationWithBody;
import org.jetbrains.jet.lang.psi.JetDelegationSpecifier;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetInitializerList;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetParameterList;
import org.jetbrains.jet.lang.psi.JetStatementExpression;
import org.jetbrains.jet.lang.psi.JetVisitor;
import org.jetbrains.jet.lang.psi.JetVisitorVoid;
import org.jetbrains.jet.lexer.JetTokens;

public class JetSecondaryConstructor
extends JetDeclaration
implements JetDeclarationWithBody,
JetStatementExpression {
    public JetSecondaryConstructor(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    public void accept(@NotNull JetVisitorVoid visitor) {
        visitor.visitConstructor(this);
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor, D data) {
        return visitor.visitConstructor(this, data);
    }

    @JetElement.IfNotParsed
    @Nullable
    public JetParameterList getParameterList() {
        return (JetParameterList)this.findChildByType(JetNodeTypes.VALUE_PARAMETER_LIST);
    }

    @Override
    @NotNull
    public List<JetParameter> getValueParameters() {
        JetParameterList list = this.getParameterList();
        return list != null ? list.getParameters() : Collections.emptyList();
    }

    @Nullable
    public JetInitializerList getInitializerList() {
        return (JetInitializerList)this.findChildByType(JetNodeTypes.INITIALIZER_LIST);
    }

    @NotNull
    public List<JetDelegationSpecifier> getInitializers() {
        JetInitializerList list = this.getInitializerList();
        return list != null ? list.getInitializers() : Collections.emptyList();
    }

    @Override
    public JetExpression getBodyExpression() {
        return this.findChildByClass(JetExpression.class);
    }

    @Override
    public boolean hasBlockBody() {
        return this.findChildByType(JetTokens.EQ) == null;
    }

    @Override
    public boolean hasDeclaredReturnType() {
        return true;
    }

    @Override
    @NotNull
    public JetElement asElement() {
        return this;
    }

    public ASTNode getNameNode() {
        return this.getNode().findChildByType(JetTokens.THIS_KEYWORD);
    }
}

