/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.lang.ASTNode;
import org.jetbrains.jet.internal.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.CheckUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import org.jetbrains.jet.internal.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.jet.lang.psi.Call;
import org.jetbrains.jet.lang.psi.JetBinaryExpressionWithTypeRHS;
import org.jetbrains.jet.lang.psi.JetBindingPattern;
import org.jetbrains.jet.lang.psi.JetBlockExpression;
import org.jetbrains.jet.lang.psi.JetCatchClause;
import org.jetbrains.jet.lang.psi.JetClassBody;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetDotQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetFunctionLiteral;
import org.jetbrains.jet.lang.psi.JetIfExpression;
import org.jetbrains.jet.lang.psi.JetImportDirective;
import org.jetbrains.jet.lang.psi.JetNamedDeclaration;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetNamespaceHeader;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.psi.JetObjectDeclarationName;
import org.jetbrains.jet.lang.psi.JetParenthesizedExpression;
import org.jetbrains.jet.lang.psi.JetPattern;
import org.jetbrains.jet.lang.psi.JetPrefixExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetTryExpression;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.psi.JetVisitorVoid;
import org.jetbrains.jet.lang.psi.JetWhenCondition;
import org.jetbrains.jet.lang.psi.JetWhenConditionIsPattern;
import org.jetbrains.jet.lang.psi.JetWhenEntry;
import org.jetbrains.jet.lang.psi.JetWhenExpression;
import org.jetbrains.jet.lang.psi.JetWildcardPattern;
import org.jetbrains.jet.lang.resolve.ImportPath;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.lang.JetStandardClasses;
import org.jetbrains.jet.lexer.JetTokens;

public class JetPsiUtil {
    public static final Name NO_NAME_PROVIDED = Name.special("<no name provided>");
    public static final Name ROOT_NAMESPACE_NAME = Name.special("<root namespace>");

    private JetPsiUtil() {
    }

    @Nullable
    public static JetExpression deparenthesize(@NotNull JetExpression expression) {
        JetExpression baseExpression;
        if (expression instanceof JetBinaryExpressionWithTypeRHS) {
            JetSimpleNameExpression operationSign = ((JetBinaryExpressionWithTypeRHS)expression).getOperationSign();
            if (JetTokens.COLON.equals(operationSign.getReferencedNameElementType())) {
                expression = ((JetBinaryExpressionWithTypeRHS)expression).getLeft();
            }
        } else if (expression instanceof JetPrefixExpression && JetTokens.LABELS.contains(((JetPrefixExpression)expression).getOperationReference().getReferencedNameElementType()) && (baseExpression = ((JetPrefixExpression)expression).getBaseExpression()) != null) {
            expression = baseExpression;
        }
        if (expression instanceof JetParenthesizedExpression) {
            JetExpression innerExpression = ((JetParenthesizedExpression)expression).getExpression();
            return innerExpression != null ? JetPsiUtil.deparenthesize(innerExpression) : null;
        }
        return expression;
    }

    @NotNull
    public static Name safeName(@Nullable String name) {
        return name == null ? NO_NAME_PROVIDED : Name.identifier(name);
    }

    @NotNull
    public static Set<JetElement> findRootExpressions(@NotNull Collection<JetElement> unreachableElements) {
        HashSet<JetElement> rootElements = new HashSet<JetElement>();
        final HashSet shadowedElements = new HashSet();
        JetVisitorVoid shadowAllChildren = new JetVisitorVoid(){

            @Override
            public void visitJetElement(JetElement element) {
                if (shadowedElements.add(element)) {
                    element.acceptChildren(this);
                }
            }
        };
        for (JetElement element : unreachableElements) {
            if (shadowedElements.contains(element)) continue;
            element.acceptChildren(shadowAllChildren);
            rootElements.removeAll(shadowedElements);
            rootElements.add(element);
        }
        return rootElements;
    }

    @Nullable
    public static JetNamedFunction getSurroundingFunction(@Nullable PsiElement element) {
        while (element != null) {
            if (element instanceof JetNamedFunction) {
                return (JetNamedFunction)element;
            }
            if (element instanceof JetClassOrObject || element instanceof JetFile) {
                return null;
            }
            element = element.getParent();
        }
        return null;
    }

    @NotNull
    public static String unquoteIdentifier(@NotNull String quoted) {
        if (quoted.indexOf(96) < 0) {
            return quoted;
        }
        if (quoted.startsWith("`") && quoted.endsWith("`") && quoted.length() >= 2) {
            return quoted.substring(1, quoted.length() - 1);
        }
        return quoted;
    }

    @NotNull
    public static String unquoteIdentifierOrFieldReference(@NotNull String quoted) {
        if (quoted.indexOf(96) < 0) {
            return quoted;
        }
        if (quoted.startsWith("$")) {
            return "$" + JetPsiUtil.unquoteIdentifier(quoted.substring(1));
        }
        return JetPsiUtil.unquoteIdentifier(quoted);
    }

    private static FqName getFQName(JetNamespaceHeader header) {
        StringBuilder builder = new StringBuilder();
        for (JetSimpleNameExpression nameExpression : header.getParentNamespaceNames()) {
            builder.append(nameExpression.getReferencedName());
            builder.append(".");
        }
        builder.append(header.getName());
        return new FqName(builder.toString());
    }

    public static FqName getFQName(JetFile file) {
        if (file.isScript()) {
            return FqName.ROOT;
        }
        return JetPsiUtil.getFQName(file.getNamespaceHeader());
    }

    @Nullable
    public static FqName getFQName(JetNamedDeclaration namedDeclaration) {
        if (namedDeclaration instanceof JetObjectDeclarationName) {
            JetObjectDeclaration objectDeclaration = PsiTreeUtil.getParentOfType((PsiElement)namedDeclaration, JetObjectDeclaration.class);
            if (objectDeclaration == null) {
                return null;
            }
            return JetPsiUtil.getFQName(objectDeclaration);
        }
        Name functionName = namedDeclaration.getNameAsName();
        if (functionName == null) {
            return null;
        }
        PsiElement parent = namedDeclaration.getParent();
        if (parent instanceof JetClassBody) {
            parent = parent.getParent();
        }
        FqName firstPart = null;
        if (parent instanceof JetFile) {
            firstPart = JetPsiUtil.getFQName((JetFile)parent);
        } else if (parent instanceof JetNamedDeclaration) {
            firstPart = JetPsiUtil.getFQName((JetNamedDeclaration)parent);
        }
        if (firstPart == null) {
            return null;
        }
        return firstPart.child(functionName);
    }

    @JetElement.IfNotParsed
    @Nullable
    public static ImportPath getImportPath(JetImportDirective importDirective) {
        JetExpression importedReference = importDirective.getImportedReference();
        if (importedReference == null) {
            return null;
        }
        String text = importedReference.getText();
        return new ImportPath(text.replaceAll(" ", "") + (importDirective.isAllUnder() ? ".*" : ""));
    }

    public static boolean isIrrefutable(JetWhenEntry entry) {
        if (entry.isElse()) {
            return true;
        }
        for (JetWhenCondition condition : entry.getConditions()) {
            JetBindingPattern bindingPattern;
            if (!(condition instanceof JetWhenConditionIsPattern)) continue;
            JetPattern pattern = ((JetWhenConditionIsPattern)condition).getPattern();
            if (pattern instanceof JetWildcardPattern) {
                return true;
            }
            if (!(pattern instanceof JetBindingPattern) || (bindingPattern = (JetBindingPattern)pattern).getVariableDeclaration().getPropertyTypeRef() != null || bindingPattern.getCondition() != null) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static <T extends PsiElement> T getDirectParentOfTypeForBlock(@NotNull JetBlockExpression block, @NotNull Class<T> aClass) {
        JetFunctionLiteral functionLiteral;
        JetIfExpression ifExpression;
        T parent = PsiTreeUtil.getParentOfType((PsiElement)block, aClass);
        if (parent instanceof JetIfExpression && ((ifExpression = (JetIfExpression)parent).getElse() == block || ifExpression.getThen() == block)) {
            return parent;
        }
        if (parent instanceof JetWhenExpression) {
            JetWhenExpression whenExpression = (JetWhenExpression)parent;
            for (JetWhenEntry whenEntry : whenExpression.getEntries()) {
                if (whenEntry.getExpression() != block) continue;
                return parent;
            }
        }
        if (parent instanceof JetFunctionLiteral && (functionLiteral = (JetFunctionLiteral)parent).getBodyExpression() == block) {
            return parent;
        }
        if (parent instanceof JetTryExpression) {
            JetTryExpression tryExpression = (JetTryExpression)parent;
            if (tryExpression.getTryBlock() == block) {
                return parent;
            }
            for (JetCatchClause clause : tryExpression.getCatchClauses()) {
                if (clause.getCatchBody() != block) continue;
                return parent;
            }
        }
        return null;
    }

    public static boolean isImplicitlyUsed(@NotNull JetElement element) {
        PsiElement parent = element.getParent();
        if (!(parent instanceof JetBlockExpression)) {
            return true;
        }
        JetBlockExpression block = (JetBlockExpression)parent;
        List<JetElement> statements = block.getStatements();
        if (statements.get(statements.size() - 1) == element) {
            JetExpression expression = JetPsiUtil.getDirectParentOfTypeForBlock(block, JetIfExpression.class);
            if (expression == null) {
                expression = JetPsiUtil.getDirectParentOfTypeForBlock(block, JetWhenExpression.class);
            }
            if (expression == null) {
                expression = JetPsiUtil.getDirectParentOfTypeForBlock(block, JetFunctionLiteral.class);
            }
            if (expression == null) {
                expression = JetPsiUtil.getDirectParentOfTypeForBlock(block, JetTryExpression.class);
            }
            if (expression != null) {
                return JetPsiUtil.isImplicitlyUsed(expression);
            }
        }
        return false;
    }

    public static void deleteClass(@NotNull JetClassOrObject clazz) {
        CheckUtil.checkWritable(clazz);
        JetFile file = (JetFile)clazz.getContainingFile();
        List<JetDeclaration> declarations = file.getDeclarations();
        if (declarations.size() == 1) {
            file.delete();
        } else {
            PsiElement parent = clazz.getParent();
            CodeEditUtil.removeChild(parent.getNode(), clazz.getNode());
        }
    }

    @Nullable
    public static Name getAliasName(@NotNull JetImportDirective importDirective) {
        String aliasName = importDirective.getAliasName();
        JetExpression importedReference = importDirective.getImportedReference();
        if (importedReference == null) {
            return null;
        }
        JetSimpleNameExpression referenceExpression = JetPsiUtil.getLastReference(importedReference);
        if (aliasName == null) {
            aliasName = referenceExpression != null ? referenceExpression.getReferencedName() : null;
        }
        return StringUtil.isNotEmpty(aliasName) ? Name.identifier(aliasName) : null;
    }

    @Nullable
    public static JetSimpleNameExpression getLastReference(@NotNull JetExpression importedReference) {
        if (importedReference instanceof JetDotQualifiedExpression) {
            JetExpression selectorExpression = ((JetDotQualifiedExpression)importedReference).getSelectorExpression();
            return selectorExpression instanceof JetSimpleNameExpression ? (JetSimpleNameExpression)selectorExpression : null;
        }
        if (importedReference instanceof JetSimpleNameExpression) {
            return (JetSimpleNameExpression)importedReference;
        }
        return null;
    }

    public static boolean isVoidType(@Nullable JetTypeReference typeReference) {
        if (typeReference == null) {
            return false;
        }
        return JetStandardClasses.UNIT_ALIAS.getName().equals(typeReference.getText());
    }

    public static boolean isSafeCall(@NotNull Call call) {
        ASTNode callOperationNode = call.getCallOperationNode();
        return callOperationNode != null && callOperationNode.getElementType() == JetTokens.SAFE_ACCESS;
    }
}

