/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.lang.ASTNode;
import org.jetbrains.jet.internal.com.intellij.openapi.project.Project;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Pair;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiFileFactory;
import org.jetbrains.jet.internal.com.intellij.util.LocalTimeCounter;
import org.jetbrains.jet.lang.psi.JetCallExpression;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetImportDirective;
import org.jetbrains.jet.lang.psi.JetModifierList;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.psi.JetValueArgumentList;
import org.jetbrains.jet.lang.resolve.ImportPath;
import org.jetbrains.jet.lexer.JetKeywordToken;
import org.jetbrains.jet.lexer.JetTokens;
import org.jetbrains.jet.plugin.JetFileType;

public class JetPsiFactory {
    public static ASTNode createValNode(Project project) {
        JetProperty property = JetPsiFactory.createProperty(project, "val x = 1");
        return property.getValOrVarNode();
    }

    public static ASTNode createVarNode(Project project) {
        JetProperty property = JetPsiFactory.createProperty(project, "var x = 1");
        return property.getValOrVarNode();
    }

    public static JetExpression createExpression(Project project, String text) {
        JetProperty property = JetPsiFactory.createProperty(project, "val x = " + text);
        return property.getInitializer();
    }

    public static JetValueArgumentList createCallArguments(Project project, String text) {
        JetProperty property = JetPsiFactory.createProperty(project, "val x = foo" + text);
        JetExpression initializer = property.getInitializer();
        JetCallExpression callExpression = (JetCallExpression)initializer;
        return callExpression.getValueArgumentList();
    }

    public static JetTypeReference createType(Project project, String type) {
        JetProperty property = JetPsiFactory.createProperty(project, "val x : " + type);
        return property.getPropertyTypeRef();
    }

    public static Pair<PsiElement, PsiElement> createColon(Project project) {
        JetProperty property = JetPsiFactory.createProperty(project, "val x : Int");
        return Pair.create(property.findElementAt(5), property.findElementAt(7));
    }

    public static ASTNode createColonNode(Project project) {
        JetProperty property = JetPsiFactory.createProperty(project, "val x: Int");
        return property.getNode().findChildByType(JetTokens.COLON);
    }

    public static PsiElement createWhiteSpace(Project project) {
        return JetPsiFactory.createWhiteSpace(project, " ");
    }

    public static PsiElement createWhiteSpace(Project project, String text) {
        JetProperty property = JetPsiFactory.createProperty(project, "val" + text + "x");
        return property.findElementAt(3);
    }

    public static JetClass createClass(Project project, String text) {
        return JetPsiFactory.createDeclaration(project, text, JetClass.class);
    }

    @NotNull
    public static JetFile createFile(Project project, String text) {
        return JetPsiFactory.createFile(project, "dummy.jet", text);
    }

    @NotNull
    public static JetFile createFile(Project project, String fileName, String text) {
        return (JetFile)PsiFileFactory.getInstance(project).createFileFromText(fileName, JetFileType.INSTANCE, (CharSequence)text, LocalTimeCounter.currentTime(), false);
    }

    public static JetProperty createProperty(Project project, String name, String type, boolean isVar, @Nullable String initializer) {
        String text = (isVar ? "var " : "val ") + name + (type != null ? ":" + type : "") + (initializer == null ? "" : " = " + initializer);
        return JetPsiFactory.createProperty(project, text);
    }

    public static JetProperty createProperty(Project project, String name, String type, boolean isVar) {
        return JetPsiFactory.createProperty(project, name, type, isVar, null);
    }

    public static JetProperty createProperty(Project project, String text) {
        return JetPsiFactory.createDeclaration(project, text, JetProperty.class);
    }

    private static <T> T createDeclaration(Project project, String text, Class<T> clazz) {
        JetFile file = JetPsiFactory.createFile(project, text);
        List<JetDeclaration> dcls = file.getDeclarations();
        assert (dcls.size() == 1) : dcls.size();
        JetDeclaration result = dcls.get(0);
        return (T)result;
    }

    public static PsiElement createNameIdentifier(Project project, String name) {
        return JetPsiFactory.createProperty(project, name, null, false).getNameIdentifier();
    }

    public static JetSimpleNameExpression createSimpleName(Project project, String name) {
        return (JetSimpleNameExpression)JetPsiFactory.createProperty(project, name, null, false, name).getInitializer();
    }

    public static JetNamedFunction createFunction(Project project, String funDecl) {
        return JetPsiFactory.createDeclaration(project, funDecl, JetNamedFunction.class);
    }

    public static JetModifierList createModifier(Project project, JetKeywordToken modifier) {
        String text = modifier.getValue() + " val x";
        JetProperty property = JetPsiFactory.createProperty(project, text);
        return property.getModifierList();
    }

    public static JetExpression createEmptyBody(Project project) {
        JetNamedFunction function = JetPsiFactory.createFunction(project, "fun foo() {}");
        return function.getBodyExpression();
    }

    public static JetParameter createParameter(Project project, String name, String type) {
        JetNamedFunction function = JetPsiFactory.createFunction(project, "fun foo(" + name + " : " + type + ") {}");
        return function.getValueParameters().get(0);
    }

    @NotNull
    public static JetImportDirective createImportDirective(Project project, @NotNull String path) {
        return JetPsiFactory.createImportDirective(project, new ImportPath(path));
    }

    @NotNull
    public static JetImportDirective createImportDirective(Project project, @NotNull ImportPath importPath) {
        return JetPsiFactory.createImportDirective(project, importPath, null);
    }

    @NotNull
    public static JetImportDirective createImportDirective(Project project, @NotNull ImportPath importPath, @Nullable String aliasName) {
        if (importPath.fqnPart().isRoot()) {
            throw new IllegalArgumentException("import path must not be empty");
        }
        StringBuilder importDirectiveBuilder = new StringBuilder("import ");
        importDirectiveBuilder.append(importPath.getPathStr());
        if (aliasName != null) {
            if (aliasName.isEmpty()) {
                throw new IllegalArgumentException("Alias must not be empty");
            }
            importDirectiveBuilder.append(" as ").append(aliasName);
        }
        JetFile namespace = JetPsiFactory.createFile(project, importDirectiveBuilder.toString());
        return namespace.getImportDirectives().iterator().next();
    }

    public static PsiElement createPrimaryConstructor(Project project) {
        JetClass aClass = JetPsiFactory.createClass(project, "class A()");
        return aClass.findElementAt(7).getParent();
    }
}

