/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.JetNodeTypes;
import org.jetbrains.jet.internal.com.intellij.lang.ASTNode;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetDeclarationWithBody;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetModifierListOwner;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetParameterList;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.psi.JetVisitor;
import org.jetbrains.jet.lang.psi.JetVisitorVoid;
import org.jetbrains.jet.lexer.JetTokens;

public class JetPropertyAccessor
extends JetDeclaration
implements JetDeclarationWithBody,
JetModifierListOwner {
    public JetPropertyAccessor(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    public void accept(@NotNull JetVisitorVoid visitor) {
        visitor.visitPropertyAccessor(this);
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor, D data) {
        return visitor.visitPropertyAccessor(this, data);
    }

    public boolean isSetter() {
        return this.findChildByType(JetTokens.SET_KEYWORD) != null;
    }

    public boolean isGetter() {
        return this.findChildByType(JetTokens.GET_KEYWORD) != null;
    }

    @Nullable
    public JetParameter getParameter() {
        JetParameterList parameterList = (JetParameterList)this.findChildByType(JetNodeTypes.VALUE_PARAMETER_LIST);
        if (parameterList == null) {
            return null;
        }
        List<JetParameter> parameters = parameterList.getParameters();
        if (parameters.isEmpty()) {
            return null;
        }
        return parameters.get(0);
    }

    @Override
    @NotNull
    public List<JetParameter> getValueParameters() {
        JetParameter parameter = this.getParameter();
        if (parameter == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(parameter);
    }

    @Override
    @Nullable
    public JetExpression getBodyExpression() {
        return this.findChildByClass(JetExpression.class);
    }

    @Override
    public boolean hasBlockBody() {
        return this.findChildByType(JetTokens.EQ) == null;
    }

    @Override
    public boolean hasDeclaredReturnType() {
        return true;
    }

    @Override
    @NotNull
    public JetElement asElement() {
        return this;
    }

    @Nullable
    public JetTypeReference getReturnTypeReference() {
        return this.findChildByClass(JetTypeReference.class);
    }

    @NotNull
    public PsiElement getNamePlaceholder() {
        PsiElement get = this.findChildByType(JetTokens.GET_KEYWORD);
        if (get != null) {
            return get;
        }
        return this.findChildByType(JetTokens.SET_KEYWORD);
    }
}

