/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.JetNodeTypes;
import org.jetbrains.jet.internal.com.intellij.lang.ASTNode;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.search.LocalSearchScope;
import org.jetbrains.jet.internal.com.intellij.psi.search.SearchScope;
import org.jetbrains.jet.internal.com.intellij.psi.tree.IElementType;
import org.jetbrains.jet.internal.com.intellij.psi.tree.TokenSet;
import org.jetbrains.jet.internal.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.jet.lang.psi.JetBlockExpression;
import org.jetbrains.jet.lang.psi.JetClassBody;
import org.jetbrains.jet.lang.psi.JetClassInitializer;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetModifierListOwner;
import org.jetbrains.jet.lang.psi.JetNamespaceBody;
import org.jetbrains.jet.lang.psi.JetPropertyAccessor;
import org.jetbrains.jet.lang.psi.JetTypeParameterListOwner;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.psi.JetVisitor;
import org.jetbrains.jet.lang.psi.JetVisitorVoid;
import org.jetbrains.jet.lexer.JetTokens;

public class JetProperty
extends JetTypeParameterListOwner
implements JetModifierListOwner {
    public JetProperty(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    public void accept(@NotNull JetVisitorVoid visitor) {
        visitor.visitProperty(this);
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor, D data) {
        return visitor.visitProperty(this, data);
    }

    public boolean isVar() {
        return this.getNode().findChildByType(JetTokens.VAR_KEYWORD) != null;
    }

    public boolean isLocal() {
        PsiElement parent = this.getParent();
        return !(parent instanceof JetFile) && !(parent instanceof JetClassBody) && !(parent instanceof JetNamespaceBody);
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        if (this.isLocal()) {
            Object block = PsiTreeUtil.getParentOfType((PsiElement)this, JetBlockExpression.class, JetClassInitializer.class);
            if (block == null) {
                return super.getUseScope();
            }
            return new LocalSearchScope((PsiElement)block);
        }
        return super.getUseScope();
    }

    @Nullable
    public JetTypeReference getReceiverTypeRef() {
        IElementType tt;
        for (ASTNode node = this.getNode().getFirstChildNode(); node != null && (tt = node.getElementType()) != JetTokens.COLON; node = node.getTreeNext()) {
            if (tt != JetNodeTypes.TYPE_REFERENCE) continue;
            return (JetTypeReference)node.getPsi();
        }
        return null;
    }

    @Nullable
    public JetTypeReference getPropertyTypeRef() {
        boolean passedColon = false;
        for (ASTNode node = this.getNode().getFirstChildNode(); node != null; node = node.getTreeNext()) {
            IElementType tt = node.getElementType();
            if (tt == JetTokens.COLON) {
                passedColon = true;
                continue;
            }
            if (tt != JetNodeTypes.TYPE_REFERENCE || !passedColon) continue;
            return (JetTypeReference)node.getPsi();
        }
        return null;
    }

    @NotNull
    public List<JetPropertyAccessor> getAccessors() {
        return this.findChildrenByType(JetNodeTypes.PROPERTY_ACCESSOR);
    }

    @Nullable
    public JetPropertyAccessor getGetter() {
        for (JetPropertyAccessor accessor : this.getAccessors()) {
            if (!accessor.isGetter()) continue;
            return accessor;
        }
        return null;
    }

    @Nullable
    public JetPropertyAccessor getSetter() {
        for (JetPropertyAccessor accessor : this.getAccessors()) {
            if (!accessor.isSetter()) continue;
            return accessor;
        }
        return null;
    }

    @Nullable
    public JetExpression getInitializer() {
        PsiElement eq = this.findChildByType(JetTokens.EQ);
        return PsiTreeUtil.getNextSiblingOfType(eq, JetExpression.class);
    }

    @NotNull
    public ASTNode getValOrVarNode() {
        return this.getNode().findChildByType(TokenSet.create(JetTokens.VAL_KEYWORD, JetTokens.VAR_KEYWORD));
    }

    @Nullable
    public ASTNode getEqualsSign() {
        return this.getNode().findChildByType(TokenSet.create(JetTokens.EQ));
    }
}

