/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.lang.ASTNode;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiNameIdentifierOwner;
import org.jetbrains.jet.internal.com.intellij.util.IncorrectOperationException;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetNamed;
import org.jetbrains.jet.lang.psi.JetPsiFactory;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetScript;
import org.jetbrains.jet.lang.psi.JetStatementExpression;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lexer.JetTokens;

public abstract class JetNamedDeclaration
extends JetDeclaration
implements PsiNameIdentifierOwner,
JetNamed,
JetStatementExpression {
    public JetNamedDeclaration(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    public String getName() {
        PsiElement identifier = this.getNameIdentifier();
        if (identifier != null) {
            String text = identifier.getText();
            return text != null ? JetPsiUtil.unquoteIdentifier(text) : null;
        }
        return null;
    }

    @Override
    public Name getNameAsName() {
        String name = this.getName();
        return name != null ? Name.identifier(name) : null;
    }

    @NotNull
    public Name getNameAsSafeName() {
        return JetPsiUtil.safeName(this.getName());
    }

    @Override
    public PsiElement getNameIdentifier() {
        return this.findChildByType(JetTokens.IDENTIFIER);
    }

    @Override
    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        return this.getNameIdentifier().replace(JetPsiFactory.createNameIdentifier(this.getProject(), name));
    }

    @Override
    public int getTextOffset() {
        PsiElement identifier = this.getNameIdentifier();
        return identifier != null ? identifier.getTextRange().getStartOffset() : this.getTextRange().getStartOffset();
    }

    public boolean isScriptDeclaration() {
        return this.getScript() != null;
    }

    @Nullable
    public JetScript getScript() {
        if (this.getParent() != null && this.getParent().getParent() instanceof JetScript) {
            return (JetScript)this.getParent().getParent();
        }
        return null;
    }
}

