/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.JetNodeTypes;
import org.jetbrains.jet.internal.com.intellij.lang.ASTNode;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.tree.IElementType;
import org.jetbrains.jet.lang.psi.JetClassBody;
import org.jetbrains.jet.lang.psi.JetDeclarationWithBody;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetModifierListOwner;
import org.jetbrains.jet.lang.psi.JetNamespaceBody;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetParameterList;
import org.jetbrains.jet.lang.psi.JetTypeParameterListOwner;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lexer.JetTokens;

public abstract class JetFunction
extends JetTypeParameterListOwner
implements JetDeclarationWithBody,
JetModifierListOwner {
    public JetFunction(@NotNull ASTNode node) {
        super(node);
    }

    @Nullable
    public JetParameterList getValueParameterList() {
        return (JetParameterList)this.findChildByType(JetNodeTypes.VALUE_PARAMETER_LIST);
    }

    @Override
    @NotNull
    public List<JetParameter> getValueParameters() {
        JetParameterList list = this.getValueParameterList();
        return list != null ? list.getParameters() : Collections.emptyList();
    }

    @Override
    @Nullable
    public JetExpression getBodyExpression() {
        return this.findChildByClass(JetExpression.class);
    }

    @Override
    public boolean hasDeclaredReturnType() {
        return this.getReturnTypeRef() != null;
    }

    @Nullable
    public JetTypeReference getReceiverTypeRef() {
        IElementType tt;
        for (PsiElement child = this.getFirstChild(); child != null && (tt = child.getNode().getElementType()) != JetTokens.LPAR && tt != JetTokens.COLON; child = child.getNextSibling()) {
            if (!(child instanceof JetTypeReference)) continue;
            return (JetTypeReference)child;
        }
        return null;
    }

    @Nullable
    public JetTypeReference getReturnTypeRef() {
        boolean colonPassed = false;
        for (PsiElement child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            IElementType tt = child.getNode().getElementType();
            if (tt == JetTokens.COLON) {
                colonPassed = true;
            }
            if (!colonPassed || !(child instanceof JetTypeReference)) continue;
            return (JetTypeReference)child;
        }
        return null;
    }

    @Override
    @NotNull
    public JetElement asElement() {
        return this;
    }

    public boolean isLocal() {
        PsiElement parent = this.getParent();
        return !(parent instanceof JetFile) && !(parent instanceof JetClassBody) && !(parent instanceof JetNamespaceBody);
    }
}

