/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.JetNodeTypes;
import org.jetbrains.jet.internal.com.intellij.lang.ASTNode;
import org.jetbrains.jet.internal.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiFile;
import org.jetbrains.jet.internal.com.intellij.psi.StubBasedPsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.stubs.IStubElementType;
import org.jetbrains.jet.internal.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.jet.internal.com.intellij.util.IncorrectOperationException;
import org.jetbrains.jet.lang.psi.JetClassBody;
import org.jetbrains.jet.lang.psi.JetClassInitializer;
import org.jetbrains.jet.lang.psi.JetClassObject;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetDelegationSpecifier;
import org.jetbrains.jet.lang.psi.JetDelegationSpecifierList;
import org.jetbrains.jet.lang.psi.JetDotQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetImportDirective;
import org.jetbrains.jet.lang.psi.JetModifierList;
import org.jetbrains.jet.lang.psi.JetModifierListOwner;
import org.jetbrains.jet.lang.psi.JetObjectDeclarationName;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetParameterList;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetSecondaryConstructor;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetTypeParameterListOwner;
import org.jetbrains.jet.lang.psi.JetUserType;
import org.jetbrains.jet.lang.psi.JetVisitor;
import org.jetbrains.jet.lang.psi.JetVisitorVoid;
import org.jetbrains.jet.lang.psi.stubs.PsiJetClassStub;
import org.jetbrains.jet.lang.psi.stubs.elements.JetStubElementTypes;
import org.jetbrains.jet.lexer.JetTokens;

public class JetClass
extends JetTypeParameterListOwner
implements StubBasedPsiElement<PsiJetClassStub>,
JetClassOrObject,
JetModifierListOwner {
    public JetClass(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    public List<JetDeclaration> getDeclarations() {
        JetClassBody body = (JetClassBody)this.findChildByType(JetNodeTypes.CLASS_BODY);
        if (body == null) {
            return Collections.emptyList();
        }
        return body.getDeclarations();
    }

    @NotNull
    public List<JetSecondaryConstructor> getSecondaryConstructors() {
        JetClassBody body = (JetClassBody)this.findChildByType(JetNodeTypes.CLASS_BODY);
        if (body == null) {
            return Collections.emptyList();
        }
        return body.getSecondaryConstructors();
    }

    @Override
    public void accept(@NotNull JetVisitorVoid visitor) {
        visitor.visitClass(this);
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor, D data) {
        return visitor.visitClass(this, data);
    }

    @Nullable
    public JetParameterList getPrimaryConstructorParameterList() {
        return (JetParameterList)this.findChildByType(JetNodeTypes.VALUE_PARAMETER_LIST);
    }

    @NotNull
    public List<JetParameter> getPrimaryConstructorParameters() {
        JetParameterList list = this.getPrimaryConstructorParameterList();
        if (list == null) {
            return Collections.emptyList();
        }
        return list.getParameters();
    }

    @Override
    @Nullable
    public JetDelegationSpecifierList getDelegationSpecifierList() {
        return (JetDelegationSpecifierList)this.findChildByType(JetNodeTypes.DELEGATION_SPECIFIER_LIST);
    }

    @Override
    @NotNull
    public List<JetDelegationSpecifier> getDelegationSpecifiers() {
        JetDelegationSpecifierList list = this.getDelegationSpecifierList();
        return list != null ? list.getDelegationSpecifiers() : Collections.emptyList();
    }

    @Nullable
    public JetModifierList getPrimaryConstructorModifierList() {
        return (JetModifierList)this.findChildByType(JetNodeTypes.PRIMARY_CONSTRUCTOR_MODIFIER_LIST);
    }

    @Override
    @NotNull
    public List<JetClassInitializer> getAnonymousInitializers() {
        JetClassBody body = this.getBody();
        if (body == null) {
            return Collections.emptyList();
        }
        return body.getAnonymousInitializers();
    }

    @Override
    public boolean hasPrimaryConstructor() {
        return this.getPrimaryConstructorParameterList() != null;
    }

    @Override
    public JetObjectDeclarationName getNameAsDeclaration() {
        return (JetObjectDeclarationName)this.findChildByType(JetNodeTypes.OBJECT_DECLARATION_NAME);
    }

    @Override
    public JetClassBody getBody() {
        return (JetClassBody)this.findChildByType(JetNodeTypes.CLASS_BODY);
    }

    @Nullable
    public JetClassObject getClassObject() {
        JetClassBody body = this.getBody();
        if (body == null) {
            return null;
        }
        return body.getClassObject();
    }

    public List<JetProperty> getProperties() {
        JetClassBody body = this.getBody();
        if (body == null) {
            return Collections.emptyList();
        }
        return body.getProperties();
    }

    public boolean isTrait() {
        return this.findChildByType(JetTokens.TRAIT_KEYWORD) != null;
    }

    public boolean isAnnotation() {
        return this.hasModifier(JetTokens.ANNOTATION_KEYWORD);
    }

    @Override
    public IStubElementType getElementType() {
        return JetStubElementTypes.CLASS;
    }

    @Override
    public PsiJetClassStub getStub() {
        return null;
    }

    @Override
    public void delete() throws IncorrectOperationException {
        JetPsiUtil.deleteClass(this);
    }

    @Override
    public boolean isEquivalentTo(PsiElement another) {
        if (super.isEquivalentTo(another)) {
            return true;
        }
        if (another instanceof JetClass) {
            String fq1 = this.getQualifiedName();
            String fq2 = ((JetClass)another).getQualifiedName();
            return fq1 != null && fq2 != null && fq1.equals(fq2);
        }
        return false;
    }

    @Nullable
    private String getQualifiedName() {
        ArrayList<String> parts = new ArrayList<String>();
        JetClassOrObject current = this;
        while (current != null) {
            parts.add(current.getName());
            current = PsiTreeUtil.getParentOfType((PsiElement)current, JetClassOrObject.class);
        }
        PsiFile file = this.getContainingFile();
        if (!(file instanceof JetFile)) {
            return null;
        }
        String fileQualifiedName = ((JetFile)file).getNamespaceHeader().getQualifiedName();
        if (!fileQualifiedName.isEmpty()) {
            parts.add(fileQualifiedName);
        }
        Collections.reverse(parts);
        return StringUtil.join(parts, ".");
    }

    @NotNull
    public List<String> getSuperNames() {
        List<JetDelegationSpecifier> specifiers = this.getDelegationSpecifiers();
        if (specifiers.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (JetDelegationSpecifier specifier : specifiers) {
            String referencedName;
            JetUserType superType = specifier.getTypeAsUserType();
            if (superType == null || (referencedName = superType.getReferencedName()) == null) continue;
            this.addSuperName(result, referencedName);
        }
        return result;
    }

    private void addSuperName(List<String> result, String referencedName) {
        JetImportDirective directive;
        result.add(referencedName);
        if (this.getContainingFile() instanceof JetFile && (directive = ((JetFile)this.getContainingFile()).findImportByAlias(referencedName)) != null) {
            JetExpression reference = directive.getImportedReference();
            while (reference instanceof JetDotQualifiedExpression) {
                reference = ((JetDotQualifiedExpression)reference).getSelectorExpression();
            }
            if (reference instanceof JetSimpleNameExpression) {
                result.add(((JetSimpleNameExpression)reference).getReferencedName());
            }
        }
    }
}

