/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.JetNodeTypes;
import org.jetbrains.jet.internal.com.intellij.lang.ASTNode;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetParameterList;
import org.jetbrains.jet.lang.psi.JetVisitor;
import org.jetbrains.jet.lang.psi.JetVisitorVoid;

public class JetCatchClause
extends JetElement {
    public JetCatchClause(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    public void accept(@NotNull JetVisitorVoid visitor) {
        visitor.visitCatchSection(this);
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor, D data) {
        return visitor.visitCatchSection(this, data);
    }

    @JetElement.IfNotParsed
    @Nullable
    public JetParameterList getParameterList() {
        return (JetParameterList)this.findChildByType(JetNodeTypes.VALUE_PARAMETER_LIST);
    }

    @JetElement.IfNotParsed
    @Nullable
    public JetParameter getCatchParameter() {
        JetParameterList list = this.getParameterList();
        if (list == null) {
            return null;
        }
        List<JetParameter> parameters = list.getParameters();
        return parameters.size() == 1 ? parameters.get(0) : null;
    }

    @JetElement.IfNotParsed
    @Nullable
    public JetExpression getCatchBody() {
        return this.findChildByClass(JetExpression.class);
    }
}

