/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.parsing;

import java.util.Stack;
import org.jetbrains.jet.internal.com.intellij.lang.PsiBuilder;
import org.jetbrains.jet.internal.com.intellij.lang.impl.PsiBuilderAdapter;
import org.jetbrains.jet.internal.com.intellij.psi.TokenType;
import org.jetbrains.jet.internal.com.intellij.psi.tree.IElementType;
import org.jetbrains.jet.internal.com.intellij.psi.tree.TokenSet;
import org.jetbrains.jet.lang.parsing.SemanticWhitespaceAwarePsiBuilder;
import org.jetbrains.jet.lexer.JetTokens;

public class SemanticWhitespaceAwarePsiBuilderImpl
extends PsiBuilderAdapter
implements SemanticWhitespaceAwarePsiBuilder {
    private final TokenSet complexTokens = TokenSet.create(JetTokens.SAFE_ACCESS, JetTokens.ELVIS, JetTokens.EXCLEXCL);
    private final Stack<Boolean> joinComplexTokens = new Stack();
    private final Stack<Boolean> newlinesEnabled = new Stack();

    public SemanticWhitespaceAwarePsiBuilderImpl(PsiBuilder delegate) {
        super(delegate);
        this.newlinesEnabled.push(true);
        this.joinComplexTokens.push(true);
    }

    @Override
    public boolean newlineBeforeCurrentToken() {
        if (!this.newlinesEnabled.peek().booleanValue()) {
            return false;
        }
        if (this.eof()) {
            return true;
        }
        for (int i = 1; i <= this.getCurrentOffset(); ++i) {
            IElementType previousToken = this.rawLookup(-i);
            if (previousToken == JetTokens.BLOCK_COMMENT || previousToken == JetTokens.DOC_COMMENT || previousToken == JetTokens.EOL_COMMENT || previousToken == JetTokens.SHEBANG_COMMENT) continue;
            if (previousToken != TokenType.WHITE_SPACE) break;
            int previousTokenStart = this.rawTokenTypeStart(-i);
            int previousTokenEnd = this.rawTokenTypeStart(-i + 1);
            assert (previousTokenStart >= 0);
            assert (previousTokenEnd < this.getOriginalText().length());
            for (int j = previousTokenStart; j < previousTokenEnd; ++j) {
                if (this.getOriginalText().charAt(j) != '\n') continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void disableNewlines() {
        this.newlinesEnabled.push(false);
    }

    @Override
    public void enableNewlines() {
        this.newlinesEnabled.push(true);
    }

    @Override
    public void restoreNewlinesState() {
        assert (this.newlinesEnabled.size() > 1);
        this.newlinesEnabled.pop();
    }

    private boolean joinComplexTokens() {
        return this.joinComplexTokens.peek();
    }

    @Override
    public void restoreJoiningComplexTokensState() {
        this.joinComplexTokens.pop();
    }

    @Override
    public void enableJoiningComplexTokens() {
        this.joinComplexTokens.push(true);
    }

    @Override
    public void disableJoiningComplexTokens() {
        this.joinComplexTokens.push(false);
    }

    @Override
    public IElementType getTokenType() {
        if (!this.joinComplexTokens()) {
            return super.getTokenType();
        }
        return this.getJoinedTokenType(super.getTokenType(), 1);
    }

    private IElementType getJoinedTokenType(IElementType rawTokenType, int rawLookupSteps) {
        IElementType nextRawToken;
        if (rawTokenType == JetTokens.QUEST) {
            IElementType nextRawToken2 = this.rawLookup(rawLookupSteps);
            if (nextRawToken2 == JetTokens.DOT) {
                return JetTokens.SAFE_ACCESS;
            }
            if (nextRawToken2 == JetTokens.COLON) {
                return JetTokens.ELVIS;
            }
        } else if (rawTokenType == JetTokens.EXCL && (nextRawToken = this.rawLookup(rawLookupSteps)) == JetTokens.EXCL) {
            return JetTokens.EXCLEXCL;
        }
        return rawTokenType;
    }

    @Override
    public void advanceLexer() {
        if (!this.joinComplexTokens()) {
            super.advanceLexer();
            return;
        }
        IElementType tokenType = this.getTokenType();
        if (this.complexTokens.contains(tokenType)) {
            PsiBuilder.Marker mark = this.mark();
            super.advanceLexer();
            super.advanceLexer();
            mark.collapse(tokenType);
        } else {
            super.advanceLexer();
        }
    }

    @Override
    public String getTokenText() {
        if (!this.joinComplexTokens()) {
            return super.getTokenText();
        }
        IElementType tokenType = this.getTokenType();
        if (this.complexTokens.contains(tokenType)) {
            if (tokenType == JetTokens.ELVIS) {
                return "?:";
            }
            if (tokenType == JetTokens.SAFE_ACCESS) {
                return "?.";
            }
        }
        return super.getTokenText();
    }

    @Override
    public IElementType lookAhead(int steps) {
        if (!this.joinComplexTokens()) {
            return super.lookAhead(steps);
        }
        if (this.complexTokens.contains(this.getTokenType())) {
            return super.lookAhead(steps + 1);
        }
        return this.getJoinedTokenType(super.lookAhead(steps), 2);
    }
}

