/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.diagnostics.rendering;

import java.util.Collection;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.Named;
import org.jetbrains.jet.lang.diagnostics.rendering.Renderer;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.resolve.calls.ResolvedCall;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.resolve.DescriptorRenderer;

public class Renderers {
    public static final Renderer<Object> TO_STRING = new Renderer<Object>(){

        @Override
        @NotNull
        public String render(@NotNull Object element) {
            return element.toString();
        }

        public String toString() {
            return "TO_STRING";
        }
    };
    public static final Renderer<Object> NAME = new Renderer<Object>(){

        @Override
        @NotNull
        public String render(@NotNull Object element) {
            if (element instanceof Named) {
                return ((Named)element).getName().getName();
            }
            return element.toString();
        }
    };
    public static final Renderer<PsiElement> ELEMENT_TEXT = new Renderer<PsiElement>(){

        @Override
        @NotNull
        public String render(@NotNull PsiElement element) {
            return element.getText();
        }
    };
    public static final Renderer<JetClassOrObject> RENDER_CLASS_OR_OBJECT = new Renderer<JetClassOrObject>(){

        @Override
        @NotNull
        public String render(@NotNull JetClassOrObject classOrObject) {
            String name;
            String string = name = classOrObject.getName() != null ? " '" + classOrObject.getName() + "'" : "";
            if (classOrObject instanceof JetClass) {
                return "Class" + name;
            }
            return "Object" + name;
        }
    };
    public static final Renderer<JetType> RENDER_TYPE = new Renderer<JetType>(){

        @Override
        @NotNull
        public String render(@NotNull JetType type) {
            return DescriptorRenderer.TEXT.renderType(type);
        }
    };
    public static final Renderer<Collection<? extends ResolvedCall<? extends CallableDescriptor>>> AMBIGUOUS_CALLS = new Renderer<Collection<? extends ResolvedCall<? extends CallableDescriptor>>>(){

        @Override
        @NotNull
        public String render(@NotNull Collection<? extends ResolvedCall<? extends CallableDescriptor>> argument) {
            StringBuilder stringBuilder = new StringBuilder("\n");
            for (ResolvedCall<? extends CallableDescriptor> resolvedCall : argument) {
                stringBuilder.append(DescriptorRenderer.TEXT.render(resolvedCall.getResultingDescriptor())).append("\n");
            }
            return stringBuilder.toString();
        }
    };

    public static <T> Renderer<Collection<? extends T>> commaSeparated(final Renderer<T> itemRenderer) {
        return new Renderer<Collection<? extends T>>(){

            @Override
            @NotNull
            public String render(@NotNull Collection<? extends T> object) {
                StringBuilder result = new StringBuilder();
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    Object next = iterator.next();
                    result.append(itemRenderer.render(next));
                    if (!iterator.hasNext()) continue;
                    result.append(", ");
                }
                return result.toString();
            }
        };
    }

    private Renderers() {
    }
}

