/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.diagnostics.rendering;

import java.text.MessageFormat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.diagnostics.DiagnosticWithParameters2;
import org.jetbrains.jet.lang.diagnostics.rendering.DiagnosticRenderer;
import org.jetbrains.jet.lang.diagnostics.rendering.DiagnosticRendererUtil;
import org.jetbrains.jet.lang.diagnostics.rendering.Renderer;

public class DiagnosticWithParameters2Renderer<A, B>
implements DiagnosticRenderer<DiagnosticWithParameters2<?, A, B>> {
    private final MessageFormat messageFormat;
    private final Renderer<? super A> rendererForA;
    private final Renderer<? super B> rendererForB;

    public DiagnosticWithParameters2Renderer(@NotNull String message, @Nullable Renderer<? super A> rendererForA, @Nullable Renderer<? super B> rendererForB) {
        this.messageFormat = new MessageFormat(message);
        this.rendererForA = rendererForA;
        this.rendererForB = rendererForB;
    }

    @Override
    @NotNull
    public String render(@NotNull DiagnosticWithParameters2<?, A, B> diagnostic) {
        return this.messageFormat.format(new Object[]{DiagnosticRendererUtil.renderParameter(diagnostic.getA(), this.rendererForA), DiagnosticRendererUtil.renderParameter(diagnostic.getB(), this.rendererForB)});
    }
}

