/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.diagnostics.rendering;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.lang.diagnostics.AbstractDiagnosticFactory;
import org.jetbrains.jet.lang.diagnostics.DiagnosticFactory1;
import org.jetbrains.jet.lang.diagnostics.DiagnosticFactory2;
import org.jetbrains.jet.lang.diagnostics.DiagnosticFactory3;
import org.jetbrains.jet.lang.diagnostics.SimpleDiagnosticFactory;
import org.jetbrains.jet.lang.diagnostics.rendering.DiagnosticRenderer;
import org.jetbrains.jet.lang.diagnostics.rendering.DiagnosticWithParameters1Renderer;
import org.jetbrains.jet.lang.diagnostics.rendering.DiagnosticWithParameters2Renderer;
import org.jetbrains.jet.lang.diagnostics.rendering.DiagnosticWithParameters3Renderer;
import org.jetbrains.jet.lang.diagnostics.rendering.Renderer;
import org.jetbrains.jet.lang.diagnostics.rendering.SimpleDiagnosticRenderer;

public final class DiagnosticFactoryToRendererMap {
    private final Map<AbstractDiagnosticFactory, DiagnosticRenderer<?>> map = new HashMap();
    private boolean immutable = false;

    private void checkMutability() {
        if (this.immutable) {
            throw new IllegalStateException("factory to renderer map is already immutable");
        }
    }

    public <E extends PsiElement> void put(@NotNull SimpleDiagnosticFactory<E> factory, @NotNull String message) {
        this.checkMutability();
        this.map.put(factory, new SimpleDiagnosticRenderer(message));
    }

    public <E extends PsiElement, A> void put(@NotNull DiagnosticFactory1<E, A> factory, @NotNull String message, @Nullable Renderer<? super A> rendererA) {
        this.checkMutability();
        this.map.put(factory, new DiagnosticWithParameters1Renderer<A>(message, rendererA));
    }

    public <E extends PsiElement, A, B> void put(@NotNull DiagnosticFactory2<E, A, B> factory, @NotNull String message, @Nullable Renderer<? super A> rendererA, @Nullable Renderer<? super B> rendererB) {
        this.checkMutability();
        this.map.put(factory, new DiagnosticWithParameters2Renderer<A, B>(message, rendererA, rendererB));
    }

    public <E extends PsiElement, A, B, C> void put(@NotNull DiagnosticFactory3<E, A, B, C> factory, @NotNull String message, @Nullable Renderer<? super A> rendererA, @Nullable Renderer<? super B> rendererB, @Nullable Renderer<? super C> rendererC) {
        this.checkMutability();
        this.map.put(factory, new DiagnosticWithParameters3Renderer<A, B, C>(message, rendererA, rendererB, rendererC));
    }

    @Nullable
    public DiagnosticRenderer<?> get(@NotNull AbstractDiagnosticFactory factory) {
        return this.map.get(factory);
    }

    public void setImmutable() {
        this.immutable = false;
    }
}

