/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.diagnostics;

import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.openapi.util.TextRange;
import org.jetbrains.jet.lang.diagnostics.DiagnosticFactory1;
import org.jetbrains.jet.lang.diagnostics.DiagnosticWithParameters1;
import org.jetbrains.jet.lang.diagnostics.PositioningStrategy;
import org.jetbrains.jet.lang.diagnostics.Severity;
import org.jetbrains.jet.lang.psi.JetArrayAccessExpression;
import org.jetbrains.jet.lang.psi.JetReferenceExpression;

public class UnresolvedReferenceDiagnosticFactory
extends DiagnosticFactory1<JetReferenceExpression, String> {
    public UnresolvedReferenceDiagnosticFactory() {
        super(Severity.ERROR, new PositioningStrategy<JetReferenceExpression>(){

            @Override
            @NotNull
            public List<TextRange> mark(@NotNull JetReferenceExpression element) {
                List<TextRange> ranges;
                if (element instanceof JetArrayAccessExpression && !(ranges = ((JetArrayAccessExpression)element).getBracketRanges()).isEmpty()) {
                    return ranges;
                }
                return Collections.singletonList(element.getTextRange());
            }
        });
    }

    public DiagnosticWithParameters1<JetReferenceExpression, String> on(@NotNull JetReferenceExpression reference) {
        return new DiagnosticWithParameters1<JetReferenceExpression, String>(reference, reference.getText(), this, this.severity);
    }

    public static UnresolvedReferenceDiagnosticFactory create() {
        return new UnresolvedReferenceDiagnosticFactory();
    }
}

