/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.diagnostics;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.openapi.util.TextRange;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.lang.diagnostics.DiagnosticFactory1;
import org.jetbrains.jet.lang.diagnostics.PositioningStrategy;
import org.jetbrains.jet.lang.diagnostics.Severity;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetNamedDeclaration;

public class RedeclarationDiagnosticFactory
extends DiagnosticFactory1<PsiElement, String> {
    private static final PositioningStrategy<PsiElement> POSITION_REDECLARATION = new PositioningStrategy<PsiElement>(){

        @Override
        @NotNull
        public List<TextRange> mark(@NotNull PsiElement element) {
            JetFile file;
            PsiElement nameIdentifier;
            if (element instanceof JetNamedDeclaration) {
                PsiElement nameIdentifier2 = ((JetNamedDeclaration)element).getNameIdentifier();
                if (nameIdentifier2 != null) {
                    return 1.markElement(nameIdentifier2);
                }
            } else if (element instanceof JetFile && (nameIdentifier = (file = (JetFile)element).getNamespaceHeader().getNameIdentifier()) != null) {
                return 1.markElement(nameIdentifier);
            }
            return 1.markElement(element);
        }
    };

    public RedeclarationDiagnosticFactory(Severity severity) {
        super(severity, POSITION_REDECLARATION);
    }
}

