/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.diagnostics;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.google.common.collect.Lists;
import org.jetbrains.jet.internal.com.intellij.lang.ASTNode;
import org.jetbrains.jet.internal.com.intellij.openapi.util.TextRange;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiNameIdentifierOwner;
import org.jetbrains.jet.lang.diagnostics.PositioningStrategy;
import org.jetbrains.jet.lang.psi.JetArrayAccessExpression;
import org.jetbrains.jet.lang.psi.JetBlockExpression;
import org.jetbrains.jet.lang.psi.JetCallElement;
import org.jetbrains.jet.lang.psi.JetCallExpression;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetDeclarationWithBody;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetModifierList;
import org.jetbrains.jet.lang.psi.JetModifierListOwner;
import org.jetbrains.jet.lang.psi.JetNamedDeclaration;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetNullableType;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetParameterList;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetPropertyAccessor;
import org.jetbrains.jet.lang.psi.JetTypeArgumentList;
import org.jetbrains.jet.lang.psi.JetTypeProjection;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.psi.JetWhenConditionInRange;
import org.jetbrains.jet.lang.psi.JetWhenEntry;
import org.jetbrains.jet.lang.psi.JetWhenExpression;
import org.jetbrains.jet.lexer.JetKeywordToken;
import org.jetbrains.jet.lexer.JetTokens;

public class PositioningStrategies {
    public static final PositioningStrategy<PsiElement> DEFAULT = new PositioningStrategy();
    public static final PositioningStrategy<JetDeclaration> DECLARATION_RETURN_TYPE = new PositioningStrategy<JetDeclaration>(){

        @Override
        @NotNull
        public List<TextRange> mark(@NotNull JetDeclaration declaration) {
            JetTypeReference returnTypeRef = null;
            ASTNode nameNode = null;
            if (declaration instanceof JetNamedFunction) {
                JetNamedFunction function = (JetNamedFunction)declaration;
                returnTypeRef = function.getReturnTypeRef();
                nameNode = this.getNameNode(function);
            } else if (declaration instanceof JetProperty) {
                JetProperty property = (JetProperty)declaration;
                returnTypeRef = property.getPropertyTypeRef();
                nameNode = this.getNameNode(property);
            } else if (declaration instanceof JetPropertyAccessor) {
                JetPropertyAccessor accessor = (JetPropertyAccessor)declaration;
                returnTypeRef = accessor.getReturnTypeReference();
                nameNode = accessor.getNamePlaceholder().getNode();
            }
            if (returnTypeRef != null) {
                return 1.markElement(returnTypeRef);
            }
            if (nameNode != null) {
                return 1.markNode(nameNode);
            }
            return 1.markElement(declaration);
        }

        private ASTNode getNameNode(JetNamedDeclaration function) {
            PsiElement nameIdentifier = function.getNameIdentifier();
            return nameIdentifier == null ? null : nameIdentifier.getNode();
        }
    };
    public static final PositioningStrategy<PsiNameIdentifierOwner> NAME_IDENTIFIER = new PositioningStrategy<PsiNameIdentifierOwner>(){

        @Override
        @NotNull
        public List<TextRange> mark(@NotNull PsiNameIdentifierOwner element) {
            PsiElement nameIdentifier = element.getNameIdentifier();
            if (nameIdentifier != null) {
                return 2.markElement(nameIdentifier);
            }
            return 2.markElement(element);
        }
    };
    public static final PositioningStrategy<PsiNameIdentifierOwner> NAMED_ELEMENT = new PositioningStrategy<PsiNameIdentifierOwner>(){

        @Override
        @NotNull
        public List<TextRange> mark(@NotNull PsiNameIdentifierOwner element) {
            if (element instanceof JetNamedFunction) {
                JetNamedFunction function = (JetNamedFunction)element;
                JetParameterList valueParameterList = function.getValueParameterList();
                JetTypeReference returnTypeRef = function.getReturnTypeRef();
                PsiElement nameIdentifier = function.getNameIdentifier();
                PsiElement endOfSignatureElement = returnTypeRef != null ? returnTypeRef : (valueParameterList != null ? valueParameterList : (nameIdentifier != null ? nameIdentifier : function));
                return 3.markRange(new TextRange(function.getTextRange().getStartOffset(), endOfSignatureElement.getTextRange().getEndOffset()));
            }
            if (element instanceof JetProperty) {
                JetProperty property = (JetProperty)element;
                JetTypeReference propertyTypeRef = property.getPropertyTypeRef();
                PsiElement nameIdentifier = property.getNameIdentifier();
                PsiElement endOfSignatureElement = propertyTypeRef != null ? propertyTypeRef : (nameIdentifier != null ? nameIdentifier : property);
                return 3.markRange(new TextRange(property.getTextRange().getStartOffset(), endOfSignatureElement.getTextRange().getEndOffset()));
            }
            if (element instanceof JetClass) {
                JetClass klass = (JetClass)element;
                PsiElement nameAsDeclaration = klass.getNameIdentifier();
                if (nameAsDeclaration == null) {
                    return 3.markElement(klass);
                }
                JetParameterList primaryConstructorParameterList = klass.getPrimaryConstructorParameterList();
                if (primaryConstructorParameterList == null) {
                    return 3.markRange(nameAsDeclaration.getTextRange());
                }
                return 3.markRange(new TextRange(nameAsDeclaration.getTextRange().getStartOffset(), primaryConstructorParameterList.getTextRange().getEndOffset()));
            }
            return super.mark(element);
        }

        @Override
        public boolean isValid(@NotNull PsiNameIdentifierOwner element) {
            return element.getNameIdentifier() != null;
        }
    };
    public static final PositioningStrategy<JetDeclaration> DECLARATION = new PositioningStrategy<JetDeclaration>(){

        @Override
        @NotNull
        public List<TextRange> mark(@NotNull JetDeclaration element) {
            if (element instanceof PsiNameIdentifierOwner) {
                return NAMED_ELEMENT.mark((PsiNameIdentifierOwner)((Object)element));
            }
            return super.mark(element);
        }

        @Override
        public boolean isValid(@NotNull JetDeclaration element) {
            if (element instanceof PsiNameIdentifierOwner) {
                return NAMED_ELEMENT.isValid((PsiNameIdentifierOwner)((Object)element));
            }
            return super.isValid(element);
        }
    };
    public static final PositioningStrategy<JetModifierListOwner> ABSTRACT_MODIFIER = PositioningStrategies.positionModifier(JetTokens.ABSTRACT_KEYWORD);
    public static final PositioningStrategy<JetModifierListOwner> OVERRIDE_MODIFIER = PositioningStrategies.positionModifier(JetTokens.OVERRIDE_KEYWORD);
    public static PositioningStrategy<JetArrayAccessExpression> ARRAY_ACCESS = new PositioningStrategy<JetArrayAccessExpression>(){

        @Override
        @NotNull
        public List<TextRange> mark(@NotNull JetArrayAccessExpression element) {
            return 6.markElement(element.getIndicesNode());
        }
    };
    public static PositioningStrategy<JetModifierListOwner> VISIBILITY_MODIFIER = new PositioningStrategy<JetModifierListOwner>(){

        @Override
        @NotNull
        public List<TextRange> mark(@NotNull JetModifierListOwner element) {
            ArrayList<JetKeywordToken> visibilityTokens = Lists.newArrayList(JetTokens.PRIVATE_KEYWORD, JetTokens.PROTECTED_KEYWORD, JetTokens.PUBLIC_KEYWORD, JetTokens.INTERNAL_KEYWORD);
            ArrayList<TextRange> result = Lists.newArrayList();
            for (JetKeywordToken token : visibilityTokens) {
                if (!element.hasModifier(token)) continue;
                result.add(element.getModifierList().getModifierNode(token).getTextRange());
            }
            if (result.isEmpty() && element.hasModifier(JetTokens.OVERRIDE_KEYWORD)) {
                result.add(element.getModifierList().getModifierNode(JetTokens.OVERRIDE_KEYWORD).getTextRange());
            }
            return result;
        }
    };
    public static PositioningStrategy<JetTypeProjection> PROJECTION_MODIFIER = new PositioningStrategy<JetTypeProjection>(){

        @Override
        @NotNull
        public List<TextRange> mark(@NotNull JetTypeProjection element) {
            return 8.markNode(element.getProjectionNode());
        }
    };
    public static PositioningStrategy<JetParameter> PARAMETER_DEFAULT_VALUE = new PositioningStrategy<JetParameter>(){

        @Override
        @NotNull
        public List<TextRange> mark(@NotNull JetParameter element) {
            return 9.markNode(element.getDefaultValue().getNode());
        }
    };
    public static PositioningStrategy<PsiElement> CALL_ELEMENT = new PositioningStrategy<PsiElement>(){

        @Override
        @NotNull
        public List<TextRange> mark(@NotNull PsiElement callElement) {
            JetExpression calleeExpression;
            if (callElement instanceof JetCallElement && (calleeExpression = ((JetCallElement)callElement).getCalleeExpression()) != null) {
                return 10.markElement(calleeExpression);
            }
            return 10.markElement(callElement);
        }
    };
    public static PositioningStrategy<JetDeclarationWithBody> DECLARATION_WITH_BODY = new PositioningStrategy<JetDeclarationWithBody>(){

        @Override
        @NotNull
        public List<TextRange> mark(@NotNull JetDeclarationWithBody element) {
            TextRange lastBracketRange;
            JetExpression bodyExpression = element.getBodyExpression();
            if (bodyExpression instanceof JetBlockExpression && (lastBracketRange = ((JetBlockExpression)bodyExpression).getLastBracketRange()) != null) {
                return 11.markRange(lastBracketRange);
            }
            return 11.markElement(element);
        }

        @Override
        public boolean isValid(@NotNull JetDeclarationWithBody element) {
            JetExpression bodyExpression = element.getBodyExpression();
            if (!(bodyExpression instanceof JetBlockExpression)) {
                return false;
            }
            return ((JetBlockExpression)bodyExpression).getLastBracketRange() != null;
        }
    };
    public static PositioningStrategy<JetWhenEntry> ELSE_ENTRY = new PositioningStrategy<JetWhenEntry>(){

        @Override
        @NotNull
        public List<TextRange> mark(@NotNull JetWhenEntry entry) {
            PsiElement elseKeywordElement = entry.getElseKeywordElement();
            assert (elseKeywordElement != null);
            return 12.markElement(elseKeywordElement);
        }
    };
    public static PositioningStrategy<JetWhenExpression> WHEN_EXPRESSION = new PositioningStrategy<JetWhenExpression>(){

        @Override
        @NotNull
        public List<TextRange> mark(@NotNull JetWhenExpression element) {
            return 13.markElement(element.getWhenKeywordElement());
        }
    };
    public static PositioningStrategy<JetWhenConditionInRange> WHEN_CONDITION_IN_RANGE = new PositioningStrategy<JetWhenConditionInRange>(){

        @Override
        @NotNull
        public List<TextRange> mark(@NotNull JetWhenConditionInRange condition) {
            return 14.markElement(condition.getOperationReference());
        }
    };
    public static PositioningStrategy<JetNullableType> NULLABLE_TYPE = new PositioningStrategy<JetNullableType>(){

        @Override
        @NotNull
        public List<TextRange> mark(@NotNull JetNullableType element) {
            return 15.markNode(element.getQuestionMarkNode());
        }
    };
    public static PositioningStrategy<JetExpression> CALL_EXPRESSION = new PositioningStrategy<JetExpression>(){

        @Override
        @NotNull
        public List<TextRange> mark(@NotNull JetExpression element) {
            if (element instanceof JetCallExpression) {
                JetCallExpression callExpression = (JetCallExpression)element;
                JetTypeArgumentList typeArgumentList = callExpression.getTypeArgumentList();
                JetExpression calleeExpression = callExpression.getCalleeExpression();
                JetElement endElement = typeArgumentList != null ? typeArgumentList : (calleeExpression != null ? calleeExpression : element);
                return 16.markRange(new TextRange(element.getTextRange().getStartOffset(), endElement.getTextRange().getEndOffset()));
            }
            return super.mark(element);
        }
    };

    public static PositioningStrategy<JetModifierListOwner> positionModifier(final JetKeywordToken token) {
        return new PositioningStrategy<JetModifierListOwner>(){

            @Override
            @NotNull
            public List<TextRange> mark(@NotNull JetModifierListOwner modifierListOwner) {
                assert (modifierListOwner.hasModifier(token));
                JetModifierList modifierList = modifierListOwner.getModifierList();
                assert (modifierList != null);
                ASTNode node = modifierList.getModifierNode(token);
                assert (node != null);
                return 5.markNode(node);
            }
        };
    }
}

