/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.diagnostics;

import java.util.List;
import org.jetbrains.jet.internal.com.intellij.openapi.util.TextRange;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.lang.diagnostics.AbstractDiagnosticFactory;
import org.jetbrains.jet.lang.diagnostics.ParametrizedDiagnostic;
import org.jetbrains.jet.lang.diagnostics.PositioningStrategy;
import org.jetbrains.jet.lang.diagnostics.Severity;

public abstract class DiagnosticFactoryWithPsiElement<E extends PsiElement>
extends AbstractDiagnosticFactory {
    protected final Severity severity;
    protected final PositioningStrategy<? super E> positioningStrategy;

    public DiagnosticFactoryWithPsiElement(Severity severity, PositioningStrategy<? super E> positioningStrategy) {
        this.severity = severity;
        this.positioningStrategy = positioningStrategy;
    }

    protected List<TextRange> getTextRanges(ParametrizedDiagnostic<E> diagnostic) {
        return this.positioningStrategy.mark(diagnostic.getPsiElement());
    }

    protected boolean isValid(ParametrizedDiagnostic<E> diagnostic) {
        return this.positioningStrategy.isValid(diagnostic.getPsiElement());
    }
}

