/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.diagnostics;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.openapi.util.TextRange;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiErrorElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiFile;
import org.jetbrains.jet.lang.diagnostics.DiagnosticFactoryWithPsiElement;
import org.jetbrains.jet.lang.diagnostics.ParametrizedDiagnostic;
import org.jetbrains.jet.lang.diagnostics.Severity;

public abstract class AbstractDiagnostic<E extends PsiElement>
implements ParametrizedDiagnostic<E> {
    private final E psiElement;
    private final DiagnosticFactoryWithPsiElement<E> factory;
    private final Severity severity;

    public AbstractDiagnostic(@NotNull E psiElement, @NotNull DiagnosticFactoryWithPsiElement<E> factory, @NotNull Severity severity) {
        this.psiElement = psiElement;
        this.factory = factory;
        this.severity = severity;
    }

    @Override
    @NotNull
    public DiagnosticFactoryWithPsiElement<E> getFactory() {
        return this.factory;
    }

    @Override
    @NotNull
    public PsiFile getPsiFile() {
        return this.psiElement.getContainingFile();
    }

    @Override
    @NotNull
    public Severity getSeverity() {
        return this.severity;
    }

    @Override
    @NotNull
    public E getPsiElement() {
        return this.psiElement;
    }

    @Override
    @NotNull
    public List<TextRange> getTextRanges() {
        return ((DiagnosticFactoryWithPsiElement)this.getFactory()).getTextRanges(this);
    }

    @Override
    public boolean isValid() {
        if (!((DiagnosticFactoryWithPsiElement)this.getFactory()).isValid(this)) {
            return false;
        }
        return !AbstractDiagnostic.hasSyntaxErrors(this.psiElement);
    }

    private static boolean hasSyntaxErrors(@NotNull PsiElement psiElement) {
        if (psiElement instanceof PsiErrorElement) {
            return true;
        }
        PsiElement lastChild = psiElement.getLastChild();
        if (lastChild != null && AbstractDiagnostic.hasSyntaxErrors(lastChild)) {
            return true;
        }
        PsiElement[] children = psiElement.getChildren();
        return children.length > 0 && AbstractDiagnostic.hasSyntaxErrors(children[children.length - 1]);
    }
}

