/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.descriptors;

import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.google.common.collect.Maps;
import org.jetbrains.jet.internal.com.google.common.collect.Sets;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibility;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;

public class Visibilities {
    public static final Visibility PRIVATE = new Visibility("private", false){

        @Override
        protected boolean isVisible(@NotNull DeclarationDescriptorWithVisibility what, @NotNull DeclarationDescriptor from) {
            DeclarationDescriptor parent = what;
            while (!(parent == null || (parent = parent.getContainingDeclaration()) instanceof ClassDescriptor && !DescriptorUtils.isClassObject(parent) || parent instanceof NamespaceDescriptor)) {
            }
            for (DeclarationDescriptor fromParent = from; fromParent != null; fromParent = fromParent.getContainingDeclaration()) {
                if (parent != fromParent) continue;
                return true;
            }
            return false;
        }
    };
    public static final Visibility PROTECTED = new Visibility("protected", true){

        @Override
        protected boolean isVisible(@NotNull DeclarationDescriptorWithVisibility what, @NotNull DeclarationDescriptor from) {
            ClassDescriptor classDescriptor = DescriptorUtils.getParentOfType(what, ClassDescriptor.class);
            if (classDescriptor == null) {
                return false;
            }
            ClassDescriptor fromClass = DescriptorUtils.getParentOfType(from, ClassDescriptor.class, false);
            if (fromClass == null) {
                return false;
            }
            return DescriptorUtils.isSubclass(fromClass, classDescriptor);
        }
    };
    public static final Visibility INTERNAL = new Visibility("internal", false){

        @Override
        protected boolean isVisible(@NotNull DeclarationDescriptorWithVisibility what, @NotNull DeclarationDescriptor from) {
            ModuleDescriptor parentModule = DescriptorUtils.getParentOfType(what, ModuleDescriptor.class, false);
            ModuleDescriptor fromModule = DescriptorUtils.getParentOfType(from, ModuleDescriptor.class, false);
            assert (parentModule != null && fromModule != null);
            return parentModule.equals(fromModule);
        }
    };
    public static final Visibility PUBLIC = new Visibility("public", true){

        @Override
        protected boolean isVisible(@NotNull DeclarationDescriptorWithVisibility what, @NotNull DeclarationDescriptor from) {
            return true;
        }
    };
    public static final Visibility INTERNAL_PROTECTED = new Visibility("internal protected", false){

        @Override
        protected boolean isVisible(@NotNull DeclarationDescriptorWithVisibility what, @NotNull DeclarationDescriptor from) {
            return PROTECTED.isVisible(what, from) && INTERNAL.isVisible(what, from);
        }
    };
    public static final Visibility LOCAL = new Visibility("local", false){

        @Override
        protected boolean isVisible(@NotNull DeclarationDescriptorWithVisibility what, @NotNull DeclarationDescriptor from) {
            throw new IllegalStateException();
        }
    };
    public static final Visibility INHERITED = new Visibility("inherited", false){

        @Override
        protected boolean isVisible(@NotNull DeclarationDescriptorWithVisibility what, @NotNull DeclarationDescriptor from) {
            throw new IllegalStateException("Visibility is unknown yet");
        }
    };
    public static final Visibility INVISIBLE_FAKE = new Visibility("invisible_fake", false){

        @Override
        protected boolean isVisible(@NotNull DeclarationDescriptorWithVisibility what, @NotNull DeclarationDescriptor from) {
            return false;
        }
    };
    public static final Set<Visibility> INTERNAL_VISIBILITIES = Sets.newHashSet(PRIVATE, INTERNAL, INTERNAL_PROTECTED, LOCAL);
    private static final Map<Visibility, Integer> ORDERED_VISIBILITIES = Maps.newHashMap();

    private Visibilities() {
    }

    public static boolean isVisible(DeclarationDescriptorWithVisibility what, DeclarationDescriptor from) {
        DeclarationDescriptorWithVisibility parent = what;
        while (parent != null) {
            if (parent.getVisibility() == LOCAL) {
                return true;
            }
            if (!parent.getVisibility().isVisible(parent, from)) {
                return false;
            }
            parent = DescriptorUtils.getParentOfType(parent, DeclarationDescriptorWithVisibility.class);
        }
        return true;
    }

    static Integer compareLocal(@NotNull Visibility first, @NotNull Visibility second) {
        if (first == second) {
            return 0;
        }
        Integer firstIndex = ORDERED_VISIBILITIES.get(first);
        Integer secondIndex = ORDERED_VISIBILITIES.get(second);
        if (firstIndex == null || secondIndex == null || firstIndex.equals(secondIndex)) {
            return null;
        }
        return firstIndex - secondIndex;
    }

    @Nullable
    public static Integer compare(@NotNull Visibility first, @NotNull Visibility second) {
        Integer result = first.compareTo(second);
        if (result != null) {
            return result;
        }
        Integer oppositeResult = second.compareTo(first);
        if (oppositeResult != null) {
            return -oppositeResult.intValue();
        }
        return null;
    }

    static {
        ORDERED_VISIBILITIES.put(PRIVATE, 0);
        ORDERED_VISIBILITIES.put(INTERNAL_PROTECTED, 1);
        ORDERED_VISIBILITIES.put(INTERNAL, 2);
        ORDERED_VISIBILITIES.put(PROTECTED, 2);
        ORDERED_VISIBILITIES.put(PUBLIC, 3);
    }
}

