/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.descriptors;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.google.common.collect.Sets;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptorVisitor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.LazyScopeAdapter;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.JetTypeImpl;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeConstructorImpl;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeSubstitutor;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;
import org.jetbrains.jet.lang.types.lang.JetStandardClasses;
import org.jetbrains.jet.resolve.DescriptorRenderer;
import org.jetbrains.jet.util.lazy.LazyValue;

public class TypeParameterDescriptorImpl
extends DeclarationDescriptorImpl
implements TypeParameterDescriptor {
    private final int index;
    private final Variance variance;
    private final Set<JetType> upperBounds;
    private JetType upperBoundsAsType;
    private final TypeConstructor typeConstructor;
    private JetType defaultType;
    private final Set<JetType> classObjectUpperBounds = Sets.newLinkedHashSet();
    private JetType classObjectBoundsAsType;
    private final boolean reified;
    private boolean initialized = false;

    public static TypeParameterDescriptor createWithDefaultBound(@NotNull DeclarationDescriptor containingDeclaration, @NotNull List<AnnotationDescriptor> annotations, boolean reified, @NotNull Variance variance, @NotNull Name name, int index) {
        TypeParameterDescriptorImpl typeParameterDescriptor = TypeParameterDescriptorImpl.createForFurtherModification(containingDeclaration, annotations, reified, variance, name, index);
        typeParameterDescriptor.addUpperBound(JetStandardClasses.getDefaultBound());
        typeParameterDescriptor.setInitialized();
        return typeParameterDescriptor;
    }

    public static TypeParameterDescriptorImpl createForFurtherModification(@NotNull DeclarationDescriptor containingDeclaration, @NotNull List<AnnotationDescriptor> annotations, boolean reified, @NotNull Variance variance, @NotNull Name name, int index) {
        return new TypeParameterDescriptorImpl(containingDeclaration, annotations, reified, variance, name, index);
    }

    private TypeParameterDescriptorImpl(@NotNull DeclarationDescriptor containingDeclaration, @NotNull List<AnnotationDescriptor> annotations, boolean reified, @NotNull Variance variance, @NotNull Name name, int index) {
        super(containingDeclaration, annotations, name);
        this.index = index;
        this.variance = variance;
        this.upperBounds = Sets.newLinkedHashSet();
        this.reified = reified;
        this.typeConstructor = new TypeConstructorImpl(this, annotations, false, name.getName(), Collections.emptyList(), this.upperBounds);
    }

    private void checkInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("Type parameter descriptor in not initialized: " + this.nameForAssertions());
        }
    }

    private void checkUninitialized() {
        if (this.initialized) {
            throw new IllegalStateException("Type parameter descriptor is already initialized: " + this.nameForAssertions());
        }
    }

    private String nameForAssertions() {
        DeclarationDescriptor owner = this.getContainingDeclaration();
        return this.getName() + " declared in " + (owner == null ? "<no owner>" : owner.getName());
    }

    public void setInitialized() {
        this.checkUninitialized();
        this.initialized = true;
    }

    @Override
    public boolean isReified() {
        this.checkInitialized();
        return this.reified;
    }

    @Override
    public Variance getVariance() {
        this.checkInitialized();
        return this.variance;
    }

    public void addUpperBound(@NotNull JetType bound) {
        this.checkUninitialized();
        this.doAddUpperBound(bound);
    }

    private void doAddUpperBound(JetType bound) {
        this.upperBounds.add(bound);
    }

    public void addDefaultUpperBound() {
        this.checkUninitialized();
        if (this.upperBounds.isEmpty()) {
            this.doAddUpperBound(JetStandardClasses.getDefaultBound());
        }
    }

    @Override
    @NotNull
    public Set<JetType> getUpperBounds() {
        this.checkInitialized();
        return this.upperBounds;
    }

    @Override
    @NotNull
    public JetType getUpperBoundsAsType() {
        this.checkInitialized();
        if (this.upperBoundsAsType == null) {
            assert (this.upperBounds != null) : "Upper bound list is null in " + this.getName();
            assert (this.upperBounds.size() > 0) : "Upper bound list is empty in " + this.getName();
            this.upperBoundsAsType = TypeUtils.intersect(JetTypeChecker.INSTANCE, this.upperBounds);
            if (this.upperBoundsAsType == null) {
                this.upperBoundsAsType = JetStandardClasses.getNothingType();
            }
        }
        return this.upperBoundsAsType;
    }

    @Override
    @NotNull
    public Set<JetType> getLowerBounds() {
        return Collections.singleton(JetStandardClasses.getNothingType());
    }

    @Override
    @NotNull
    public JetType getLowerBoundsAsType() {
        this.checkInitialized();
        return JetStandardClasses.getNothingType();
    }

    @Override
    @NotNull
    public TypeConstructor getTypeConstructor() {
        return this.typeConstructor;
    }

    @Override
    public String toString() {
        try {
            return DescriptorRenderer.TEXT.render(this);
        }
        catch (Exception e) {
            return this.getClass().getName() + "@" + System.identityHashCode(this);
        }
    }

    @Override
    @Deprecated
    @NotNull
    public TypeParameterDescriptor substitute(TypeSubstitutor substitutor) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <R, D> R accept(DeclarationDescriptorVisitor<R, D> visitor, D data) {
        this.checkInitialized();
        return visitor.visitTypeParameterDescriptor(this, data);
    }

    @Override
    @NotNull
    public JetType getDefaultType() {
        if (this.defaultType == null) {
            this.defaultType = new JetTypeImpl(Collections.<AnnotationDescriptor>emptyList(), this.getTypeConstructor(), TypeUtils.hasNullableLowerBound(this), Collections.<TypeProjection>emptyList(), new LazyScopeAdapter(new LazyValue<JetScope>(){

                @Override
                protected JetScope compute() {
                    return TypeParameterDescriptorImpl.this.getUpperBoundsAsType().getMemberScope();
                }
            }));
        }
        return this.defaultType;
    }

    @Override
    public JetType getClassObjectType() {
        this.checkInitialized();
        if (this.classObjectUpperBounds.isEmpty()) {
            return null;
        }
        if (this.classObjectBoundsAsType == null) {
            this.classObjectBoundsAsType = TypeUtils.intersect(JetTypeChecker.INSTANCE, this.classObjectUpperBounds);
            if (this.classObjectBoundsAsType == null) {
                this.classObjectBoundsAsType = JetStandardClasses.getNothingType();
            }
        }
        return this.classObjectBoundsAsType;
    }

    @Override
    public boolean isClassObjectAValue() {
        return true;
    }

    public void addClassObjectBound(@NotNull JetType bound) {
        this.checkUninitialized();
        this.classObjectUpperBounds.add(bound);
    }

    @Override
    public int getIndex() {
        this.checkInitialized();
        return this.index;
    }
}

