/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.descriptors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.google.common.collect.Lists;
import org.jetbrains.jet.internal.com.google.common.collect.Sets;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptorVisitor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptorUtil;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyGetterDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertySetterDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.descriptors.Visibility;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.OverridingUtil;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ExtensionReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverDescriptor;
import org.jetbrains.jet.lang.resolve.scopes.receivers.TransientReceiver;
import org.jetbrains.jet.lang.types.DescriptorSubstitutor;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeSubstitutor;
import org.jetbrains.jet.lang.types.Variance;

public class PropertyDescriptor
extends VariableDescriptorImpl
implements CallableMemberDescriptor {
    private final Modality modality;
    private Visibility visibility;
    private final boolean isVar;
    private final boolean isObject;
    private final Set<PropertyDescriptor> overriddenProperties = Sets.newLinkedHashSet();
    private final PropertyDescriptor original;
    private final CallableMemberDescriptor.Kind kind;
    private ReceiverDescriptor expectedThisObject;
    private ReceiverDescriptor receiver;
    private List<TypeParameterDescriptor> typeParameters;
    private PropertyGetterDescriptor getter;
    private PropertySetterDescriptor setter;

    private PropertyDescriptor() {
        super(ErrorUtils.getErrorClass(), Collections.<AnnotationDescriptor>emptyList(), Name.special("<dummy>"));
        this.modality = null;
        this.visibility = null;
        this.isVar = false;
        this.isObject = false;
        this.original = null;
        this.kind = CallableMemberDescriptor.Kind.DECLARATION;
    }

    private PropertyDescriptor(@Nullable PropertyDescriptor original, @NotNull DeclarationDescriptor containingDeclaration, @NotNull List<AnnotationDescriptor> annotations, @NotNull Modality modality, @NotNull Visibility visibility, boolean isVar, boolean isObject, @NotNull Name name, CallableMemberDescriptor.Kind kind) {
        super(containingDeclaration, annotations, name);
        this.isVar = isVar;
        this.isObject = isObject;
        this.modality = modality;
        this.visibility = visibility;
        this.original = original == null ? this : original.getOriginal();
        this.kind = kind;
    }

    public PropertyDescriptor(@NotNull DeclarationDescriptor containingDeclaration, @NotNull List<AnnotationDescriptor> annotations, @NotNull Modality modality, @NotNull Visibility visibility, boolean isVar, boolean isObject, @NotNull Name name, CallableMemberDescriptor.Kind kind) {
        this(null, containingDeclaration, annotations, modality, visibility, isVar, isObject, name, kind);
    }

    public PropertyDescriptor(@NotNull DeclarationDescriptor containingDeclaration, @NotNull List<AnnotationDescriptor> annotations, @NotNull Modality modality, @NotNull Visibility visibility, boolean isVar, boolean isObject, @Nullable JetType receiverType, @NotNull ReceiverDescriptor expectedThisObject, @NotNull Name name, @NotNull JetType outType, CallableMemberDescriptor.Kind kind) {
        this(containingDeclaration, annotations, modality, visibility, isVar, isObject, name, kind);
        this.setType(outType, Collections.emptyList(), expectedThisObject, receiverType);
    }

    public void setType(@NotNull JetType outType, @NotNull List<? extends TypeParameterDescriptor> typeParameters, @NotNull ReceiverDescriptor expectedThisObject, @Nullable JetType receiverType) {
        ReceiverDescriptor receiver = receiverType == null ? ReceiverDescriptor.NO_RECEIVER : new ExtensionReceiver(this, receiverType);
        this.setType(outType, typeParameters, expectedThisObject, receiver);
    }

    public void setType(@NotNull JetType outType, @NotNull List<? extends TypeParameterDescriptor> typeParameters, @NotNull ReceiverDescriptor expectedThisObject, @NotNull ReceiverDescriptor receiver) {
        this.setOutType(outType);
        this.typeParameters = Lists.newArrayList(typeParameters);
        this.receiver = receiver;
        this.expectedThisObject = expectedThisObject;
    }

    public void initialize(@Nullable PropertyGetterDescriptor getter, @Nullable PropertySetterDescriptor setter) {
        this.getter = getter;
        this.setter = setter;
    }

    public void setVisibility(@NotNull Visibility visibility) {
        this.visibility = visibility;
    }

    @Override
    @NotNull
    public List<TypeParameterDescriptor> getTypeParameters() {
        return this.typeParameters;
    }

    @Override
    @NotNull
    public ReceiverDescriptor getReceiverParameter() {
        return this.receiver;
    }

    @Override
    @NotNull
    public ReceiverDescriptor getExpectedThisObject() {
        return this.expectedThisObject;
    }

    @Override
    public JetType getReturnType() {
        return this.getType();
    }

    @Override
    public boolean isVar() {
        return this.isVar;
    }

    @Override
    public boolean isObjectDeclaration() {
        return this.isObject;
    }

    @Override
    @NotNull
    public Modality getModality() {
        return this.modality;
    }

    @Override
    @NotNull
    public Visibility getVisibility() {
        return this.visibility;
    }

    @Nullable
    public PropertyGetterDescriptor getGetter() {
        return this.getter;
    }

    @Nullable
    public PropertySetterDescriptor getSetter() {
        return this.setter;
    }

    @NotNull
    public List<PropertyAccessorDescriptor> getAccessors() {
        ArrayList<PropertyAccessorDescriptor> r = Lists.newArrayListWithCapacity(2);
        if (this.getter != null) {
            r.add(this.getter);
        }
        if (this.setter != null) {
            r.add(this.setter);
        }
        return r;
    }

    @Override
    public PropertyDescriptor substitute(TypeSubstitutor originalSubstitutor) {
        if (originalSubstitutor.isEmpty()) {
            return this;
        }
        return this.doSubstitute(originalSubstitutor, this.getContainingDeclaration(), this.modality, this.visibility, true, true, this.getKind());
    }

    private PropertyDescriptor doSubstitute(TypeSubstitutor originalSubstitutor, DeclarationDescriptor newOwner, Modality newModality, Visibility newVisibility, boolean preserveOriginal, boolean copyOverrides, CallableMemberDescriptor.Kind kind) {
        PropertySetterDescriptor newSetter;
        PropertyGetterDescriptor newGetter;
        JetType substitutedReceiverType;
        ReceiverDescriptor substitutedExpectedThisObject;
        JetType originalOutType;
        PropertyDescriptor substitutedDescriptor = new PropertyDescriptor(preserveOriginal ? this.getOriginal() : this, newOwner, this.getAnnotations(), newModality, newVisibility, this.isVar(), this.isObjectDeclaration(), this.getName(), kind);
        ArrayList<TypeParameterDescriptor> substitutedTypeParameters = Lists.newArrayList();
        TypeSubstitutor substitutor = DescriptorSubstitutor.substituteTypeParameters(this.getTypeParameters(), originalSubstitutor, substitutedDescriptor, substitutedTypeParameters);
        JetType outType = substitutor.substitute(originalOutType = this.getType(), Variance.OUT_VARIANCE);
        if (outType == null) {
            return null;
        }
        if (this.expectedThisObject.exists()) {
            JetType substitutedExpectedThisObjectType = substitutor.substitute(this.getExpectedThisObject().getType(), Variance.INVARIANT);
            substitutedExpectedThisObject = new TransientReceiver(substitutedExpectedThisObjectType);
        } else {
            substitutedExpectedThisObject = ReceiverDescriptor.NO_RECEIVER;
        }
        if (this.receiver.exists()) {
            substitutedReceiverType = substitutor.substitute(this.receiver.getType(), Variance.IN_VARIANCE);
            if (substitutedReceiverType == null) {
                return null;
            }
        } else {
            substitutedReceiverType = null;
        }
        substitutedDescriptor.setType(outType, substitutedTypeParameters, substitutedExpectedThisObject, substitutedReceiverType);
        PropertyGetterDescriptor propertyGetterDescriptor = newGetter = this.getter == null ? null : new PropertyGetterDescriptor(substitutedDescriptor, Lists.newArrayList(this.getter.getAnnotations()), DescriptorUtils.convertModality(this.getter.getModality(), false), this.getter.getVisibility(), this.getter.hasBody(), this.getter.isDefault(), kind);
        if (newGetter != null) {
            JetType returnType = this.getter.getReturnType();
            newGetter.initialize(returnType != null ? substitutor.substitute(returnType, Variance.OUT_VARIANCE) : null);
        }
        PropertySetterDescriptor propertySetterDescriptor = newSetter = this.setter == null ? null : new PropertySetterDescriptor(substitutedDescriptor, Lists.newArrayList(this.setter.getAnnotations()), DescriptorUtils.convertModality(this.setter.getModality(), false), this.setter.getVisibility(), this.setter.hasBody(), this.setter.isDefault(), kind);
        if (newSetter != null) {
            List<ValueParameterDescriptor> substitutedValueParameters = FunctionDescriptorUtil.getSubstitutedValueParameters(newSetter, this.setter, substitutor);
            if (substitutedValueParameters == null) {
                return null;
            }
            if (substitutedValueParameters.size() != 1) {
                throw new IllegalStateException();
            }
            newSetter.initialize(substitutedValueParameters.get(0));
        }
        substitutedDescriptor.initialize(newGetter, newSetter);
        if (copyOverrides) {
            for (PropertyDescriptor propertyDescriptor : this.overriddenProperties) {
                OverridingUtil.bindOverride(substitutedDescriptor, propertyDescriptor.substitute(substitutor));
            }
        }
        return substitutedDescriptor;
    }

    @Override
    public <R, D> R accept(DeclarationDescriptorVisitor<R, D> visitor, D data) {
        return visitor.visitPropertyDescriptor(this, data);
    }

    @Override
    @NotNull
    public PropertyDescriptor getOriginal() {
        return this.original;
    }

    @Override
    public CallableMemberDescriptor.Kind getKind() {
        return this.kind;
    }

    @Override
    public void addOverriddenDescriptor(@NotNull CallableMemberDescriptor overridden) {
        this.overriddenProperties.add((PropertyDescriptor)overridden);
    }

    @NotNull
    public Set<? extends PropertyDescriptor> getOverriddenDescriptors() {
        return this.overriddenProperties;
    }

    @Override
    @NotNull
    public PropertyDescriptor copy(DeclarationDescriptor newOwner, boolean makeNonAbstract, boolean makeInvisible, CallableMemberDescriptor.Kind kind, boolean copyOverrides) {
        return this.doSubstitute(TypeSubstitutor.EMPTY, newOwner, DescriptorUtils.convertModality(this.modality, makeNonAbstract), makeInvisible ? Visibilities.INVISIBLE_FAKE : this.visibility, false, copyOverrides, kind);
    }

    public static PropertyDescriptor createDummy() {
        return new PropertyDescriptor();
    }
}

