/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.descriptors;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.AbstractNamespaceDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.MutableClassDescriptorLite;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptorParent;
import org.jetbrains.jet.lang.descriptors.NamespaceLikeBuilder;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.WithDeferredResolve;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;

public class NamespaceDescriptorImpl
extends AbstractNamespaceDescriptorImpl
implements WithDeferredResolve {
    private WritableScope memberScope;
    private NamespaceLikeBuilder builder = null;

    public NamespaceDescriptorImpl(@NotNull NamespaceDescriptorParent containingDeclaration, @NotNull List<AnnotationDescriptor> annotations, @NotNull Name name) {
        super(containingDeclaration, annotations, name);
    }

    public void initialize(@NotNull WritableScope memberScope) {
        if (this.memberScope != null) {
            throw new IllegalStateException("Namespace member scope reinitialize");
        }
        this.memberScope = memberScope;
    }

    @Override
    @NotNull
    public WritableScope getMemberScope() {
        return this.memberScope;
    }

    @Override
    public void addNamespace(@NotNull NamespaceDescriptor namespaceDescriptor) {
        this.getMemberScope().addNamespace(namespaceDescriptor);
    }

    @Override
    @NotNull
    public FqName getQualifiedName() {
        return DescriptorUtils.getFQName(this).toSafe();
    }

    public NamespaceLikeBuilder getBuilder() {
        if (this.builder == null) {
            this.builder = new NamespaceLikeBuilder(){

                @Override
                public void addClassifierDescriptor(@NotNull MutableClassDescriptorLite classDescriptor) {
                    NamespaceDescriptorImpl.this.getMemberScope().addClassifierDescriptor(classDescriptor);
                }

                @Override
                public void addObjectDescriptor(@NotNull MutableClassDescriptorLite objectDescriptor) {
                    NamespaceDescriptorImpl.this.getMemberScope().addObjectDescriptor(objectDescriptor);
                }

                @Override
                public void addFunctionDescriptor(@NotNull SimpleFunctionDescriptor functionDescriptor) {
                    NamespaceDescriptorImpl.this.getMemberScope().addFunctionDescriptor(functionDescriptor);
                }

                @Override
                public void addPropertyDescriptor(@NotNull PropertyDescriptor propertyDescriptor) {
                    NamespaceDescriptorImpl.this.getMemberScope().addPropertyDescriptor(propertyDescriptor);
                }

                @Override
                @NotNull
                public DeclarationDescriptor getOwnerForChildren() {
                    return NamespaceDescriptorImpl.this;
                }

                @Override
                public NamespaceLikeBuilder.ClassObjectStatus setClassObjectDescriptor(@NotNull MutableClassDescriptorLite classObjectDescriptor) {
                    throw new IllegalStateException("Must be guaranteed not to happen by the parser");
                }
            };
        }
        return this.builder;
    }

    @Override
    public void forceResolve() {
    }

    @Override
    public boolean isAlreadyResolved() {
        return false;
    }
}

