/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.descriptors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.google.common.collect.Lists;
import org.jetbrains.jet.internal.com.google.common.collect.Sets;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptorBase;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceLikeBuilder;
import org.jetbrains.jet.lang.descriptors.NamespaceLikeBuilderDummy;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibility;
import org.jetbrains.jet.lang.descriptors.WithDeferredResolve;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.InnerClassesScopeWrapper;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ClassReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverDescriptor;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeConstructorImpl;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.resolve.DescriptorRenderer;

public class MutableClassDescriptorLite
extends ClassDescriptorBase
implements WithDeferredResolve {
    private ConstructorDescriptor primaryConstructor;
    private final Set<ConstructorDescriptor> constructors = Sets.newLinkedHashSet();
    private List<AnnotationDescriptor> annotations = Lists.newArrayList();
    private List<TypeParameterDescriptor> typeParameters;
    private Collection<JetType> supertypes = Lists.newArrayList();
    private TypeConstructor typeConstructor;
    private Modality modality;
    private Visibility visibility;
    private MutableClassDescriptorLite classObjectDescriptor;
    private JetType classObjectType;
    private final ClassKind kind;
    private JetScope scopeForMemberLookup;
    private JetScope innerClassesScope;
    private ClassReceiver implicitReceiver;
    private Name name;
    private final DeclarationDescriptor containingDeclaration;
    private NamespaceLikeBuilder builder = null;

    public MutableClassDescriptorLite(@NotNull DeclarationDescriptor containingDeclaration, @NotNull ClassKind kind) {
        this.containingDeclaration = containingDeclaration;
        this.kind = kind;
    }

    @Override
    public void forceResolve() {
    }

    @Override
    public boolean isAlreadyResolved() {
        return false;
    }

    @Override
    @NotNull
    public DeclarationDescriptor getContainingDeclaration() {
        return this.containingDeclaration;
    }

    @Override
    @NotNull
    public Name getName() {
        return this.name;
    }

    public void setName(@NotNull Name name) {
        assert (this.name == null) : this.name;
        this.name = name;
    }

    @Override
    @NotNull
    public DeclarationDescriptor getOriginal() {
        return this;
    }

    private static boolean isStatic(DeclarationDescriptor declarationDescriptor) {
        if (declarationDescriptor instanceof NamespaceDescriptor) {
            return true;
        }
        if (declarationDescriptor instanceof ClassDescriptor) {
            ClassDescriptor classDescriptor = (ClassDescriptor)declarationDescriptor;
            return classDescriptor.getKind() == ClassKind.OBJECT || classDescriptor.getKind() == ClassKind.ENUM_CLASS;
        }
        return false;
    }

    @Override
    @NotNull
    public TypeConstructor getTypeConstructor() {
        return this.typeConstructor;
    }

    public void setScopeForMemberLookup(JetScope scopeForMemberLookup) {
        this.scopeForMemberLookup = scopeForMemberLookup;
        this.innerClassesScope = new InnerClassesScopeWrapper(scopeForMemberLookup);
    }

    public void createTypeConstructor() {
        assert (this.typeConstructor == null) : this.typeConstructor;
        this.typeConstructor = new TypeConstructorImpl(this, Collections.<AnnotationDescriptor>emptyList(), !this.getModality().isOverridable(), this.getName().getName(), this.typeParameters, this.supertypes);
        for (ConstructorDescriptor functionDescriptor : this.constructors) {
            ((ConstructorDescriptorImpl)functionDescriptor).setReturnType(this.getDefaultType());
        }
    }

    private WritableScope getScopeForMemberLookupAsWritableScope() {
        return (WritableScope)this.scopeForMemberLookup;
    }

    @Override
    @NotNull
    public Set<ConstructorDescriptor> getConstructors() {
        return this.constructors;
    }

    @Override
    @NotNull
    public JetScope getScopeForMemberLookup() {
        return this.scopeForMemberLookup;
    }

    @Override
    public JetType getClassObjectType() {
        if (this.classObjectType == null && this.classObjectDescriptor != null) {
            this.classObjectType = this.classObjectDescriptor.getDefaultType();
        }
        return this.classObjectType;
    }

    @Override
    public boolean isClassObjectAValue() {
        return true;
    }

    @Override
    @NotNull
    public ClassKind getKind() {
        return this.kind;
    }

    public void setModality(Modality modality) {
        this.modality = modality;
    }

    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    @Override
    @NotNull
    public Modality getModality() {
        return this.modality;
    }

    @Override
    @NotNull
    public Visibility getVisibility() {
        return this.visibility;
    }

    public Collection<JetType> getSupertypes() {
        return this.supertypes;
    }

    public void setSupertypes(@NotNull Collection<JetType> supertypes) {
        this.supertypes = supertypes;
    }

    public void setPrimaryConstructor(@NotNull ConstructorDescriptor constructorDescriptor, BindingTrace trace) {
        assert (this.primaryConstructor == null) : "Primary constructor assigned twice " + this;
        this.primaryConstructor = constructorDescriptor;
        this.addConstructor(constructorDescriptor, trace);
    }

    @Override
    @Nullable
    public ConstructorDescriptor getUnsubstitutedPrimaryConstructor() {
        return this.primaryConstructor;
    }

    public void addConstructor(@NotNull ConstructorDescriptor constructorDescriptor, @Nullable BindingTrace trace) {
        assert (constructorDescriptor.getContainingDeclaration() == this);
        this.constructors.add(constructorDescriptor);
        if (this.defaultType != null) {
            ((ConstructorDescriptorImpl)constructorDescriptor).setReturnType(this.getDefaultType());
        }
    }

    @Override
    @Nullable
    public MutableClassDescriptorLite getClassObjectDescriptor() {
        return this.classObjectDescriptor;
    }

    @Override
    @NotNull
    public JetScope getUnsubstitutedInnerClassesScope() {
        return this.innerClassesScope;
    }

    public void addSupertype(@NotNull JetType supertype) {
        if (!ErrorUtils.isErrorType(supertype) && TypeUtils.getClassDescriptor(supertype) != null) {
            this.supertypes.add(supertype);
        }
    }

    public void setTypeParameterDescriptors(List<TypeParameterDescriptor> typeParameters) {
        if (this.typeParameters != null) {
            throw new IllegalStateException();
        }
        this.typeParameters = new ArrayList<TypeParameterDescriptor>();
        for (TypeParameterDescriptor typeParameterDescriptor : typeParameters) {
            this.typeParameters.add(typeParameterDescriptor);
        }
    }

    public void lockScopes() {
        this.getScopeForMemberLookupAsWritableScope().changeLockLevel(WritableScope.LockLevel.READING);
        if (this.classObjectDescriptor != null) {
            this.classObjectDescriptor.lockScopes();
        }
    }

    @Override
    @NotNull
    public ReceiverDescriptor getImplicitReceiver() {
        if (this.implicitReceiver == null) {
            this.implicitReceiver = new ClassReceiver(this);
        }
        return this.implicitReceiver;
    }

    public String toString() {
        try {
            return DescriptorRenderer.TEXT.render(this) + "[" + this.getClass().getCanonicalName() + "@" + System.identityHashCode(this) + "]";
        }
        catch (Throwable e) {
            return super.toString();
        }
    }

    @Override
    public List<AnnotationDescriptor> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(List<AnnotationDescriptor> annotations) {
        this.annotations = annotations;
    }

    public NamespaceLikeBuilder getBuilder() {
        if (this.builder == null) {
            this.builder = new NamespaceLikeBuilderDummy(){

                @Override
                @NotNull
                public DeclarationDescriptor getOwnerForChildren() {
                    return MutableClassDescriptorLite.this;
                }

                @Override
                public void addClassifierDescriptor(@NotNull MutableClassDescriptorLite classDescriptor) {
                    MutableClassDescriptorLite.this.getScopeForMemberLookupAsWritableScope().addClassifierDescriptor(classDescriptor);
                }

                @Override
                public void addObjectDescriptor(@NotNull MutableClassDescriptorLite objectDescriptor) {
                    MutableClassDescriptorLite.this.getScopeForMemberLookupAsWritableScope().addObjectDescriptor(objectDescriptor);
                }

                @Override
                public void addFunctionDescriptor(@NotNull SimpleFunctionDescriptor functionDescriptor) {
                    MutableClassDescriptorLite.this.getScopeForMemberLookupAsWritableScope().addFunctionDescriptor(functionDescriptor);
                }

                @Override
                public void addPropertyDescriptor(@NotNull PropertyDescriptor propertyDescriptor) {
                    MutableClassDescriptorLite.this.getScopeForMemberLookupAsWritableScope().addPropertyDescriptor(propertyDescriptor);
                }

                @Override
                public NamespaceLikeBuilder.ClassObjectStatus setClassObjectDescriptor(@NotNull MutableClassDescriptorLite classObjectDescriptor) {
                    if (MutableClassDescriptorLite.this.getKind() == ClassKind.OBJECT) {
                        return NamespaceLikeBuilder.ClassObjectStatus.NOT_ALLOWED;
                    }
                    if (MutableClassDescriptorLite.this.classObjectDescriptor != null) {
                        return NamespaceLikeBuilder.ClassObjectStatus.DUPLICATE;
                    }
                    if (!MutableClassDescriptorLite.isStatic(MutableClassDescriptorLite.this.getContainingDeclaration())) {
                        return NamespaceLikeBuilder.ClassObjectStatus.NOT_ALLOWED;
                    }
                    assert (classObjectDescriptor.getKind() == ClassKind.OBJECT);
                    MutableClassDescriptorLite.this.classObjectDescriptor = classObjectDescriptor;
                    return NamespaceLikeBuilder.ClassObjectStatus.OK;
                }
            };
        }
        return this.builder;
    }
}

