/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.descriptors;

import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.google.common.collect.Sets;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.MutableClassDescriptorLite;
import org.jetbrains.jet.lang.descriptors.NamespaceLikeBuilder;
import org.jetbrains.jet.lang.descriptors.NamespaceLikeBuilderDummy;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.resolve.AbstractScopeAdapter;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.RedeclarationHandler;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScopeImpl;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ClassReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverDescriptor;

public class MutableClassDescriptor
extends MutableClassDescriptorLite {
    private final Set<CallableMemberDescriptor> declaredCallableMembers = Sets.newHashSet();
    private final Set<CallableMemberDescriptor> allCallableMembers = Sets.newHashSet();
    private final Set<PropertyDescriptor> properties = Sets.newHashSet();
    private final Set<SimpleFunctionDescriptor> functions = Sets.newHashSet();
    private final WritableScope scopeForMemberResolution;
    private final WritableScope scopeForSupertypeResolution;
    private WritableScope scopeForInitializers = null;
    private NamespaceLikeBuilder builder = null;

    public MutableClassDescriptor(@NotNull DeclarationDescriptor containingDeclaration, @NotNull JetScope outerScope, ClassKind kind, Name name) {
        super(containingDeclaration, kind);
        RedeclarationHandler redeclarationHandler = RedeclarationHandler.DO_NOTHING;
        this.setScopeForMemberLookup(new WritableScopeImpl(JetScope.EMPTY, this, redeclarationHandler, "MemberLookup").changeLockLevel(WritableScope.LockLevel.BOTH));
        this.scopeForSupertypeResolution = new WritableScopeImpl(outerScope, this, redeclarationHandler, "SupertypeResolution").changeLockLevel(WritableScope.LockLevel.BOTH);
        this.scopeForMemberResolution = new WritableScopeImpl(this.scopeForSupertypeResolution, this, redeclarationHandler, "MemberResolution").changeLockLevel(WritableScope.LockLevel.BOTH);
        if (this.getKind() == ClassKind.TRAIT) {
            this.setUpScopeForInitializers(this);
        }
        this.setName(name);
    }

    @Override
    public void addConstructor(@NotNull ConstructorDescriptor constructorDescriptor, @NotNull BindingTrace trace) {
        super.addConstructor(constructorDescriptor, trace);
        if (constructorDescriptor.isPrimary()) {
            this.setUpScopeForInitializers(constructorDescriptor);
            for (ValueParameterDescriptor valueParameterDescriptor : constructorDescriptor.getValueParameters()) {
                JetParameter parameter = (JetParameter)BindingContextUtils.descriptorToDeclaration(trace.getBindingContext(), valueParameterDescriptor);
                assert (parameter != null);
                if (parameter.getValOrVarNode() != null && constructorDescriptor.isPrimary()) continue;
                this.getWritableScopeForInitializers().addVariableDescriptor(valueParameterDescriptor);
            }
        }
    }

    @NotNull
    public Set<SimpleFunctionDescriptor> getFunctions() {
        return this.functions;
    }

    @NotNull
    public Set<PropertyDescriptor> getProperties() {
        return this.properties;
    }

    @NotNull
    public Set<CallableMemberDescriptor> getDeclaredCallableMembers() {
        return this.declaredCallableMembers;
    }

    @NotNull
    public Set<CallableMemberDescriptor> getAllCallableMembers() {
        return this.allCallableMembers;
    }

    @Override
    public void setTypeParameterDescriptors(List<TypeParameterDescriptor> typeParameters) {
        super.setTypeParameterDescriptors(typeParameters);
        for (TypeParameterDescriptor typeParameterDescriptor : typeParameters) {
            this.scopeForSupertypeResolution.addTypeParameterDescriptor(typeParameterDescriptor);
        }
        this.scopeForSupertypeResolution.changeLockLevel(WritableScope.LockLevel.READING);
    }

    @Override
    public void setName(@NotNull Name name) {
        super.setName(name);
        this.scopeForMemberResolution.addLabeledDeclaration(this);
    }

    @Override
    public void createTypeConstructor() {
        super.createTypeConstructor();
        this.scopeForMemberResolution.setImplicitReceiver(new ClassReceiver(this));
    }

    @NotNull
    public JetScope getScopeForSupertypeResolution() {
        return this.scopeForSupertypeResolution;
    }

    @NotNull
    public JetScope getScopeForMemberResolution() {
        return this.scopeForMemberResolution;
    }

    private WritableScope getWritableScopeForInitializers() {
        if (this.scopeForInitializers == null) {
            throw new IllegalStateException("Scope for initializers queried before the primary constructor is set");
        }
        return this.scopeForInitializers;
    }

    @NotNull
    public JetScope getScopeForInitializers() {
        return this.getWritableScopeForInitializers();
    }

    private void setUpScopeForInitializers(@NotNull DeclarationDescriptor containingDeclaration) {
        this.scopeForInitializers = new WritableScopeImpl(this.scopeForMemberResolution, containingDeclaration, RedeclarationHandler.DO_NOTHING, "Initializers").changeLockLevel(WritableScope.LockLevel.BOTH);
    }

    @Override
    public void lockScopes() {
        super.lockScopes();
        this.scopeForSupertypeResolution.changeLockLevel(WritableScope.LockLevel.READING);
        this.scopeForMemberResolution.changeLockLevel(WritableScope.LockLevel.READING);
        this.getWritableScopeForInitializers().changeLockLevel(WritableScope.LockLevel.READING);
    }

    @Override
    public NamespaceLikeBuilder getBuilder() {
        if (this.builder == null) {
            final NamespaceLikeBuilder superBuilder = super.getBuilder();
            this.builder = new NamespaceLikeBuilderDummy(){

                @Override
                @NotNull
                public DeclarationDescriptor getOwnerForChildren() {
                    return superBuilder.getOwnerForChildren();
                }

                @Override
                public void addObjectDescriptor(@NotNull MutableClassDescriptorLite objectDescriptor) {
                    superBuilder.addObjectDescriptor(objectDescriptor);
                }

                @Override
                public void addClassifierDescriptor(@NotNull MutableClassDescriptorLite classDescriptor) {
                    superBuilder.addClassifierDescriptor(classDescriptor);
                    MutableClassDescriptor.this.scopeForMemberResolution.addClassifierDescriptor(classDescriptor);
                }

                @Override
                public void addFunctionDescriptor(@NotNull SimpleFunctionDescriptor functionDescriptor) {
                    superBuilder.addFunctionDescriptor(functionDescriptor);
                    MutableClassDescriptor.this.functions.add(functionDescriptor);
                    if (functionDescriptor.getKind() != CallableMemberDescriptor.Kind.FAKE_OVERRIDE) {
                        MutableClassDescriptor.this.declaredCallableMembers.add(functionDescriptor);
                    }
                    MutableClassDescriptor.this.allCallableMembers.add(functionDescriptor);
                    MutableClassDescriptor.this.scopeForMemberResolution.addFunctionDescriptor(functionDescriptor);
                }

                @Override
                public NamespaceLikeBuilder.ClassObjectStatus setClassObjectDescriptor(final @NotNull MutableClassDescriptorLite classObjectDescriptor) {
                    NamespaceLikeBuilder.ClassObjectStatus r = superBuilder.setClassObjectDescriptor(classObjectDescriptor);
                    if (r != NamespaceLikeBuilder.ClassObjectStatus.OK) {
                        return r;
                    }
                    MutableClassDescriptor.this.scopeForMemberResolution.importScope(new AbstractScopeAdapter(){

                        @Override
                        @NotNull
                        protected JetScope getWorkerScope() {
                            return classObjectDescriptor.getDefaultType().getMemberScope();
                        }

                        @Override
                        @NotNull
                        public ReceiverDescriptor getImplicitReceiver() {
                            return classObjectDescriptor.getImplicitReceiver();
                        }
                    });
                    return NamespaceLikeBuilder.ClassObjectStatus.OK;
                }

                @Override
                public void addPropertyDescriptor(@NotNull PropertyDescriptor propertyDescriptor) {
                    superBuilder.addPropertyDescriptor(propertyDescriptor);
                    MutableClassDescriptor.this.properties.add(propertyDescriptor);
                    if (propertyDescriptor.getKind() != CallableMemberDescriptor.Kind.FAKE_OVERRIDE) {
                        MutableClassDescriptor.this.declaredCallableMembers.add(propertyDescriptor);
                    }
                    MutableClassDescriptor.this.allCallableMembers.add(propertyDescriptor);
                    MutableClassDescriptor.this.scopeForMemberResolution.addPropertyDescriptor(propertyDescriptor);
                }
            };
        }
        return this.builder;
    }
}

