/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.descriptors;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.google.common.collect.Lists;
import org.jetbrains.jet.internal.com.google.common.collect.Sets;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptorVisitor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibility;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.SubstitutingScope;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverDescriptor;
import org.jetbrains.jet.lang.types.DescriptorSubstitutor;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeConstructorImpl;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeSubstitutor;
import org.jetbrains.jet.lang.types.Variance;

public class LazySubstitutingClassDescriptor
implements ClassDescriptor {
    private final ClassDescriptor original;
    private final TypeSubstitutor originalSubstitutor;
    private TypeSubstitutor newSubstitutor;
    private List<TypeParameterDescriptor> typeParameters;
    private TypeConstructor typeConstructor;

    public LazySubstitutingClassDescriptor(ClassDescriptor descriptor, TypeSubstitutor substitutor) {
        this.original = descriptor;
        this.originalSubstitutor = substitutor;
    }

    private TypeSubstitutor getSubstitutor() {
        if (this.newSubstitutor == null) {
            if (this.originalSubstitutor.isEmpty()) {
                this.newSubstitutor = this.originalSubstitutor;
            } else {
                this.typeParameters = Lists.newArrayList();
                this.newSubstitutor = DescriptorSubstitutor.substituteTypeParameters(this.original.getTypeConstructor().getParameters(), this.originalSubstitutor, this, this.typeParameters);
            }
        }
        return this.newSubstitutor;
    }

    @Override
    @NotNull
    public TypeConstructor getTypeConstructor() {
        TypeConstructor originalTypeConstructor = this.original.getTypeConstructor();
        if (this.originalSubstitutor.isEmpty()) {
            return originalTypeConstructor;
        }
        if (this.typeConstructor == null) {
            TypeSubstitutor substitutor = this.getSubstitutor();
            ArrayList<JetType> supertypes = Lists.newArrayList();
            for (JetType jetType : originalTypeConstructor.getSupertypes()) {
                supertypes.add(substitutor.substitute(jetType, Variance.INVARIANT));
            }
            this.typeConstructor = new TypeConstructorImpl(this, originalTypeConstructor.getAnnotations(), originalTypeConstructor.isSealed(), originalTypeConstructor.toString(), this.typeParameters, supertypes);
        }
        return this.typeConstructor;
    }

    @Override
    @NotNull
    public JetScope getMemberScope(List<TypeProjection> typeArguments) {
        JetScope memberScope = this.original.getMemberScope(typeArguments);
        if (this.originalSubstitutor.isEmpty()) {
            return memberScope;
        }
        return new SubstitutingScope(memberScope, this.getSubstitutor());
    }

    @Override
    @NotNull
    public JetType getDefaultType() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public ReceiverDescriptor getImplicitReceiver() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Set<ConstructorDescriptor> getConstructors() {
        HashSet<ConstructorDescriptor> r = Sets.newHashSet();
        for (ConstructorDescriptor constructor : this.original.getConstructors()) {
            r.add((ConstructorDescriptor)constructor.substitute(this.getSubstitutor()));
        }
        return r;
    }

    @Override
    public ConstructorDescriptor getUnsubstitutedPrimaryConstructor() {
        return this.original.getUnsubstitutedPrimaryConstructor();
    }

    @Override
    public List<AnnotationDescriptor> getAnnotations() {
        return this.original.getAnnotations();
    }

    @Override
    @NotNull
    public Name getName() {
        return this.original.getName();
    }

    @Override
    @NotNull
    public DeclarationDescriptor getOriginal() {
        return this.original.getOriginal();
    }

    @Override
    @NotNull
    public DeclarationDescriptor getContainingDeclaration() {
        return this.original.getContainingDeclaration();
    }

    @Override
    @NotNull
    public ClassDescriptor substitute(TypeSubstitutor substitutor) {
        if (substitutor.isEmpty()) {
            return this;
        }
        return new LazySubstitutingClassDescriptor(this, TypeSubstitutor.create(substitutor.getSubstitution(), this.getSubstitutor().getSubstitution()));
    }

    @Override
    public JetType getClassObjectType() {
        return this.original.getClassObjectType();
    }

    @Override
    public ClassDescriptor getClassObjectDescriptor() {
        return this.original.getClassObjectDescriptor();
    }

    @Override
    @NotNull
    public ClassKind getKind() {
        return this.original.getKind();
    }

    @Override
    @NotNull
    public Modality getModality() {
        return this.original.getModality();
    }

    @Override
    @NotNull
    public Visibility getVisibility() {
        return this.original.getVisibility();
    }

    @Override
    public boolean isClassObjectAValue() {
        return this.original.isClassObjectAValue();
    }

    @Override
    public <R, D> R accept(DeclarationDescriptorVisitor<R, D> visitor, D data) {
        return visitor.visitClassDescriptor(this, data);
    }

    @Override
    public void acceptVoid(DeclarationDescriptorVisitor<Void, Void> visitor) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public JetScope getUnsubstitutedInnerClassesScope() {
        return this.original.getUnsubstitutedInnerClassesScope();
    }
}

