/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.descriptors;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.google.common.collect.Lists;
import org.jetbrains.jet.internal.com.google.common.collect.Sets;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptorVisitor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptorUtil;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibility;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.resolve.OverridingUtil;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ExtensionReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverDescriptor;
import org.jetbrains.jet.lang.resolve.scopes.receivers.TransientReceiver;
import org.jetbrains.jet.lang.types.DescriptorSubstitutor;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeSubstitutor;
import org.jetbrains.jet.lang.types.Variance;

public abstract class FunctionDescriptorImpl
extends DeclarationDescriptorImpl
implements FunctionDescriptor {
    protected List<TypeParameterDescriptor> typeParameters;
    protected List<ValueParameterDescriptor> unsubstitutedValueParameters;
    protected JetType unsubstitutedReturnType;
    private ReceiverDescriptor receiverParameter;
    protected ReceiverDescriptor expectedThisObject;
    protected Modality modality;
    protected Visibility visibility;
    protected final Set<FunctionDescriptor> overriddenFunctions = Sets.newLinkedHashSet();
    private final FunctionDescriptor original;
    private final CallableMemberDescriptor.Kind kind;

    protected FunctionDescriptorImpl(@NotNull DeclarationDescriptor containingDeclaration, @NotNull List<AnnotationDescriptor> annotations, @NotNull Name name, CallableMemberDescriptor.Kind kind) {
        super(containingDeclaration, annotations, name);
        this.original = this;
        this.kind = kind;
    }

    protected FunctionDescriptorImpl(@NotNull DeclarationDescriptor containingDeclaration, @NotNull FunctionDescriptor original, @NotNull List<AnnotationDescriptor> annotations, @NotNull Name name, CallableMemberDescriptor.Kind kind) {
        super(containingDeclaration, annotations, name);
        this.original = original;
        this.kind = kind;
    }

    protected FunctionDescriptorImpl initialize(@Nullable JetType receiverParameterType, @NotNull ReceiverDescriptor expectedThisObject, @NotNull List<? extends TypeParameterDescriptor> typeParameters, @NotNull List<ValueParameterDescriptor> unsubstitutedValueParameters, @Nullable JetType unsubstitutedReturnType, @Nullable Modality modality, @NotNull Visibility visibility) {
        int i;
        this.typeParameters = Lists.newArrayList(typeParameters);
        this.unsubstitutedValueParameters = unsubstitutedValueParameters;
        this.unsubstitutedReturnType = unsubstitutedReturnType;
        this.modality = modality;
        this.visibility = visibility;
        this.receiverParameter = receiverParameterType == null ? ReceiverDescriptor.NO_RECEIVER : new ExtensionReceiver(this, receiverParameterType);
        this.expectedThisObject = expectedThisObject;
        for (i = 0; i < typeParameters.size(); ++i) {
            if (typeParameters.get(i).getIndex() == i) continue;
            throw new IllegalStateException();
        }
        for (i = 0; i < unsubstitutedValueParameters.size(); ++i) {
            int firstValueParameterOffset = 0;
            ValueParameterDescriptor valueParameterDescriptor = unsubstitutedValueParameters.get(i);
            if (valueParameterDescriptor.getIndex() == i + firstValueParameterOffset) continue;
            throw new IllegalStateException(valueParameterDescriptor + "index is " + valueParameterDescriptor.getIndex() + " but position is " + i);
        }
        return this;
    }

    public void setVisibility(@NotNull Visibility visibility) {
        this.visibility = visibility;
    }

    public void setReturnType(@NotNull JetType unsubstitutedReturnType) {
        this.unsubstitutedReturnType = unsubstitutedReturnType;
    }

    @Override
    @NotNull
    public ReceiverDescriptor getReceiverParameter() {
        return this.receiverParameter;
    }

    @Override
    @NotNull
    public ReceiverDescriptor getExpectedThisObject() {
        return this.expectedThisObject;
    }

    @Override
    @NotNull
    public Set<? extends FunctionDescriptor> getOverriddenDescriptors() {
        return this.overriddenFunctions;
    }

    @Override
    @NotNull
    public Modality getModality() {
        return this.modality;
    }

    @Override
    @NotNull
    public Visibility getVisibility() {
        return this.visibility;
    }

    @Override
    public void addOverriddenDescriptor(@NotNull CallableMemberDescriptor overriddenFunction) {
        this.overriddenFunctions.add((FunctionDescriptor)overriddenFunction);
    }

    @Override
    @NotNull
    public List<TypeParameterDescriptor> getTypeParameters() {
        return this.typeParameters;
    }

    @Override
    @NotNull
    public List<ValueParameterDescriptor> getValueParameters() {
        return this.unsubstitutedValueParameters;
    }

    @Override
    public JetType getReturnType() {
        return this.unsubstitutedReturnType;
    }

    @Override
    @NotNull
    public FunctionDescriptor getOriginal() {
        return this.original == this ? this : this.original.getOriginal();
    }

    @Override
    public CallableMemberDescriptor.Kind getKind() {
        return this.kind;
    }

    @Override
    public final FunctionDescriptor substitute(TypeSubstitutor originalSubstitutor) {
        if (originalSubstitutor.isEmpty()) {
            return this;
        }
        return this.doSubstitute(originalSubstitutor, this.getContainingDeclaration(), this.modality, this.visibility, true, true, this.getKind());
    }

    protected FunctionDescriptor doSubstitute(TypeSubstitutor originalSubstitutor, DeclarationDescriptor newOwner, Modality newModality, Visibility newVisibility, boolean preserveOriginal, boolean copyOverrides, CallableMemberDescriptor.Kind kind) {
        List<ValueParameterDescriptor> substitutedValueParameters;
        FunctionDescriptorImpl substitutedDescriptor = this.createSubstitutedCopy(newOwner, preserveOriginal, kind);
        ArrayList<TypeParameterDescriptor> substitutedTypeParameters = Lists.newArrayList();
        TypeSubstitutor substitutor = DescriptorSubstitutor.substituteTypeParameters(this.getTypeParameters(), originalSubstitutor, substitutedDescriptor, substitutedTypeParameters);
        JetType substitutedReceiverParameterType = null;
        if (this.receiverParameter.exists() && (substitutedReceiverParameterType = substitutor.substitute(this.getReceiverParameter().getType(), Variance.IN_VARIANCE)) == null) {
            return null;
        }
        ReceiverDescriptor substitutedExpectedThis = ReceiverDescriptor.NO_RECEIVER;
        if (this.expectedThisObject.exists()) {
            JetType substitutedType = substitutor.substitute(this.expectedThisObject.getType(), Variance.INVARIANT);
            if (substitutedType == null) {
                return null;
            }
            substitutedExpectedThis = new TransientReceiver(substitutedType);
        }
        if ((substitutedValueParameters = FunctionDescriptorUtil.getSubstitutedValueParameters(substitutedDescriptor, this, substitutor)) == null) {
            return null;
        }
        JetType substitutedReturnType = FunctionDescriptorUtil.getSubstitutedReturnType(this, substitutor);
        if (substitutedReturnType == null) {
            return null;
        }
        substitutedDescriptor.initialize(substitutedReceiverParameterType, substitutedExpectedThis, substitutedTypeParameters, substitutedValueParameters, substitutedReturnType, newModality, newVisibility);
        if (copyOverrides) {
            for (FunctionDescriptor overriddenFunction : this.overriddenFunctions) {
                OverridingUtil.bindOverride(substitutedDescriptor, overriddenFunction.substitute(substitutor));
            }
        }
        return substitutedDescriptor;
    }

    protected abstract FunctionDescriptorImpl createSubstitutedCopy(DeclarationDescriptor var1, boolean var2, CallableMemberDescriptor.Kind var3);

    @Override
    public <R, D> R accept(DeclarationDescriptorVisitor<R, D> visitor, D data) {
        return visitor.visitFunctionDescriptor(this, data);
    }
}

