/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.descriptors;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptorVisitor;
import org.jetbrains.jet.lang.descriptors.Named;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotatedImpl;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.resolve.DescriptorRenderer;

public abstract class DeclarationDescriptorImpl
extends AnnotatedImpl
implements DeclarationDescriptor,
Named {
    @NotNull
    private final Name name;
    private final DeclarationDescriptor containingDeclaration;

    public DeclarationDescriptorImpl(@Nullable DeclarationDescriptor containingDeclaration, @NotNull List<AnnotationDescriptor> annotations, @NotNull Name name) {
        super(annotations);
        this.name = name;
        this.containingDeclaration = containingDeclaration;
    }

    @Override
    @NotNull
    public Name getName() {
        return this.name;
    }

    @Override
    @NotNull
    public DeclarationDescriptor getOriginal() {
        return this;
    }

    @Override
    public DeclarationDescriptor getContainingDeclaration() {
        return this.containingDeclaration;
    }

    @Override
    public void acceptVoid(DeclarationDescriptorVisitor<Void, Void> visitor) {
        this.accept(visitor, null);
    }

    public String toString() {
        try {
            return DescriptorRenderer.DEBUG_TEXT.render(this) + "[" + this.getClass().getSimpleName() + "@" + Integer.toHexString(System.identityHashCode(this)) + "]";
        }
        catch (Throwable e) {
            return this.getClass().getName() + "@" + System.identityHashCode(this);
        }
    }
}

