/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.cfg.pseudocode;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.cfg.pseudocode.InstructionVisitor;
import org.jetbrains.jet.lang.cfg.pseudocode.InstructionWithNext;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetNamedDeclaration;

public class WriteValueInstruction
extends InstructionWithNext {
    @NotNull
    private final JetElement lValue;

    public WriteValueInstruction(@NotNull JetElement assignment, @NotNull JetElement lValue) {
        super(assignment);
        this.lValue = lValue;
    }

    @NotNull
    public JetElement getlValue() {
        return this.lValue;
    }

    @Override
    public void accept(InstructionVisitor visitor) {
        visitor.visitWriteValue(this);
    }

    public String toString() {
        if (this.lValue instanceof JetNamedDeclaration) {
            JetNamedDeclaration value = (JetNamedDeclaration)this.lValue;
            return "w(" + value.getName() + ")";
        }
        return "w(" + this.lValue.getText() + ")";
    }
}

