/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.cfg.pseudocode;

import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.cfg.pseudocode.Instruction;
import org.jetbrains.jet.lang.cfg.pseudocode.InstructionImpl;
import org.jetbrains.jet.lang.cfg.pseudocode.InstructionVisitor;
import org.jetbrains.jet.lang.cfg.pseudocode.SubroutineSinkInstruction;
import org.jetbrains.jet.lang.psi.JetElement;

public class SubroutineExitInstruction
extends InstructionImpl {
    private final JetElement subroutine;
    private final String debugLabel;
    private SubroutineSinkInstruction sinkInstruction;

    public SubroutineExitInstruction(@NotNull JetElement subroutine, @NotNull String debugLabel) {
        this.subroutine = subroutine;
        this.debugLabel = debugLabel;
    }

    public JetElement getSubroutine() {
        return this.subroutine;
    }

    public void setSink(SubroutineSinkInstruction instruction) {
        this.sinkInstruction = (SubroutineSinkInstruction)this.outgoingEdgeTo(instruction);
    }

    @Override
    @NotNull
    public Collection<Instruction> getNextInstructions() {
        assert (this.sinkInstruction != null);
        return Collections.singleton(this.sinkInstruction);
    }

    @Override
    public void accept(InstructionVisitor visitor) {
        visitor.visitSubroutineExit(this);
    }

    public String toString() {
        return this.debugLabel;
    }
}

