/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.cfg.pseudocode;

import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.google.common.collect.Lists;
import org.jetbrains.jet.lang.cfg.pseudocode.Instruction;
import org.jetbrains.jet.lang.cfg.pseudocode.InstructionVisitor;
import org.jetbrains.jet.lang.cfg.pseudocode.InstructionWithNext;
import org.jetbrains.jet.lang.cfg.pseudocode.Pseudocode;
import org.jetbrains.jet.lang.cfg.pseudocode.SubroutineSinkInstruction;
import org.jetbrains.jet.lang.psi.JetDeclaration;

public class LocalDeclarationInstruction
extends InstructionWithNext {
    private final Pseudocode body;
    private Instruction sink;

    public LocalDeclarationInstruction(@NotNull JetDeclaration element, Pseudocode body) {
        super(element);
        this.body = body;
    }

    public Pseudocode getBody() {
        return this.body;
    }

    @Override
    @NotNull
    public JetDeclaration getElement() {
        return (JetDeclaration)super.getElement();
    }

    @Override
    @NotNull
    public Collection<Instruction> getNextInstructions() {
        if (this.sink != null) {
            ArrayList<Instruction> instructions = Lists.newArrayList(this.sink);
            instructions.addAll(super.getNextInstructions());
            return instructions;
        }
        return super.getNextInstructions();
    }

    public void setSink(SubroutineSinkInstruction sink) {
        this.sink = this.outgoingEdgeTo(sink);
    }

    @Override
    public void accept(InstructionVisitor visitor) {
        visitor.visitLocalDeclarationInstruction(this);
    }

    public String toString() {
        return "d(" + this.element.getText() + ")";
    }
}

