/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.cfg.pseudocode;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.cfg.BlockInfo;
import org.jetbrains.jet.lang.cfg.BreakableBlockInfo;
import org.jetbrains.jet.lang.cfg.GenerationTrigger;
import org.jetbrains.jet.lang.cfg.JetControlFlowBuilder;
import org.jetbrains.jet.lang.cfg.JetControlFlowBuilderAdapter;
import org.jetbrains.jet.lang.cfg.Label;
import org.jetbrains.jet.lang.cfg.LoopInfo;
import org.jetbrains.jet.lang.cfg.pseudocode.ConditionalJumpInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.Instruction;
import org.jetbrains.jet.lang.cfg.pseudocode.LocalDeclarationInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.NondeterministicJumpInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.Pseudocode;
import org.jetbrains.jet.lang.cfg.pseudocode.PseudocodeImpl;
import org.jetbrains.jet.lang.cfg.pseudocode.ReadUnitValueInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.ReadValueInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.ReturnNoValueInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.ReturnValueInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.SubroutineEnterInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.SubroutineExitInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.SubroutineSinkInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.UnconditionalJumpInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.UnsupportedElementInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.VariableDeclarationInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.WriteValueInstruction;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFunctionLiteral;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetThrowExpression;

public class JetControlFlowInstructionsGenerator
extends JetControlFlowBuilderAdapter {
    private final Stack<BreakableBlockInfo> loopInfo = new Stack();
    private final Map<JetElement, BreakableBlockInfo> elementToBlockInfo = new HashMap<JetElement, BreakableBlockInfo>();
    private int labelCount = 0;
    private final Stack<JetControlFlowInstructionsGeneratorWorker> builders = new Stack();
    private final Stack<BlockInfo> allBlocks = new Stack();

    private void pushBuilder(JetElement scopingElement, JetElement subroutine) {
        JetControlFlowInstructionsGeneratorWorker worker = new JetControlFlowInstructionsGeneratorWorker(scopingElement, subroutine);
        this.builders.push(worker);
        this.builder = worker;
    }

    private JetControlFlowInstructionsGeneratorWorker popBuilder(@NotNull JetElement element) {
        JetControlFlowInstructionsGeneratorWorker worker = this.builders.pop();
        this.builder = !this.builders.isEmpty() ? (JetControlFlowBuilder)this.builders.peek() : null;
        return worker;
    }

    @Override
    public void enterSubroutine(@NotNull JetDeclaration subroutine) {
        if (this.builder != null && subroutine instanceof JetFunctionLiteral) {
            this.pushBuilder(subroutine, this.builder.getReturnSubroutine());
        } else {
            this.pushBuilder(subroutine, subroutine);
        }
        assert (this.builder != null);
        this.builder.enterSubroutine(subroutine);
    }

    @Override
    public Pseudocode exitSubroutine(@NotNull JetDeclaration subroutine) {
        super.exitSubroutine(subroutine);
        JetControlFlowInstructionsGeneratorWorker worker = this.popBuilder(subroutine);
        if (!this.builders.empty()) {
            JetControlFlowInstructionsGeneratorWorker builder = this.builders.peek();
            LocalDeclarationInstruction instruction = new LocalDeclarationInstruction(subroutine, worker.getPseudocode());
            builder.add(instruction);
        }
        return worker.getPseudocode();
    }

    public static class TryFinallyBlockInfo
    extends BlockInfo {
        private final GenerationTrigger finallyBlock;

        private TryFinallyBlockInfo(GenerationTrigger finallyBlock) {
            this.finallyBlock = finallyBlock;
        }

        public void generateFinallyBlock() {
            this.finallyBlock.generate();
        }
    }

    private class JetControlFlowInstructionsGeneratorWorker
    implements JetControlFlowBuilder {
        private final PseudocodeImpl pseudocode;
        private final Label error;
        private final Label sink;
        private final JetElement returnSubroutine;

        private JetControlFlowInstructionsGeneratorWorker(@NotNull JetElement scopingElement, @NotNull JetElement returnSubroutine) {
            this.pseudocode = new PseudocodeImpl(scopingElement);
            this.error = this.pseudocode.createLabel("error");
            this.sink = this.pseudocode.createLabel("sink");
            this.returnSubroutine = returnSubroutine;
        }

        public PseudocodeImpl getPseudocode() {
            return this.pseudocode;
        }

        private void add(@NotNull Instruction instruction) {
            this.pseudocode.addInstruction(instruction);
        }

        @Override
        @NotNull
        public final Label createUnboundLabel() {
            return this.pseudocode.createLabel("l" + JetControlFlowInstructionsGenerator.this.labelCount++);
        }

        @Override
        public final LoopInfo enterLoop(@NotNull JetExpression expression, Label loopExitPoint, Label conditionEntryPoint) {
            Label label = this.createUnboundLabel();
            this.bindLabel(label);
            LoopInfo blockInfo = new LoopInfo(expression, label, loopExitPoint != null ? loopExitPoint : this.createUnboundLabel(), this.createUnboundLabel(), conditionEntryPoint != null ? conditionEntryPoint : this.createUnboundLabel());
            JetControlFlowInstructionsGenerator.this.loopInfo.push(blockInfo);
            JetControlFlowInstructionsGenerator.this.elementToBlockInfo.put(expression, blockInfo);
            JetControlFlowInstructionsGenerator.this.allBlocks.push(blockInfo);
            this.pseudocode.recordLoopInfo(expression, blockInfo);
            return blockInfo;
        }

        @Override
        public final void exitLoop(@NotNull JetExpression expression) {
            BreakableBlockInfo info = (BreakableBlockInfo)JetControlFlowInstructionsGenerator.this.loopInfo.pop();
            JetControlFlowInstructionsGenerator.this.elementToBlockInfo.remove(expression);
            JetControlFlowInstructionsGenerator.this.allBlocks.pop();
            this.bindLabel(info.getExitPoint());
        }

        @Override
        public JetElement getCurrentLoop() {
            return JetControlFlowInstructionsGenerator.this.loopInfo.empty() ? null : ((BreakableBlockInfo)JetControlFlowInstructionsGenerator.this.loopInfo.peek()).getElement();
        }

        @Override
        public void enterSubroutine(@NotNull JetDeclaration subroutine) {
            Label entryPoint = this.createUnboundLabel();
            BreakableBlockInfo blockInfo = new BreakableBlockInfo(subroutine, entryPoint, this.createUnboundLabel());
            JetControlFlowInstructionsGenerator.this.elementToBlockInfo.put(subroutine, blockInfo);
            JetControlFlowInstructionsGenerator.this.allBlocks.push(blockInfo);
            this.bindLabel(entryPoint);
            this.add(new SubroutineEnterInstruction(subroutine));
        }

        @Override
        @NotNull
        public JetElement getCurrentSubroutine() {
            return this.pseudocode.getCorrespondingElement();
        }

        @Override
        public JetElement getReturnSubroutine() {
            return this.returnSubroutine;
        }

        @Override
        public Label getEntryPoint(@NotNull JetElement labelElement) {
            return ((BreakableBlockInfo)JetControlFlowInstructionsGenerator.this.elementToBlockInfo.get(labelElement)).getEntryPoint();
        }

        @Override
        public Label getExitPoint(@NotNull JetElement labelElement) {
            BreakableBlockInfo blockInfo = (BreakableBlockInfo)JetControlFlowInstructionsGenerator.this.elementToBlockInfo.get(labelElement);
            assert (blockInfo != null) : labelElement.getText();
            return blockInfo.getExitPoint();
        }

        private void handleJumpInsideTryFinally(Label jumpTarget) {
            ArrayList<TryFinallyBlockInfo> finallyBlocks = new ArrayList<TryFinallyBlockInfo>();
            for (int i = JetControlFlowInstructionsGenerator.this.allBlocks.size() - 1; i >= 0; --i) {
                BlockInfo blockInfo = (BlockInfo)JetControlFlowInstructionsGenerator.this.allBlocks.get(i);
                if (blockInfo instanceof BreakableBlockInfo) {
                    BreakableBlockInfo breakableBlockInfo = (BreakableBlockInfo)blockInfo;
                    if (jumpTarget != breakableBlockInfo.getExitPoint() && jumpTarget != breakableBlockInfo.getEntryPoint()) continue;
                    for (int j = finallyBlocks.size() - 1; j >= 0; --j) {
                        ((TryFinallyBlockInfo)finallyBlocks.get(j)).generateFinallyBlock();
                    }
                    break;
                }
                if (!(blockInfo instanceof TryFinallyBlockInfo)) continue;
                TryFinallyBlockInfo tryFinallyBlockInfo = (TryFinallyBlockInfo)blockInfo;
                finallyBlocks.add(tryFinallyBlockInfo);
            }
        }

        @Override
        public Pseudocode exitSubroutine(@NotNull JetDeclaration subroutine) {
            this.bindLabel(this.getExitPoint(subroutine));
            this.pseudocode.addExitInstruction(new SubroutineExitInstruction(subroutine, "<END>"));
            this.bindLabel(this.error);
            this.pseudocode.addErrorInstruction(new SubroutineExitInstruction(subroutine, "<ERROR>"));
            this.bindLabel(this.sink);
            this.pseudocode.addSinkInstruction(new SubroutineSinkInstruction(subroutine, "<SINK>"));
            JetControlFlowInstructionsGenerator.this.elementToBlockInfo.remove(subroutine);
            JetControlFlowInstructionsGenerator.this.allBlocks.pop();
            return null;
        }

        @Override
        public void returnValue(@NotNull JetExpression returnExpression, @NotNull JetElement subroutine) {
            Label exitPoint = this.getExitPoint(subroutine);
            this.handleJumpInsideTryFinally(exitPoint);
            this.add(new ReturnValueInstruction(returnExpression, exitPoint));
        }

        @Override
        public void returnNoValue(@NotNull JetElement returnExpression, @NotNull JetElement subroutine) {
            Label exitPoint = this.getExitPoint(subroutine);
            this.handleJumpInsideTryFinally(exitPoint);
            this.add(new ReturnNoValueInstruction(returnExpression, exitPoint));
        }

        @Override
        public void write(@NotNull JetElement assignment, @NotNull JetElement lValue) {
            this.add(new WriteValueInstruction(assignment, lValue));
        }

        @Override
        public void declare(@NotNull JetParameter parameter) {
            this.add(new VariableDeclarationInstruction(parameter));
        }

        @Override
        public void declare(@NotNull JetProperty property) {
            this.add(new VariableDeclarationInstruction(property));
        }

        @Override
        public void read(@NotNull JetElement element) {
            this.add(new ReadValueInstruction(element));
        }

        @Override
        public void readUnit(@NotNull JetExpression expression) {
            this.add(new ReadUnitValueInstruction(expression));
        }

        @Override
        public void jump(@NotNull Label label) {
            this.handleJumpInsideTryFinally(label);
            this.add(new UnconditionalJumpInstruction(label));
        }

        @Override
        public void jumpOnFalse(@NotNull Label label) {
            this.handleJumpInsideTryFinally(label);
            this.add(new ConditionalJumpInstruction(false, label));
        }

        @Override
        public void jumpOnTrue(@NotNull Label label) {
            this.handleJumpInsideTryFinally(label);
            this.add(new ConditionalJumpInstruction(true, label));
        }

        @Override
        public void bindLabel(@NotNull Label label) {
            this.pseudocode.bindLabel(label);
        }

        @Override
        public void allowDead() {
            Label allowedDeadLabel = this.createUnboundLabel();
            this.bindLabel(allowedDeadLabel);
            this.pseudocode.allowDead(allowedDeadLabel);
        }

        @Override
        public void stopAllowDead() {
            Label allowedDeadLabel = this.createUnboundLabel();
            this.bindLabel(allowedDeadLabel);
            this.pseudocode.stopAllowDead(allowedDeadLabel);
        }

        @Override
        public void nondeterministicJump(Label label) {
            this.handleJumpInsideTryFinally(label);
            this.add(new NondeterministicJumpInstruction(label));
        }

        @Override
        public void nondeterministicJump(List<Label> labels) {
            this.add(new NondeterministicJumpInstruction(labels));
        }

        @Override
        public void jumpToError(JetThrowExpression expression) {
            this.add(new UnconditionalJumpInstruction(this.error));
        }

        @Override
        public void jumpToError(JetExpression nothingExpression) {
            this.add(new UnconditionalJumpInstruction(this.error));
        }

        @Override
        public void enterTryFinally(@NotNull GenerationTrigger generationTrigger) {
            JetControlFlowInstructionsGenerator.this.allBlocks.push(new TryFinallyBlockInfo(generationTrigger));
        }

        @Override
        public void exitTryFinally() {
            BlockInfo pop = (BlockInfo)JetControlFlowInstructionsGenerator.this.allBlocks.pop();
            assert (pop instanceof TryFinallyBlockInfo);
        }

        @Override
        public void unsupported(JetElement element) {
            this.add(new UnsupportedElementInstruction(element));
        }
    }
}

