/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.cfg;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.google.common.collect.Lists;
import org.jetbrains.jet.internal.com.google.common.collect.Maps;
import org.jetbrains.jet.internal.com.google.common.collect.Sets;
import org.jetbrains.jet.lang.cfg.pseudocode.Instruction;
import org.jetbrains.jet.lang.cfg.pseudocode.InstructionImpl;
import org.jetbrains.jet.lang.cfg.pseudocode.LocalDeclarationInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.Pseudocode;
import org.jetbrains.jet.lang.cfg.pseudocode.SubroutineEnterInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.SubroutineSinkInstruction;

public class PseudocodeTraverser {
    @NotNull
    private static Instruction getStartInstruction(@NotNull Pseudocode pseudocode, boolean directOrder) {
        return directOrder ? pseudocode.getEnterInstruction() : pseudocode.getSinkInstruction();
    }

    public static <D> Map<Instruction, Edges<D>> collectData(@NotNull Pseudocode pseudocode, boolean directOrder, boolean lookInside, @NotNull D initialDataValue, @NotNull D initialDataValueForEnterInstruction, @NotNull InstructionDataMergeStrategy<D> instructionDataMergeStrategy) {
        LinkedHashMap<Instruction, Edges<D>> edgesMap = Maps.newLinkedHashMap();
        PseudocodeTraverser.initializeEdgesMap(pseudocode, lookInside, edgesMap, initialDataValue);
        edgesMap.put(PseudocodeTraverser.getStartInstruction(pseudocode, directOrder), Edges.create(initialDataValueForEnterInstruction, initialDataValueForEnterInstruction));
        boolean[] changed = new boolean[]{true};
        while (changed[0]) {
            changed[0] = false;
            PseudocodeTraverser.collectDataFromSubgraph(pseudocode, directOrder, lookInside, edgesMap, instructionDataMergeStrategy, Collections.<Instruction>emptyList(), changed, false);
        }
        return edgesMap;
    }

    private static <D> void initializeEdgesMap(@NotNull Pseudocode pseudocode, boolean lookInside, @NotNull Map<Instruction, Edges<D>> edgesMap, @NotNull D initialDataValue) {
        List<Instruction> instructions = pseudocode.getInstructions();
        Edges<D> initialEdge = Edges.create(initialDataValue, initialDataValue);
        for (Instruction instruction : instructions) {
            edgesMap.put(instruction, initialEdge);
            if (!lookInside || !(instruction instanceof LocalDeclarationInstruction)) continue;
            PseudocodeTraverser.initializeEdgesMap(((LocalDeclarationInstruction)instruction).getBody(), lookInside, edgesMap, initialDataValue);
        }
    }

    private static <D> void collectDataFromSubgraph(@NotNull Pseudocode pseudocode, boolean directOrder, boolean lookInside, @NotNull Map<Instruction, Edges<D>> edgesMap, @NotNull InstructionDataMergeStrategy<D> instructionDataMergeStrategy, @NotNull Collection<Instruction> previousSubGraphInstructions, boolean[] changed, boolean isLocal) {
        List<Instruction> instructions = directOrder ? pseudocode.getInstructions() : pseudocode.getReversedInstructions();
        Instruction startInstruction = PseudocodeTraverser.getStartInstruction(pseudocode, directOrder);
        for (Instruction instruction : instructions) {
            Collection<Instruction> allPreviousInstructions;
            Collection<Instruction> previousInstructions;
            boolean isStart;
            boolean bl = isStart = directOrder ? instruction instanceof SubroutineEnterInstruction : instruction instanceof SubroutineSinkInstruction;
            if (!isLocal && isStart) continue;
            Collection<Instruction> collection = previousInstructions = directOrder ? instruction.getPreviousInstructions() : instruction.getNextInstructions();
            if (instruction == startInstruction && !previousSubGraphInstructions.isEmpty()) {
                allPreviousInstructions = Lists.newArrayList(previousInstructions);
                allPreviousInstructions.addAll(previousSubGraphInstructions);
            } else {
                allPreviousInstructions = previousInstructions;
            }
            if (lookInside && instruction instanceof LocalDeclarationInstruction) {
                Edges<D> newValue;
                InstructionImpl lastInstruction;
                Pseudocode subroutinePseudocode = ((LocalDeclarationInstruction)instruction).getBody();
                PseudocodeTraverser.collectDataFromSubgraph(subroutinePseudocode, directOrder, lookInside, edgesMap, instructionDataMergeStrategy, previousInstructions, changed, true);
                InstructionImpl instructionImpl = lastInstruction = directOrder ? subroutinePseudocode.getSinkInstruction() : subroutinePseudocode.getEnterInstruction();
                Edges<D> previousValue = edgesMap.get(instruction);
                if (previousValue.equals(newValue = edgesMap.get(lastInstruction))) continue;
                changed[0] = true;
                edgesMap.put(instruction, newValue);
                continue;
            }
            Edges<D> previousDataValue = edgesMap.get(instruction);
            HashSet incomingEdgesData = Sets.newHashSet();
            for (Instruction previousInstruction : allPreviousInstructions) {
                Edges<D> previousData = edgesMap.get(previousInstruction);
                if (previousData == null) continue;
                incomingEdgesData.add(previousData.out);
            }
            Edges<D> mergedData = instructionDataMergeStrategy.execute(instruction, incomingEdgesData);
            if (mergedData.equals(previousDataValue)) continue;
            changed[0] = true;
            edgesMap.put(instruction, mergedData);
        }
    }

    public static void traverse(@NotNull Pseudocode pseudocode, boolean directOrder, InstructionAnalyzeStrategy instructionAnalyzeStrategy) {
        List<Instruction> instructions = directOrder ? pseudocode.getInstructions() : pseudocode.getReversedInstructions();
        for (Instruction instruction : instructions) {
            if (instruction instanceof LocalDeclarationInstruction) {
                PseudocodeTraverser.traverse(((LocalDeclarationInstruction)instruction).getBody(), directOrder, instructionAnalyzeStrategy);
            }
            instructionAnalyzeStrategy.execute(instruction);
        }
    }

    public static <D> void traverse(@NotNull Pseudocode pseudocode, boolean directOrder, boolean lookInside, @NotNull Map<Instruction, Edges<D>> edgesMap, @NotNull InstructionDataAnalyzeStrategy<D> instructionDataAnalyzeStrategy) {
        List<Instruction> instructions = directOrder ? pseudocode.getInstructions() : pseudocode.getReversedInstructions();
        for (Instruction instruction : instructions) {
            Edges<D> edges;
            if (lookInside && instruction instanceof LocalDeclarationInstruction) {
                PseudocodeTraverser.traverse(((LocalDeclarationInstruction)instruction).getBody(), directOrder, lookInside, edgesMap, instructionDataAnalyzeStrategy);
            }
            instructionDataAnalyzeStrategy.execute(instruction, (edges = edgesMap.get(instruction)) != null ? (Object)edges.in : null, edges != null ? (Object)edges.out : null);
        }
    }

    public static class Edges<T> {
        public final T in;
        public final T out;

        Edges(@NotNull T in, @NotNull T out) {
            this.in = in;
            this.out = out;
        }

        public static <T> Edges<T> create(@NotNull T in, @NotNull T out) {
            return new Edges<T>(in, out);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Edges)) {
                return false;
            }
            Edges edges = (Edges)o;
            if (this.in != null ? !this.in.equals(edges.in) : edges.in != null) {
                return false;
            }
            return !(this.out != null ? !this.out.equals(edges.out) : edges.out != null);
        }

        public int hashCode() {
            int result = this.in != null ? this.in.hashCode() : 0;
            result = 31 * result + (this.out != null ? this.out.hashCode() : 0);
            return result;
        }
    }

    public static interface InstructionAnalyzeStrategy {
        public void execute(@NotNull Instruction var1);
    }

    public static interface InstructionDataAnalyzeStrategy<D> {
        public void execute(@NotNull Instruction var1, @Nullable D var2, @Nullable D var3);
    }

    public static interface InstructionDataMergeStrategy<D> {
        public Edges<D> execute(@NotNull Instruction var1, @NotNull Collection<D> var2);
    }
}

