/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.cfg;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.google.common.collect.Lists;
import org.jetbrains.jet.internal.com.google.common.collect.Sets;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.tree.IElementType;
import org.jetbrains.jet.internal.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.jet.lang.cfg.JetControlFlowProcessor;
import org.jetbrains.jet.lang.cfg.PseudocodeTraverser;
import org.jetbrains.jet.lang.cfg.PseudocodeVariablesData;
import org.jetbrains.jet.lang.cfg.pseudocode.AbstractJumpInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.Instruction;
import org.jetbrains.jet.lang.cfg.pseudocode.InstructionVisitor;
import org.jetbrains.jet.lang.cfg.pseudocode.JetElementInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.LocalDeclarationInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.NondeterministicJumpInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.Pseudocode;
import org.jetbrains.jet.lang.cfg.pseudocode.PseudocodeUtil;
import org.jetbrains.jet.lang.cfg.pseudocode.ReadUnitValueInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.ReadValueInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.ReturnNoValueInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.ReturnValueInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.SubroutineExitInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.UnconditionalJumpInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.VariableDeclarationInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.WriteValueInstruction;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.JetBinaryExpression;
import org.jetbrains.jet.lang.psi.JetBlockExpression;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetConstantExpression;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetDeclarationWithBody;
import org.jetbrains.jet.lang.psi.JetDotQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFunction;
import org.jetbrains.jet.lang.psi.JetFunctionLiteral;
import org.jetbrains.jet.lang.psi.JetFunctionLiteralExpression;
import org.jetbrains.jet.lang.psi.JetNamedDeclaration;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetPostfixExpression;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetReturnExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetStringTemplateExpression;
import org.jetbrains.jet.lang.psi.JetThisExpression;
import org.jetbrains.jet.lang.psi.JetUnaryExpression;
import org.jetbrains.jet.lang.psi.JetVisitorVoid;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.lang.JetStandardClasses;
import org.jetbrains.jet.lexer.JetTokens;
import org.jetbrains.jet.plugin.JetMainDetector;

public class JetFlowInformationProvider {
    private final JetDeclaration subroutine;
    private final Pseudocode pseudocode;
    private final PseudocodeVariablesData pseudocodeVariablesData;
    private BindingTrace trace;

    public JetFlowInformationProvider(@NotNull JetDeclaration declaration, @NotNull BindingTrace trace) {
        this.subroutine = declaration;
        this.trace = trace;
        this.pseudocode = new JetControlFlowProcessor(trace).generatePseudocode(declaration);
        this.pseudocodeVariablesData = new PseudocodeVariablesData(this.pseudocode, trace.getBindingContext());
    }

    private void collectReturnExpressions(final @NotNull Collection<JetElement> returnedExpressions) {
        final HashSet<Instruction> instructions = Sets.newHashSet(this.pseudocode.getInstructions());
        SubroutineExitInstruction exitInstruction = this.pseudocode.getExitInstruction();
        for (Instruction previousInstruction : exitInstruction.getPreviousInstructions()) {
            previousInstruction.accept(new InstructionVisitor(){

                @Override
                public void visitReturnValue(ReturnValueInstruction instruction) {
                    if (instructions.contains(instruction)) {
                        returnedExpressions.add(instruction.getElement());
                    }
                }

                @Override
                public void visitReturnNoValue(ReturnNoValueInstruction instruction) {
                    if (instructions.contains(instruction)) {
                        returnedExpressions.add(instruction.getElement());
                    }
                }

                @Override
                public void visitJump(AbstractJumpInstruction instruction) {
                }

                @Override
                public void visitUnconditionalJump(UnconditionalJumpInstruction instruction) {
                    this.redirectToPrevInstructions(instruction);
                }

                private void redirectToPrevInstructions(Instruction instruction) {
                    for (Instruction previousInstruction : instruction.getPreviousInstructions()) {
                        previousInstruction.accept(this);
                    }
                }

                @Override
                public void visitNondeterministicJump(NondeterministicJumpInstruction instruction) {
                    this.redirectToPrevInstructions(instruction);
                }

                @Override
                public void visitInstruction(Instruction instruction) {
                    if (!(instruction instanceof JetElementInstruction)) {
                        throw new IllegalStateException(instruction + " precedes the exit point");
                    }
                    JetElementInstruction elementInstruction = (JetElementInstruction)instruction;
                    returnedExpressions.add(elementInstruction.getElement());
                }
            });
        }
    }

    public void checkDefiniteReturn(final @NotNull JetType expectedReturnType) {
        assert (this.subroutine instanceof JetDeclarationWithBody);
        JetDeclarationWithBody function = (JetDeclarationWithBody)((Object)this.subroutine);
        JetExpression bodyExpression = function.getBodyExpression();
        if (bodyExpression == null) {
            return;
        }
        ArrayList<JetElement> returnedExpressions = Lists.newArrayList();
        this.collectReturnExpressions(returnedExpressions);
        boolean nothingReturned = returnedExpressions.isEmpty();
        returnedExpressions.remove(function);
        if (expectedReturnType != TypeUtils.NO_EXPECTED_TYPE && !JetStandardClasses.isUnit(expectedReturnType) && returnedExpressions.isEmpty() && !nothingReturned) {
            this.trace.report(Errors.RETURN_TYPE_MISMATCH.on(bodyExpression, expectedReturnType));
        }
        final boolean blockBody = function.hasBlockBody();
        final Set<JetElement> rootUnreachableElements = this.collectUnreachableCode();
        for (JetElement element : rootUnreachableElements) {
            this.trace.report(Errors.UNREACHABLE_CODE.on(element));
        }
        final boolean[] noReturnError = new boolean[]{false};
        for (JetElement returnedExpression : returnedExpressions) {
            returnedExpression.accept(new JetVisitorVoid(){

                @Override
                public void visitReturnExpression(JetReturnExpression expression) {
                    if (!blockBody) {
                        JetFlowInformationProvider.this.trace.report(Errors.RETURN_IN_FUNCTION_WITH_EXPRESSION_BODY.on(expression));
                    }
                }

                @Override
                public void visitExpression(JetExpression expression) {
                    if (blockBody && expectedReturnType != TypeUtils.NO_EXPECTED_TYPE && !JetStandardClasses.isUnit(expectedReturnType) && !rootUnreachableElements.contains(expression)) {
                        noReturnError[0] = true;
                    }
                }
            });
        }
        if (noReturnError[0]) {
            this.trace.report(Errors.NO_RETURN_IN_FUNCTION_WITH_BLOCK_BODY.on(function));
        }
    }

    private Set<JetElement> collectUnreachableCode() {
        ArrayList<JetElement> unreachableElements = Lists.newArrayList();
        for (Instruction deadInstruction : this.pseudocode.getDeadInstructions()) {
            if (!(deadInstruction instanceof JetElementInstruction) || deadInstruction instanceof ReadUnitValueInstruction) continue;
            unreachableElements.add(((JetElementInstruction)deadInstruction).getElement());
        }
        return JetPsiUtil.findRootExpressions(unreachableElements);
    }

    public void markUninitializedVariables(final boolean processLocalDeclaration) {
        final HashSet varWithUninitializedErrorGenerated = Sets.newHashSet();
        final HashSet varWithValReassignErrorGenerated = Sets.newHashSet();
        final boolean processClassOrObject = this.subroutine instanceof JetClassOrObject;
        Map<Instruction, PseudocodeTraverser.Edges<Map<VariableDescriptor, PseudocodeVariablesData.VariableInitState>>> initializers = this.pseudocodeVariablesData.getVariableInitializers();
        final Set<VariableDescriptor> declaredVariables = this.pseudocodeVariablesData.getDeclaredVariables(this.pseudocode);
        PseudocodeTraverser.traverse(this.pseudocode, true, true, initializers, new PseudocodeTraverser.InstructionDataAnalyzeStrategy<Map<VariableDescriptor, PseudocodeVariablesData.VariableInitState>>(){

            @Override
            public void execute(@NotNull Instruction instruction, @Nullable Map<VariableDescriptor, PseudocodeVariablesData.VariableInitState> in, @Nullable Map<VariableDescriptor, PseudocodeVariablesData.VariableInitState> out) {
                assert (in != null && out != null);
                VariableDescriptor variableDescriptor = PseudocodeUtil.extractVariableDescriptorIfAny(instruction, true, JetFlowInformationProvider.this.trace.getBindingContext());
                if (variableDescriptor == null) {
                    return;
                }
                if (!(instruction instanceof ReadValueInstruction) && !(instruction instanceof WriteValueInstruction)) {
                    return;
                }
                PseudocodeVariablesData.VariableInitState outInitState = out.get(variableDescriptor);
                if (instruction instanceof ReadValueInstruction) {
                    JetElement element = ((ReadValueInstruction)instruction).getElement();
                    boolean error = JetFlowInformationProvider.this.checkBackingField(variableDescriptor, element);
                    if (!error && declaredVariables.contains(variableDescriptor)) {
                        JetFlowInformationProvider.this.checkIsInitialized(variableDescriptor, element, outInitState, varWithUninitializedErrorGenerated);
                    }
                    return;
                }
                JetElement element = ((WriteValueInstruction)instruction).getlValue();
                boolean error = JetFlowInformationProvider.this.checkBackingField(variableDescriptor, element);
                if (!(element instanceof JetExpression)) {
                    return;
                }
                PseudocodeVariablesData.VariableInitState inInitState = in.get(variableDescriptor);
                if (!error && !processLocalDeclaration) {
                    error = JetFlowInformationProvider.this.checkValReassignment(variableDescriptor, (JetExpression)element, inInitState, varWithValReassignErrorGenerated);
                }
                if (!error && processClassOrObject) {
                    error = JetFlowInformationProvider.this.checkAssignmentBeforeDeclaration(variableDescriptor, (JetExpression)element, inInitState, outInitState);
                }
                if (!error && processClassOrObject) {
                    JetFlowInformationProvider.this.checkInitializationUsingBackingField(variableDescriptor, (JetExpression)element, inInitState, outInitState);
                }
            }
        });
        Pseudocode pseudocode = this.pseudocodeVariablesData.getPseudocode();
        this.recordInitializedVariables(pseudocode, initializers);
        for (LocalDeclarationInstruction instruction : pseudocode.getLocalDeclarations()) {
            this.recordInitializedVariables(instruction.getBody(), initializers);
        }
    }

    private void checkIsInitialized(@NotNull VariableDescriptor variableDescriptor, @NotNull JetElement element, @NotNull PseudocodeVariablesData.VariableInitState variableInitState, @NotNull Collection<VariableDescriptor> varWithUninitializedErrorGenerated) {
        if (!(element instanceof JetSimpleNameExpression)) {
            return;
        }
        boolean isInitialized = variableInitState.isInitialized;
        if (variableDescriptor instanceof PropertyDescriptor && !this.trace.get(BindingContext.BACKING_FIELD_REQUIRED, (PropertyDescriptor)variableDescriptor).booleanValue()) {
            isInitialized = true;
        }
        if (!isInitialized && !varWithUninitializedErrorGenerated.contains(variableDescriptor)) {
            varWithUninitializedErrorGenerated.add(variableDescriptor);
            if (variableDescriptor instanceof ValueParameterDescriptor) {
                this.trace.report(Errors.UNINITIALIZED_PARAMETER.on((JetSimpleNameExpression)element, (ValueParameterDescriptor)variableDescriptor));
            } else {
                this.trace.report(Errors.UNINITIALIZED_VARIABLE.on((JetSimpleNameExpression)element, variableDescriptor));
            }
        }
    }

    private boolean checkValReassignment(@NotNull VariableDescriptor variableDescriptor, @NotNull JetExpression expression, @NotNull PseudocodeVariablesData.VariableInitState enterInitState, @NotNull Collection<VariableDescriptor> varWithValReassignErrorGenerated) {
        boolean isInitializedNotHere = enterInitState.isInitialized;
        if (expression.getParent() instanceof JetProperty && ((JetProperty)expression).getInitializer() != null) {
            isInitializedNotHere = false;
        }
        boolean hasBackingField = true;
        if (variableDescriptor instanceof PropertyDescriptor) {
            hasBackingField = this.trace.get(BindingContext.BACKING_FIELD_REQUIRED, (PropertyDescriptor)variableDescriptor);
        }
        if (!(!isInitializedNotHere && hasBackingField || variableDescriptor.isVar() || varWithValReassignErrorGenerated.contains(variableDescriptor))) {
            boolean hasReassignMethodReturningUnit = false;
            JetSimpleNameExpression operationReference = null;
            PsiElement parent = expression.getParent();
            if (parent instanceof JetBinaryExpression) {
                operationReference = ((JetBinaryExpression)parent).getOperationReference();
            } else if (parent instanceof JetUnaryExpression) {
                operationReference = ((JetUnaryExpression)parent).getOperationReference();
            }
            if (operationReference != null) {
                Collection<? extends DeclarationDescriptor> descriptors;
                DeclarationDescriptor descriptor = this.trace.get(BindingContext.REFERENCE_TARGET, operationReference);
                if (descriptor instanceof FunctionDescriptor && JetStandardClasses.isUnit(((FunctionDescriptor)descriptor).getReturnType())) {
                    hasReassignMethodReturningUnit = true;
                }
                if (descriptor == null && (descriptors = this.trace.get(BindingContext.AMBIGUOUS_REFERENCE_TARGET, operationReference)) != null) {
                    for (DeclarationDescriptor declarationDescriptor : descriptors) {
                        if (!JetStandardClasses.isUnit(((FunctionDescriptor)declarationDescriptor).getReturnType())) continue;
                        hasReassignMethodReturningUnit = true;
                    }
                }
            }
            if (!hasReassignMethodReturningUnit) {
                varWithValReassignErrorGenerated.add(variableDescriptor);
                this.trace.report(Errors.VAL_REASSIGNMENT.on(expression, variableDescriptor));
                return true;
            }
        }
        return false;
    }

    private boolean checkAssignmentBeforeDeclaration(@NotNull VariableDescriptor variableDescriptor, @NotNull JetExpression expression, @NotNull PseudocodeVariablesData.VariableInitState enterInitState, @NotNull PseudocodeVariablesData.VariableInitState exitInitState) {
        if (!enterInitState.isDeclared && !exitInitState.isDeclared && !enterInitState.isInitialized && exitInitState.isInitialized) {
            this.trace.report(Errors.INITIALIZATION_BEFORE_DECLARATION.on(expression, variableDescriptor));
            return true;
        }
        return false;
    }

    private boolean checkInitializationUsingBackingField(@NotNull VariableDescriptor variableDescriptor, @NotNull JetExpression expression, @NotNull PseudocodeVariablesData.VariableInitState enterInitState, @NotNull PseudocodeVariablesData.VariableInitState exitInitState) {
        if (variableDescriptor instanceof PropertyDescriptor && !enterInitState.isInitialized && exitInitState.isInitialized) {
            JetSimpleNameExpression simpleNameExpression;
            if (!variableDescriptor.isVar()) {
                return false;
            }
            if (!this.trace.get(BindingContext.BACKING_FIELD_REQUIRED, (PropertyDescriptor)variableDescriptor).booleanValue()) {
                return false;
            }
            PsiElement property = BindingContextUtils.descriptorToDeclaration(this.trace.getBindingContext(), variableDescriptor);
            assert (property instanceof JetProperty);
            if (((PropertyDescriptor)variableDescriptor).getModality() == Modality.FINAL && ((JetProperty)property).getSetter() == null) {
                return false;
            }
            JetExpression variable = expression;
            if (expression instanceof JetDotQualifiedExpression && ((JetDotQualifiedExpression)expression).getReceiverExpression() instanceof JetThisExpression) {
                variable = ((JetDotQualifiedExpression)expression).getSelectorExpression();
            }
            if (variable instanceof JetSimpleNameExpression && (simpleNameExpression = (JetSimpleNameExpression)variable).getReferencedNameElementType() != JetTokens.FIELD_IDENTIFIER) {
                if (((PropertyDescriptor)variableDescriptor).getModality() != Modality.FINAL) {
                    this.trace.report(Errors.INITIALIZATION_USING_BACKING_FIELD_OPEN_SETTER.on(expression, variableDescriptor));
                } else {
                    this.trace.report(Errors.INITIALIZATION_USING_BACKING_FIELD_CUSTOM_SETTER.on(expression, variableDescriptor));
                }
                return true;
            }
        }
        return false;
    }

    private boolean checkBackingField(@NotNull VariableDescriptor variableDescriptor, @NotNull JetElement element) {
        boolean[] error = new boolean[1];
        if (this.isBackingFieldReference((JetElement)element.getParent(), error, false)) {
            return false;
        }
        if (!this.isBackingFieldReference(element, error, true)) {
            return false;
        }
        if (error[0]) {
            return true;
        }
        if (!(variableDescriptor instanceof PropertyDescriptor)) {
            this.trace.report(Errors.NOT_PROPERTY_BACKING_FIELD.on(element));
            return true;
        }
        PsiElement property = BindingContextUtils.descriptorToDeclaration(this.trace.getBindingContext(), variableDescriptor);
        boolean insideSelfAccessors = PsiTreeUtil.isAncestor(property, element, false);
        if (!this.trace.get(BindingContext.BACKING_FIELD_REQUIRED, (PropertyDescriptor)variableDescriptor).booleanValue() && !insideSelfAccessors) {
            if (((PropertyDescriptor)variableDescriptor).getModality() == Modality.ABSTRACT) {
                this.trace.report(Errors.NO_BACKING_FIELD_ABSTRACT_PROPERTY.on(element));
            } else {
                this.trace.report(Errors.NO_BACKING_FIELD_CUSTOM_ACCESSORS.on(element));
            }
            return true;
        }
        if (insideSelfAccessors) {
            return false;
        }
        JetNamedDeclaration parentDeclaration = PsiTreeUtil.getParentOfType((PsiElement)element, JetNamedDeclaration.class);
        DeclarationDescriptor declarationDescriptor = this.trace.get(BindingContext.DECLARATION_TO_DESCRIPTOR, parentDeclaration);
        assert (declarationDescriptor != null);
        DeclarationDescriptor containingDeclaration = variableDescriptor.getContainingDeclaration();
        if (containingDeclaration instanceof ClassDescriptor && DescriptorUtils.isAncestor(containingDeclaration, declarationDescriptor, false)) {
            return false;
        }
        this.trace.report(Errors.INACCESSIBLE_BACKING_FIELD.on(element));
        return true;
    }

    private boolean isBackingFieldReference(@Nullable JetElement element, boolean[] error, boolean reportError) {
        error[0] = false;
        if (element instanceof JetSimpleNameExpression && ((JetSimpleNameExpression)element).getReferencedNameElementType() == JetTokens.FIELD_IDENTIFIER) {
            return true;
        }
        if (element instanceof JetDotQualifiedExpression && this.isBackingFieldReference(((JetDotQualifiedExpression)element).getSelectorExpression(), error, false)) {
            if (((JetDotQualifiedExpression)element).getReceiverExpression() instanceof JetThisExpression) {
                return true;
            }
            error[0] = true;
            if (reportError) {
                this.trace.report(Errors.INACCESSIBLE_BACKING_FIELD.on(element));
            }
        }
        return false;
    }

    private void recordInitializedVariables(@NotNull Pseudocode pseudocode, @NotNull Map<Instruction, PseudocodeTraverser.Edges<Map<VariableDescriptor, PseudocodeVariablesData.VariableInitState>>> initializersMap) {
        PseudocodeTraverser.Edges<Map<VariableDescriptor, PseudocodeVariablesData.VariableInitState>> initializers = initializersMap.get(pseudocode.getExitInstruction());
        Set<VariableDescriptor> usedVariables = this.pseudocodeVariablesData.getUsedVariables(pseudocode);
        Set<VariableDescriptor> declaredVariables = this.pseudocodeVariablesData.getDeclaredVariables(pseudocode);
        for (VariableDescriptor variable : usedVariables) {
            if (!(variable instanceof PropertyDescriptor) || !declaredVariables.contains(variable)) continue;
            PseudocodeVariablesData.VariableInitState variableInitState = (PseudocodeVariablesData.VariableInitState)((Map)initializers.in).get(variable);
            if (variableInitState == null) {
                return;
            }
            this.trace.record(BindingContext.IS_INITIALIZED, (PropertyDescriptor)variable, variableInitState.isInitialized);
        }
    }

    public void markUnusedVariables() {
        Map variableStatusData = this.pseudocodeVariablesData.getVariableUseStatusData();
        PseudocodeTraverser.InstructionDataAnalyzeStrategy<Map<VariableDescriptor, PseudocodeVariablesData.VariableUseState>> variableStatusAnalyzeStrategy = new PseudocodeTraverser.InstructionDataAnalyzeStrategy<Map<VariableDescriptor, PseudocodeVariablesData.VariableUseState>>(){

            @Override
            public void execute(@NotNull Instruction instruction, @Nullable Map<VariableDescriptor, PseudocodeVariablesData.VariableUseState> in, @Nullable Map<VariableDescriptor, PseudocodeVariablesData.VariableUseState> out) {
                JetDeclaration element;
                assert (in != null && out != null);
                Set<VariableDescriptor> declaredVariables = JetFlowInformationProvider.this.pseudocodeVariablesData.getDeclaredVariables(instruction.getOwner());
                VariableDescriptor variableDescriptor = PseudocodeUtil.extractVariableDescriptorIfAny(instruction, false, JetFlowInformationProvider.this.trace.getBindingContext());
                if (variableDescriptor == null || !declaredVariables.contains(variableDescriptor) || !DescriptorUtils.isLocal(variableDescriptor.getContainingDeclaration(), variableDescriptor)) {
                    return;
                }
                PseudocodeVariablesData.VariableUseState variableUseState = in.get(variableDescriptor);
                if (instruction instanceof WriteValueInstruction) {
                    if (JetFlowInformationProvider.this.trace.get(BindingContext.CAPTURED_IN_CLOSURE, variableDescriptor).booleanValue()) {
                        return;
                    }
                    JetElement element2 = ((WriteValueInstruction)instruction).getElement();
                    if (variableUseState != PseudocodeVariablesData.VariableUseState.LAST_READ) {
                        IElementType operationToken;
                        if (element2 instanceof JetBinaryExpression && ((JetBinaryExpression)element2).getOperationToken() == JetTokens.EQ) {
                            JetExpression right = ((JetBinaryExpression)element2).getRight();
                            if (right != null) {
                                JetFlowInformationProvider.this.trace.report(Errors.UNUSED_VALUE.on(right, right, variableDescriptor));
                            }
                        } else if (element2 instanceof JetPostfixExpression && ((operationToken = ((JetPostfixExpression)element2).getOperationReference().getReferencedNameElementType()) == JetTokens.PLUSPLUS || operationToken == JetTokens.MINUSMINUS)) {
                            JetFlowInformationProvider.this.trace.report(Errors.UNUSED_CHANGED_VALUE.on(element2, element2));
                        }
                    }
                } else if (instruction instanceof VariableDeclarationInstruction && (element = ((VariableDeclarationInstruction)instruction).getVariableDeclarationElement()) instanceof JetNamedDeclaration) {
                    JetExpression initializer;
                    PsiElement nameIdentifier = ((JetNamedDeclaration)element).getNameIdentifier();
                    if (nameIdentifier == null) {
                        return;
                    }
                    if (!PseudocodeVariablesData.VariableUseState.isUsed(variableUseState)) {
                        PsiElement psiElement;
                        if (element instanceof JetProperty) {
                            JetFlowInformationProvider.this.trace.report(Errors.UNUSED_VARIABLE.on((JetProperty)element, variableDescriptor));
                        } else if (element instanceof JetParameter && (psiElement = element.getParent().getParent()) instanceof JetFunction) {
                            boolean isMain;
                            boolean bl = isMain = psiElement instanceof JetNamedFunction && JetMainDetector.isMain((JetNamedFunction)psiElement);
                            if (psiElement instanceof JetFunctionLiteral) {
                                return;
                            }
                            DeclarationDescriptor descriptor = JetFlowInformationProvider.this.trace.get(BindingContext.DECLARATION_TO_DESCRIPTOR, psiElement);
                            assert (descriptor instanceof FunctionDescriptor) : psiElement.getText();
                            FunctionDescriptor functionDescriptor = (FunctionDescriptor)descriptor;
                            if (!isMain && !functionDescriptor.getModality().isOverridable() && functionDescriptor.getOverriddenDescriptors().isEmpty()) {
                                JetFlowInformationProvider.this.trace.report(Errors.UNUSED_PARAMETER.on((JetParameter)element, variableDescriptor));
                            }
                        }
                    } else if (variableUseState == PseudocodeVariablesData.VariableUseState.ONLY_WRITTEN_NEVER_READ && element instanceof JetProperty) {
                        JetFlowInformationProvider.this.trace.report(Errors.ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE.on((JetNamedDeclaration)element, variableDescriptor));
                    } else if (variableUseState == PseudocodeVariablesData.VariableUseState.LAST_WRITTEN && element instanceof JetProperty && (initializer = ((JetProperty)element).getInitializer()) != null) {
                        JetFlowInformationProvider.this.trace.report(Errors.VARIABLE_WITH_REDUNDANT_INITIALIZER.on(initializer, variableDescriptor));
                    }
                }
            }
        };
        PseudocodeTraverser.traverse(this.pseudocode, false, true, variableStatusData, variableStatusAnalyzeStrategy);
    }

    public void markUnusedLiteralsInBlock() {
        assert (this.pseudocode != null);
        PseudocodeTraverser.traverse(this.pseudocode, true, new PseudocodeTraverser.InstructionAnalyzeStrategy(){

            @Override
            public void execute(@NotNull Instruction instruction) {
                if (!(instruction instanceof ReadValueInstruction)) {
                    return;
                }
                JetElement element = ((ReadValueInstruction)instruction).getElement();
                if (!(element instanceof JetFunctionLiteralExpression || element instanceof JetConstantExpression || element instanceof JetStringTemplateExpression || element instanceof JetSimpleNameExpression)) {
                    return;
                }
                PsiElement parent = element.getParent();
                if (parent instanceof JetBlockExpression && !JetPsiUtil.isImplicitlyUsed(element)) {
                    if (element instanceof JetFunctionLiteralExpression) {
                        JetFlowInformationProvider.this.trace.report(Errors.UNUSED_FUNCTION_LITERAL.on((JetFunctionLiteralExpression)element));
                    } else {
                        JetFlowInformationProvider.this.trace.report(Errors.UNUSED_EXPRESSION.on(element));
                    }
                }
            }
        });
    }
}

