/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.cfg;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.JetNodeTypes;
import org.jetbrains.jet.internal.com.google.common.collect.Lists;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.tree.IElementType;
import org.jetbrains.jet.lang.cfg.GenerationTrigger;
import org.jetbrains.jet.lang.cfg.JetControlFlowBuilder;
import org.jetbrains.jet.lang.cfg.Label;
import org.jetbrains.jet.lang.cfg.LoopInfo;
import org.jetbrains.jet.lang.cfg.WhenChecker;
import org.jetbrains.jet.lang.cfg.pseudocode.JetControlFlowInstructionsGenerator;
import org.jetbrains.jet.lang.cfg.pseudocode.LocalDeclarationInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.Pseudocode;
import org.jetbrains.jet.lang.cfg.pseudocode.PseudocodeImpl;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.JetArrayAccessExpression;
import org.jetbrains.jet.lang.psi.JetBinaryExpression;
import org.jetbrains.jet.lang.psi.JetBinaryExpressionWithTypeRHS;
import org.jetbrains.jet.lang.psi.JetBindingPattern;
import org.jetbrains.jet.lang.psi.JetBlockExpression;
import org.jetbrains.jet.lang.psi.JetBreakExpression;
import org.jetbrains.jet.lang.psi.JetCallElement;
import org.jetbrains.jet.lang.psi.JetCallExpression;
import org.jetbrains.jet.lang.psi.JetCatchClause;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassInitializer;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetConstantExpression;
import org.jetbrains.jet.lang.psi.JetContinueExpression;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetDeclarationWithBody;
import org.jetbrains.jet.lang.psi.JetDecomposerPattern;
import org.jetbrains.jet.lang.psi.JetDelegationSpecifier;
import org.jetbrains.jet.lang.psi.JetDelegatorByExpressionSpecifier;
import org.jetbrains.jet.lang.psi.JetDelegatorToSuperCall;
import org.jetbrains.jet.lang.psi.JetDoWhileExpression;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetExpressionPattern;
import org.jetbrains.jet.lang.psi.JetFinallySection;
import org.jetbrains.jet.lang.psi.JetForExpression;
import org.jetbrains.jet.lang.psi.JetFunction;
import org.jetbrains.jet.lang.psi.JetFunctionLiteral;
import org.jetbrains.jet.lang.psi.JetFunctionLiteralExpression;
import org.jetbrains.jet.lang.psi.JetHashQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetIfExpression;
import org.jetbrains.jet.lang.psi.JetIsExpression;
import org.jetbrains.jet.lang.psi.JetLabelQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetLoopExpression;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.psi.JetObjectLiteralExpression;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetParenthesizedExpression;
import org.jetbrains.jet.lang.psi.JetPattern;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetPropertyAccessor;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetReturnExpression;
import org.jetbrains.jet.lang.psi.JetSecondaryConstructor;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetStringTemplateEntry;
import org.jetbrains.jet.lang.psi.JetStringTemplateEntryWithExpression;
import org.jetbrains.jet.lang.psi.JetStringTemplateExpression;
import org.jetbrains.jet.lang.psi.JetThisExpression;
import org.jetbrains.jet.lang.psi.JetThrowExpression;
import org.jetbrains.jet.lang.psi.JetTryExpression;
import org.jetbrains.jet.lang.psi.JetTupleExpression;
import org.jetbrains.jet.lang.psi.JetTuplePattern;
import org.jetbrains.jet.lang.psi.JetTuplePatternEntry;
import org.jetbrains.jet.lang.psi.JetTypePattern;
import org.jetbrains.jet.lang.psi.JetTypeProjection;
import org.jetbrains.jet.lang.psi.JetUnaryExpression;
import org.jetbrains.jet.lang.psi.JetVisitorVoid;
import org.jetbrains.jet.lang.psi.JetWhenCondition;
import org.jetbrains.jet.lang.psi.JetWhenConditionInRange;
import org.jetbrains.jet.lang.psi.JetWhenConditionIsPattern;
import org.jetbrains.jet.lang.psi.JetWhenConditionWithExpression;
import org.jetbrains.jet.lang.psi.JetWhenEntry;
import org.jetbrains.jet.lang.psi.JetWhenExpression;
import org.jetbrains.jet.lang.psi.JetWhileExpression;
import org.jetbrains.jet.lang.psi.JetWildcardPattern;
import org.jetbrains.jet.lang.psi.ValueArgument;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.constants.BooleanValue;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstantResolver;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.expressions.OperatorConventions;
import org.jetbrains.jet.lang.types.lang.JetStandardClasses;
import org.jetbrains.jet.lang.types.lang.JetStandardLibrary;
import org.jetbrains.jet.lexer.JetTokens;

public class JetControlFlowProcessor {
    private final JetControlFlowBuilder builder = new JetControlFlowInstructionsGenerator();
    private final BindingTrace trace;

    public JetControlFlowProcessor(BindingTrace trace) {
        this.trace = trace;
    }

    public Pseudocode generatePseudocode(@NotNull JetDeclaration subroutine) {
        Pseudocode pseudocode = this.generate(subroutine);
        ((PseudocodeImpl)pseudocode).postProcess();
        for (LocalDeclarationInstruction localDeclarationInstruction : pseudocode.getLocalDeclarations()) {
            ((PseudocodeImpl)localDeclarationInstruction.getBody()).postProcess();
        }
        return pseudocode;
    }

    private Pseudocode generate(@NotNull JetDeclaration subroutine) {
        this.builder.enterSubroutine(subroutine);
        if (subroutine instanceof JetDeclarationWithBody) {
            JetDeclarationWithBody declarationWithBody = (JetDeclarationWithBody)((Object)subroutine);
            CFPVisitor cfpVisitor = new CFPVisitor(false);
            List<JetParameter> valueParameters = declarationWithBody.getValueParameters();
            for (JetParameter valueParameter : valueParameters) {
                valueParameter.accept(cfpVisitor);
            }
            JetExpression bodyExpression = declarationWithBody.getBodyExpression();
            if (bodyExpression != null) {
                bodyExpression.accept(cfpVisitor);
            }
        } else {
            subroutine.accept(new CFPVisitor(false));
        }
        return this.builder.exitSubroutine(subroutine);
    }

    private void processLocalDeclaration(@NotNull JetDeclaration subroutine) {
        Label afterDeclaration = this.builder.createUnboundLabel();
        this.builder.nondeterministicJump(afterDeclaration);
        this.generate(subroutine);
        this.builder.bindLabel(afterDeclaration);
    }

    private class CFPVisitor
    extends JetVisitorVoid {
        private final boolean inCondition;
        private final JetVisitorVoid conditionVisitor = new JetVisitorVoid(){

            @Override
            public void visitWhenConditionInRange(JetWhenConditionInRange condition) {
                CFPVisitor.this.value(condition.getRangeExpression(), CFPVisitor.this.inCondition);
                CFPVisitor.this.value(condition.getOperationReference(), CFPVisitor.this.inCondition);
            }

            @Override
            public void visitWhenConditionIsPattern(JetWhenConditionIsPattern condition) {
                JetPattern pattern = condition.getPattern();
                if (pattern != null) {
                    pattern.accept(CFPVisitor.this.patternVisitor);
                }
            }

            @Override
            public void visitWhenConditionWithExpression(JetWhenConditionWithExpression condition) {
                JetExpressionPattern pattern = condition.getPattern();
                if (pattern != null) {
                    pattern.accept(CFPVisitor.this.patternVisitor);
                }
            }

            @Override
            public void visitJetElement(JetElement element) {
                throw new UnsupportedOperationException("[JetControlFlowProcessor] " + element.toString());
            }
        };
        private final JetVisitorVoid patternVisitor = new JetVisitorVoid(){

            @Override
            public void visitTypePattern(JetTypePattern typePattern) {
            }

            @Override
            public void visitWildcardPattern(JetWildcardPattern pattern) {
            }

            @Override
            public void visitExpressionPattern(JetExpressionPattern pattern) {
                CFPVisitor.this.value(pattern.getExpression(), CFPVisitor.this.inCondition);
            }

            @Override
            public void visitTuplePattern(JetTuplePattern pattern) {
                List<JetTuplePatternEntry> entries = pattern.getEntries();
                for (JetTuplePatternEntry entry : entries) {
                    JetPattern entryPattern = entry.getPattern();
                    if (entryPattern == null) continue;
                    entryPattern.accept(this);
                }
            }

            @Override
            public void visitDecomposerPattern(JetDecomposerPattern pattern) {
                CFPVisitor.this.value(pattern.getDecomposerExpression(), CFPVisitor.this.inCondition);
                JetTuplePattern argumentList = pattern.getArgumentList();
                if (argumentList != null) {
                    argumentList.accept(this);
                }
            }

            @Override
            public void visitBindingPattern(JetBindingPattern pattern) {
                JetProperty variableDeclaration = pattern.getVariableDeclaration();
                JetControlFlowProcessor.this.builder.write(pattern, variableDeclaration);
                JetWhenCondition condition = pattern.getCondition();
                if (condition != null) {
                    condition.accept(CFPVisitor.this.conditionVisitor);
                }
            }

            @Override
            public void visitJetElement(JetElement element) {
                throw new UnsupportedOperationException("[JetControlFlowProcessor] " + element.toString());
            }
        };

        private CFPVisitor(boolean inCondition) {
            this.inCondition = inCondition;
        }

        private void value(@Nullable JetElement element, boolean inCondition) {
            if (element == null) {
                return;
            }
            CFPVisitor visitor = this.inCondition == inCondition ? this : new CFPVisitor(inCondition);
            element.accept(visitor);
        }

        @Override
        public void visitParenthesizedExpression(JetParenthesizedExpression expression) {
            JetControlFlowProcessor.this.builder.read(expression);
            JetExpression innerExpression = expression.getExpression();
            if (innerExpression != null) {
                this.value(innerExpression, this.inCondition);
            }
        }

        @Override
        public void visitThisExpression(JetThisExpression expression) {
            JetControlFlowProcessor.this.builder.read(expression);
        }

        @Override
        public void visitConstantExpression(JetConstantExpression expression) {
            JetControlFlowProcessor.this.builder.read(expression);
        }

        @Override
        public void visitSimpleNameExpression(JetSimpleNameExpression expression) {
            JetType type;
            JetControlFlowProcessor.this.builder.read(expression);
            if (JetControlFlowProcessor.this.trace.get(BindingContext.PROCESSED, expression).booleanValue() && (type = JetControlFlowProcessor.this.trace.getBindingContext().get(BindingContext.EXPRESSION_TYPE, expression)) != null && JetStandardClasses.isNothing(type)) {
                JetControlFlowProcessor.this.builder.jumpToError(expression);
            }
        }

        @Override
        public void visitLabelQualifiedExpression(JetLabelQualifiedExpression expression) {
            String labelName = expression.getLabelName();
            JetExpression labeledExpression = expression.getLabeledExpression();
            if (labelName != null && labeledExpression != null) {
                this.visitLabeledExpression(labelName, labeledExpression);
            }
        }

        private void visitLabeledExpression(@NotNull String labelName, @NotNull JetExpression labeledExpression) {
            JetExpression deparenthesized = JetPsiUtil.deparenthesize(labeledExpression);
            if (deparenthesized != null) {
                this.value(labeledExpression, this.inCondition);
            }
        }

        @Override
        public void visitBinaryExpression(JetBinaryExpression expression) {
            IElementType operationType = expression.getOperationReference().getReferencedNameElementType();
            JetExpression right = expression.getRight();
            if (operationType == JetTokens.ANDAND) {
                this.value(expression.getLeft(), true);
                Label resultLabel = JetControlFlowProcessor.this.builder.createUnboundLabel();
                JetControlFlowProcessor.this.builder.jumpOnFalse(resultLabel);
                if (right != null) {
                    this.value(right, true);
                }
                JetControlFlowProcessor.this.builder.bindLabel(resultLabel);
                if (!this.inCondition) {
                    JetControlFlowProcessor.this.builder.read(expression);
                }
            } else if (operationType == JetTokens.OROR) {
                this.value(expression.getLeft(), true);
                Label resultLabel = JetControlFlowProcessor.this.builder.createUnboundLabel();
                JetControlFlowProcessor.this.builder.jumpOnTrue(resultLabel);
                if (right != null) {
                    this.value(right, true);
                }
                JetControlFlowProcessor.this.builder.bindLabel(resultLabel);
                if (!this.inCondition) {
                    JetControlFlowProcessor.this.builder.read(expression);
                }
            } else if (operationType == JetTokens.EQ) {
                JetExpression left = JetPsiUtil.deparenthesize(expression.getLeft());
                if (right != null) {
                    this.value(right, false);
                }
                if (left instanceof JetSimpleNameExpression) {
                    JetControlFlowProcessor.this.builder.write(expression, left);
                } else if (left instanceof JetArrayAccessExpression) {
                    JetArrayAccessExpression arrayAccessExpression = (JetArrayAccessExpression)left;
                    this.visitAssignToArrayAccess(expression, arrayAccessExpression);
                } else if (left instanceof JetQualifiedExpression) {
                    assert (!(left instanceof JetHashQualifiedExpression)) : left;
                    JetQualifiedExpression qualifiedExpression = (JetQualifiedExpression)left;
                    this.value(qualifiedExpression.getReceiverExpression(), false);
                    this.value(expression.getOperationReference(), false);
                    JetControlFlowProcessor.this.builder.write(expression, left);
                } else {
                    JetControlFlowProcessor.this.builder.unsupported(expression);
                }
            } else if (OperatorConventions.ASSIGNMENT_OPERATIONS.containsKey(operationType)) {
                JetExpression left = JetPsiUtil.deparenthesize(expression.getLeft());
                if (left != null) {
                    this.value(left, false);
                }
                if (right != null) {
                    this.value(right, false);
                }
                if (left instanceof JetSimpleNameExpression || left instanceof JetArrayAccessExpression) {
                    this.value(expression.getOperationReference(), false);
                    JetControlFlowProcessor.this.builder.write(expression, left);
                } else if (left != null) {
                    JetControlFlowProcessor.this.builder.unsupported(expression);
                }
            } else if (operationType == JetTokens.ELVIS) {
                JetControlFlowProcessor.this.builder.read(expression);
                this.value(expression.getLeft(), false);
                this.value(expression.getOperationReference(), false);
                Label afterElvis = JetControlFlowProcessor.this.builder.createUnboundLabel();
                JetControlFlowProcessor.this.builder.jumpOnTrue(afterElvis);
                if (right != null) {
                    this.value(right, false);
                }
                JetControlFlowProcessor.this.builder.bindLabel(afterElvis);
            } else {
                this.value(expression.getLeft(), false);
                if (right != null) {
                    this.value(right, false);
                }
                this.value(expression.getOperationReference(), false);
                JetControlFlowProcessor.this.builder.read(expression);
            }
        }

        private void visitAssignToArrayAccess(JetBinaryExpression expression, JetArrayAccessExpression arrayAccessExpression) {
            for (JetExpression index : arrayAccessExpression.getIndexExpressions()) {
                this.value(index, false);
            }
            this.value(arrayAccessExpression.getArrayExpression(), false);
            this.value(expression.getOperationReference(), false);
            JetControlFlowProcessor.this.builder.write(expression, arrayAccessExpression);
        }

        @Override
        public void visitUnaryExpression(JetUnaryExpression expression) {
            JetSimpleNameExpression operationSign = expression.getOperationReference();
            IElementType operationType = operationSign.getReferencedNameElementType();
            JetExpression baseExpression = expression.getBaseExpression();
            if (baseExpression == null) {
                return;
            }
            if (JetTokens.LABELS.contains(operationType)) {
                String referencedName = operationSign.getReferencedName();
                referencedName = referencedName == null ? " <?>" : referencedName;
                this.visitLabeledExpression(referencedName.substring(1), baseExpression);
            } else {
                this.value(baseExpression, false);
                this.value(operationSign, false);
                boolean incrementOrDecrement = this.isIncrementOrDecrement(operationType);
                if (incrementOrDecrement) {
                    JetControlFlowProcessor.this.builder.write(expression, baseExpression);
                }
                JetControlFlowProcessor.this.builder.read(expression);
            }
        }

        private boolean isIncrementOrDecrement(IElementType operationType) {
            return operationType == JetTokens.PLUSPLUS || operationType == JetTokens.MINUSMINUS;
        }

        @Override
        public void visitIfExpression(JetIfExpression expression) {
            JetExpression condition = expression.getCondition();
            if (condition != null) {
                this.value(condition, true);
            }
            Label elseLabel = JetControlFlowProcessor.this.builder.createUnboundLabel();
            JetControlFlowProcessor.this.builder.jumpOnFalse(elseLabel);
            JetExpression thenBranch = expression.getThen();
            if (thenBranch != null) {
                this.value(thenBranch, this.inCondition);
            } else {
                JetControlFlowProcessor.this.builder.readUnit(expression);
            }
            Label resultLabel = JetControlFlowProcessor.this.builder.createUnboundLabel();
            JetControlFlowProcessor.this.builder.jump(resultLabel);
            JetControlFlowProcessor.this.builder.bindLabel(elseLabel);
            JetExpression elseBranch = expression.getElse();
            if (elseBranch != null) {
                this.value(elseBranch, this.inCondition);
            } else {
                JetControlFlowProcessor.this.builder.readUnit(expression);
            }
            JetControlFlowProcessor.this.builder.bindLabel(resultLabel);
        }

        @Override
        public void visitTryExpression(JetTryExpression expression) {
            List<JetCatchClause> catchClauses;
            JetControlFlowProcessor.this.builder.read(expression);
            final JetFinallySection finallyBlock = expression.getFinallyBlock();
            if (finallyBlock != null) {
                JetControlFlowProcessor.this.builder.enterTryFinally(new GenerationTrigger(){
                    private boolean working = false;

                    @Override
                    public void generate() {
                        if (this.working) {
                            return;
                        }
                        this.working = true;
                        CFPVisitor.this.value(finallyBlock.getFinalExpression(), CFPVisitor.this.inCondition);
                        this.working = false;
                    }
                });
            }
            boolean hasCatches = !(catchClauses = expression.getCatchClauses()).isEmpty();
            Label onException = null;
            if (hasCatches) {
                onException = JetControlFlowProcessor.this.builder.createUnboundLabel();
                JetControlFlowProcessor.this.builder.nondeterministicJump(onException);
            }
            this.value(expression.getTryBlock(), this.inCondition);
            if (hasCatches) {
                JetControlFlowProcessor.this.builder.allowDead();
                Label afterCatches = JetControlFlowProcessor.this.builder.createUnboundLabel();
                JetControlFlowProcessor.this.builder.jump(afterCatches);
                JetControlFlowProcessor.this.builder.bindLabel(onException);
                LinkedList<Label> catchLabels = Lists.newLinkedList();
                int catchClausesSize = catchClauses.size();
                for (int i = 0; i < catchClausesSize - 1; ++i) {
                    catchLabels.add(JetControlFlowProcessor.this.builder.createUnboundLabel());
                }
                JetControlFlowProcessor.this.builder.nondeterministicJump(catchLabels);
                boolean isFirst = true;
                for (JetCatchClause catchClause : catchClauses) {
                    JetExpression catchBody;
                    if (!isFirst) {
                        JetControlFlowProcessor.this.builder.bindLabel(catchLabels.remove());
                    } else {
                        isFirst = false;
                    }
                    JetParameter catchParameter = catchClause.getCatchParameter();
                    if (catchParameter != null) {
                        JetControlFlowProcessor.this.builder.declare(catchParameter);
                        JetControlFlowProcessor.this.builder.write(catchParameter, catchParameter);
                    }
                    if ((catchBody = catchClause.getCatchBody()) != null) {
                        this.value(catchBody, false);
                    }
                    JetControlFlowProcessor.this.builder.allowDead();
                    JetControlFlowProcessor.this.builder.jump(afterCatches);
                }
                JetControlFlowProcessor.this.builder.bindLabel(afterCatches);
            } else {
                JetControlFlowProcessor.this.builder.allowDead();
            }
            if (finallyBlock != null) {
                JetControlFlowProcessor.this.builder.exitTryFinally();
                this.value(finallyBlock.getFinalExpression(), this.inCondition);
            }
            JetControlFlowProcessor.this.builder.stopAllowDead();
        }

        @Override
        public void visitWhileExpression(JetWhileExpression expression) {
            JetControlFlowProcessor.this.builder.read(expression);
            LoopInfo loopInfo = JetControlFlowProcessor.this.builder.enterLoop(expression, null, null);
            JetControlFlowProcessor.this.builder.bindLabel(loopInfo.getConditionEntryPoint());
            JetExpression condition = expression.getCondition();
            if (condition != null) {
                this.value(condition, true);
            }
            boolean conditionIsTrueConstant = false;
            if (condition instanceof JetConstantExpression && condition.getNode().getElementType() == JetNodeTypes.BOOLEAN_CONSTANT && BooleanValue.TRUE == new CompileTimeConstantResolver().getBooleanValue(condition.getText(), JetStandardLibrary.getInstance().getBooleanType())) {
                conditionIsTrueConstant = true;
            }
            if (!conditionIsTrueConstant) {
                JetControlFlowProcessor.this.builder.jumpOnFalse(loopInfo.getExitPoint());
            }
            JetControlFlowProcessor.this.builder.bindLabel(loopInfo.getBodyEntryPoint());
            JetExpression body = expression.getBody();
            if (body != null) {
                this.value(body, false);
            }
            JetControlFlowProcessor.this.builder.jump(loopInfo.getEntryPoint());
            JetControlFlowProcessor.this.builder.exitLoop(expression);
            JetControlFlowProcessor.this.builder.readUnit(expression);
        }

        @Override
        public void visitDoWhileExpression(JetDoWhileExpression expression) {
            JetControlFlowProcessor.this.builder.read(expression);
            LoopInfo loopInfo = JetControlFlowProcessor.this.builder.enterLoop(expression, null, null);
            JetControlFlowProcessor.this.builder.bindLabel(loopInfo.getBodyEntryPoint());
            JetExpression body = expression.getBody();
            if (body != null) {
                this.value(body, false);
            }
            JetControlFlowProcessor.this.builder.bindLabel(loopInfo.getConditionEntryPoint());
            JetExpression condition = expression.getCondition();
            if (condition != null) {
                this.value(condition, true);
            }
            JetControlFlowProcessor.this.builder.jumpOnTrue(loopInfo.getEntryPoint());
            JetControlFlowProcessor.this.builder.exitLoop(expression);
            JetControlFlowProcessor.this.builder.readUnit(expression);
        }

        @Override
        public void visitForExpression(JetForExpression expression) {
            JetParameter loopParameter;
            JetControlFlowProcessor.this.builder.read(expression);
            JetExpression loopRange = expression.getLoopRange();
            if (loopRange != null) {
                this.value(loopRange, false);
            }
            if ((loopParameter = expression.getLoopParameter()) != null) {
                JetControlFlowProcessor.this.builder.declare(loopParameter);
                JetControlFlowProcessor.this.builder.write(loopParameter, loopParameter);
            }
            Label loopExitPoint = JetControlFlowProcessor.this.builder.createUnboundLabel();
            Label conditionEntryPoint = JetControlFlowProcessor.this.builder.createUnboundLabel();
            JetControlFlowProcessor.this.builder.bindLabel(conditionEntryPoint);
            JetControlFlowProcessor.this.builder.nondeterministicJump(loopExitPoint);
            LoopInfo loopInfo = JetControlFlowProcessor.this.builder.enterLoop(expression, loopExitPoint, conditionEntryPoint);
            JetControlFlowProcessor.this.builder.bindLabel(loopInfo.getBodyEntryPoint());
            JetExpression body = expression.getBody();
            if (body != null) {
                this.value(body, false);
            }
            JetControlFlowProcessor.this.builder.nondeterministicJump(loopInfo.getEntryPoint());
            JetControlFlowProcessor.this.builder.exitLoop(expression);
            JetControlFlowProcessor.this.builder.readUnit(expression);
        }

        @Override
        public void visitBreakExpression(JetBreakExpression expression) {
            JetElement loop = this.getCorrespondingLoop(expression);
            if (loop != null) {
                JetControlFlowProcessor.this.builder.jump(JetControlFlowProcessor.this.builder.getExitPoint(loop));
            }
        }

        @Override
        public void visitContinueExpression(JetContinueExpression expression) {
            JetElement loop = this.getCorrespondingLoop(expression);
            if (loop != null) {
                JetControlFlowProcessor.this.builder.jump(JetControlFlowProcessor.this.builder.getEntryPoint(loop));
            }
        }

        private JetElement getCorrespondingLoop(JetLabelQualifiedExpression expression) {
            JetElement loop;
            String labelName = expression.getLabelName();
            if (labelName != null) {
                JetSimpleNameExpression targetLabel = expression.getTargetLabel();
                assert (targetLabel != null);
                PsiElement labeledElement = BindingContextUtils.resolveToDeclarationPsiElement(JetControlFlowProcessor.this.trace.getBindingContext(), targetLabel);
                if (labeledElement instanceof JetLoopExpression) {
                    loop = (JetLoopExpression)labeledElement;
                } else {
                    JetControlFlowProcessor.this.trace.report(Errors.NOT_A_LOOP_LABEL.on(expression, targetLabel.getText()));
                    loop = null;
                }
            } else {
                loop = JetControlFlowProcessor.this.builder.getCurrentLoop();
                if (loop == null) {
                    JetControlFlowProcessor.this.trace.report(Errors.BREAK_OR_CONTINUE_OUTSIDE_A_LOOP.on(expression));
                }
            }
            return loop;
        }

        @Override
        public void visitReturnExpression(JetReturnExpression expression) {
            JetElement subroutine;
            JetExpression returnedExpression = expression.getReturnedExpression();
            if (returnedExpression != null) {
                this.value(returnedExpression, false);
            }
            JetSimpleNameExpression labelElement = expression.getTargetLabel();
            String labelName = expression.getLabelName();
            if (labelElement != null) {
                assert (labelName != null);
                PsiElement labeledElement = BindingContextUtils.resolveToDeclarationPsiElement(JetControlFlowProcessor.this.trace.getBindingContext(), labelElement);
                if (labeledElement != null) {
                    assert (labeledElement instanceof JetElement);
                    subroutine = (JetElement)labeledElement;
                } else {
                    subroutine = null;
                }
            } else {
                subroutine = JetControlFlowProcessor.this.builder.getReturnSubroutine();
            }
            if (subroutine instanceof JetFunctionLiteralExpression) {
                subroutine = ((JetFunctionLiteralExpression)subroutine).getFunctionLiteral();
            }
            if (subroutine instanceof JetFunction || subroutine instanceof JetPropertyAccessor || subroutine instanceof JetSecondaryConstructor) {
                if (returnedExpression == null) {
                    JetControlFlowProcessor.this.builder.returnNoValue(expression, subroutine);
                } else {
                    JetControlFlowProcessor.this.builder.returnValue(expression, subroutine);
                }
            }
        }

        @Override
        public void visitParameter(JetParameter parameter) {
            JetExpression defaultValue = parameter.getDefaultValue();
            JetControlFlowProcessor.this.builder.declare(parameter);
            if (defaultValue != null) {
                this.value(defaultValue, this.inCondition);
            }
            JetControlFlowProcessor.this.builder.write(parameter, parameter);
        }

        @Override
        public void visitBlockExpression(JetBlockExpression expression) {
            List<JetElement> statements = expression.getStatements();
            for (JetElement statement : statements) {
                this.value(statement, false);
            }
            if (statements.isEmpty()) {
                JetControlFlowProcessor.this.builder.readUnit(expression);
            }
        }

        @Override
        public void visitNamedFunction(JetNamedFunction function) {
            JetControlFlowProcessor.this.processLocalDeclaration(function);
        }

        @Override
        public void visitFunctionLiteralExpression(JetFunctionLiteralExpression expression) {
            JetFunctionLiteral functionLiteral = expression.getFunctionLiteral();
            JetControlFlowProcessor.this.processLocalDeclaration(functionLiteral);
            JetControlFlowProcessor.this.builder.read(expression);
        }

        @Override
        public void visitQualifiedExpression(JetQualifiedExpression expression) {
            JetType type;
            this.value(expression.getReceiverExpression(), false);
            JetExpression selectorExpression = expression.getSelectorExpression();
            if (selectorExpression != null) {
                this.value(selectorExpression, false);
            }
            JetControlFlowProcessor.this.builder.read(expression);
            if (JetControlFlowProcessor.this.trace.get(BindingContext.PROCESSED, expression).booleanValue() && (type = JetControlFlowProcessor.this.trace.getBindingContext().get(BindingContext.EXPRESSION_TYPE, expression)) != null && JetStandardClasses.isNothing(type)) {
                JetControlFlowProcessor.this.builder.jumpToError(expression);
            }
        }

        private void visitCall(JetCallElement call) {
            for (ValueArgument valueArgument : call.getValueArguments()) {
                JetExpression argumentExpression = valueArgument.getArgumentExpression();
                if (argumentExpression == null) continue;
                this.value(argumentExpression, false);
            }
            for (JetExpression jetExpression : call.getFunctionLiteralArguments()) {
                this.value(jetExpression, false);
            }
        }

        @Override
        public void visitCallExpression(JetCallExpression expression) {
            JetType type;
            for (JetTypeProjection typeArgument : expression.getTypeArguments()) {
                this.value(typeArgument, false);
            }
            this.visitCall(expression);
            this.value(expression.getCalleeExpression(), false);
            JetControlFlowProcessor.this.builder.read(expression);
            if (JetControlFlowProcessor.this.trace.get(BindingContext.PROCESSED, expression).booleanValue() && (type = JetControlFlowProcessor.this.trace.getBindingContext().get(BindingContext.EXPRESSION_TYPE, expression)) != null && JetStandardClasses.isNothing(type)) {
                JetControlFlowProcessor.this.builder.jumpToError(expression);
            }
        }

        @Override
        public void visitProperty(JetProperty property) {
            JetControlFlowProcessor.this.builder.declare(property);
            JetExpression initializer = property.getInitializer();
            if (initializer != null) {
                this.value(initializer, false);
                JetControlFlowProcessor.this.builder.write(property, property);
            }
            for (JetPropertyAccessor accessor : property.getAccessors()) {
                this.value(accessor, false);
            }
        }

        @Override
        public void visitPropertyAccessor(JetPropertyAccessor accessor) {
            JetControlFlowProcessor.this.processLocalDeclaration(accessor);
        }

        @Override
        public void visitTupleExpression(JetTupleExpression expression) {
            for (JetExpression entry : expression.getEntries()) {
                this.value(entry, false);
            }
            JetControlFlowProcessor.this.builder.read(expression);
        }

        @Override
        public void visitBinaryWithTypeRHSExpression(JetBinaryExpressionWithTypeRHS expression) {
            IElementType operationType = expression.getOperationSign().getReferencedNameElementType();
            if (operationType == JetTokens.COLON || operationType == JetTokens.AS_KEYWORD || operationType == JetTokens.AS_SAFE) {
                this.value(expression.getLeft(), false);
                JetControlFlowProcessor.this.builder.read(expression);
            } else {
                this.visitJetElement(expression);
            }
        }

        @Override
        public void visitThrowExpression(JetThrowExpression expression) {
            JetExpression thrownExpression = expression.getThrownExpression();
            if (thrownExpression != null) {
                this.value(thrownExpression, false);
            }
            JetControlFlowProcessor.this.builder.jumpToError(expression);
        }

        @Override
        public void visitArrayAccessExpression(JetArrayAccessExpression expression) {
            for (JetExpression index : expression.getIndexExpressions()) {
                this.value(index, false);
            }
            this.value(expression.getArrayExpression(), false);
            JetControlFlowProcessor.this.builder.read(expression);
        }

        @Override
        public void visitIsExpression(JetIsExpression expression) {
            this.value(expression.getLeftHandSide(), this.inCondition);
            JetPattern pattern = expression.getPattern();
            if (pattern != null) {
                pattern.accept(this.patternVisitor);
            }
            JetControlFlowProcessor.this.builder.read(expression);
        }

        @Override
        public void visitWhenExpression(JetWhenExpression expression) {
            JetExpression subjectExpression = expression.getSubjectExpression();
            if (subjectExpression != null) {
                this.value(subjectExpression, this.inCondition);
            }
            boolean hasElseOrIrrefutableBranch = false;
            Label doneLabel = JetControlFlowProcessor.this.builder.createUnboundLabel();
            Label nextLabel = null;
            Iterator<JetWhenEntry> iterator = expression.getEntries().iterator();
            while (iterator.hasNext()) {
                boolean isIrrefutable;
                JetWhenEntry whenEntry = iterator.next();
                JetControlFlowProcessor.this.builder.read(whenEntry);
                if (whenEntry.isElse()) {
                    hasElseOrIrrefutableBranch = true;
                    if (iterator.hasNext()) {
                        JetControlFlowProcessor.this.trace.report(Errors.ELSE_MISPLACED_IN_WHEN.on(whenEntry));
                    }
                }
                if (isIrrefutable = JetPsiUtil.isIrrefutable(whenEntry)) {
                    hasElseOrIrrefutableBranch = true;
                }
                Label bodyLabel = JetControlFlowProcessor.this.builder.createUnboundLabel();
                JetWhenCondition[] conditions = whenEntry.getConditions();
                for (int i = 0; i < conditions.length; ++i) {
                    JetWhenCondition condition = conditions[i];
                    condition.accept(this.conditionVisitor);
                    if (i + 1 >= conditions.length) continue;
                    JetControlFlowProcessor.this.builder.nondeterministicJump(bodyLabel);
                }
                if (!isIrrefutable) {
                    nextLabel = JetControlFlowProcessor.this.builder.createUnboundLabel();
                    JetControlFlowProcessor.this.builder.nondeterministicJump(nextLabel);
                }
                JetControlFlowProcessor.this.builder.bindLabel(bodyLabel);
                this.value(whenEntry.getExpression(), this.inCondition);
                JetControlFlowProcessor.this.builder.allowDead();
                JetControlFlowProcessor.this.builder.jump(doneLabel);
                if (isIrrefutable) continue;
                JetControlFlowProcessor.this.builder.bindLabel(nextLabel);
            }
            JetControlFlowProcessor.this.builder.bindLabel(doneLabel);
            boolean isWhenExhaust = WhenChecker.isWhenExhaustive(expression, JetControlFlowProcessor.this.trace);
            if (!hasElseOrIrrefutableBranch && !isWhenExhaust) {
                JetControlFlowProcessor.this.trace.report(Errors.NO_ELSE_IN_WHEN.on(expression));
            }
            JetControlFlowProcessor.this.builder.stopAllowDead();
        }

        @Override
        public void visitObjectLiteralExpression(JetObjectLiteralExpression expression) {
            JetObjectDeclaration declaration = expression.getObjectDeclaration();
            this.value(declaration, this.inCondition);
            List<JetDeclaration> declarations = declaration.getDeclarations();
            ArrayList<JetDeclaration> functions = Lists.newArrayList();
            for (JetDeclaration localDeclaration : declarations) {
                if (localDeclaration instanceof JetProperty || localDeclaration instanceof JetClassInitializer) continue;
                functions.add(localDeclaration);
            }
            for (JetDeclaration function : functions) {
                this.value(function, this.inCondition);
            }
            JetControlFlowProcessor.this.builder.read(expression);
        }

        @Override
        public void visitObjectDeclaration(JetObjectDeclaration objectDeclaration) {
            this.visitClassOrObject(objectDeclaration);
        }

        @Override
        public void visitStringTemplateExpression(JetStringTemplateExpression expression) {
            for (JetStringTemplateEntry entry : expression.getEntries()) {
                if (!(entry instanceof JetStringTemplateEntryWithExpression)) continue;
                JetStringTemplateEntryWithExpression entryWithExpression = (JetStringTemplateEntryWithExpression)entry;
                this.value(entryWithExpression.getExpression(), false);
            }
            JetControlFlowProcessor.this.builder.read(expression);
        }

        @Override
        public void visitTypeProjection(JetTypeProjection typeProjection) {
        }

        @Override
        public void visitAnonymousInitializer(JetClassInitializer classInitializer) {
            this.value(classInitializer.getBody(), this.inCondition);
        }

        private void visitClassOrObject(JetClassOrObject classOrObject) {
            for (JetDelegationSpecifier specifier : classOrObject.getDelegationSpecifiers()) {
                this.value(specifier, this.inCondition);
            }
            List<JetDeclaration> declarations = classOrObject.getDeclarations();
            ArrayList<JetProperty> properties = Lists.newArrayList();
            for (JetDeclaration declaration : declarations) {
                if (declaration instanceof JetProperty) {
                    this.value(declaration, this.inCondition);
                    properties.add((JetProperty)declaration);
                    continue;
                }
                if (!(declaration instanceof JetClassInitializer)) continue;
                this.value(declaration, this.inCondition);
            }
        }

        @Override
        public void visitClass(JetClass klass) {
            List<JetParameter> parameters = klass.getPrimaryConstructorParameters();
            for (JetParameter parameter : parameters) {
                this.value(parameter, this.inCondition);
            }
            this.visitClassOrObject(klass);
        }

        @Override
        public void visitDelegationToSuperCallSpecifier(JetDelegatorToSuperCall call) {
            List<? extends ValueArgument> valueArguments = call.getValueArguments();
            for (ValueArgument valueArgument : valueArguments) {
                this.value(valueArgument.getArgumentExpression(), this.inCondition);
            }
        }

        @Override
        public void visitDelegationByExpressionSpecifier(JetDelegatorByExpressionSpecifier specifier) {
            this.value(specifier.getDelegateExpression(), this.inCondition);
        }

        @Override
        public void visitJetElement(JetElement element) {
            JetControlFlowProcessor.this.builder.unsupported(element);
        }
    }
}

