/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang;

import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.openapi.project.Project;
import org.jetbrains.jet.lang.ModuleConfiguration;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.psi.JetImportDirective;
import org.jetbrains.jet.lang.psi.JetPsiFactory;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.ImportPath;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;
import org.jetbrains.jet.lang.types.lang.JetStandardClasses;
import org.jetbrains.jet.lang.types.lang.JetStandardLibrary;

public class DefaultModuleConfiguration
implements ModuleConfiguration {
    public static final ImportPath[] DEFAULT_JET_IMPORTS = new ImportPath[]{new ImportPath("kotlin.*"), new ImportPath("kotlin.io.*"), new ImportPath("jet.*")};
    private final Project project;
    private final boolean extendBuiltins;

    public static DefaultModuleConfiguration createStandardConfiguration(Project project, boolean extendBuiltins) {
        return new DefaultModuleConfiguration(project, extendBuiltins);
    }

    private DefaultModuleConfiguration(@NotNull Project project, boolean extendBuiltins) {
        this.project = project;
        this.extendBuiltins = extendBuiltins;
    }

    @Override
    public void addDefaultImports(@NotNull Collection<JetImportDirective> directives) {
        for (ImportPath defaultJetImport : DEFAULT_JET_IMPORTS) {
            directives.add(JetPsiFactory.createImportDirective(this.project, defaultJetImport));
        }
    }

    @Override
    public void extendNamespaceScope(@NotNull BindingTrace trace, @NotNull NamespaceDescriptor namespaceDescriptor, @NotNull WritableScope namespaceMemberScope) {
        if (DescriptorUtils.getFQName(namespaceDescriptor).equals(JetStandardClasses.STANDARD_CLASSES_FQNAME.toUnsafe())) {
            if (!this.extendBuiltins) {
                namespaceMemberScope.importScope(JetStandardClasses.STANDARD_CLASSES);
            } else {
                namespaceMemberScope.importScope(JetStandardLibrary.getInstance().getLibraryScope());
            }
        }
    }
}

