/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.j2k.visitors;

import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.psi.PsiArrayType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiCapturedWildcardType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClass;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClassType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiDisjunctionType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiEllipsisType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiPrimitiveType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.jet.internal.com.intellij.psi.PsiTypeVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiWildcardType;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.PsiClassReferenceType;
import org.jetbrains.jet.j2k.Converter;
import org.jetbrains.jet.j2k.J2KConverterFlags;
import org.jetbrains.jet.j2k.ast.ArrayType;
import org.jetbrains.jet.j2k.ast.ClassType;
import org.jetbrains.jet.j2k.ast.IdentifierImpl;
import org.jetbrains.jet.j2k.ast.InProjectionType;
import org.jetbrains.jet.j2k.ast.Node;
import org.jetbrains.jet.j2k.ast.OutProjectionType;
import org.jetbrains.jet.j2k.ast.PrimitiveType;
import org.jetbrains.jet.j2k.ast.StarProjectionType;
import org.jetbrains.jet.j2k.ast.Type;
import org.jetbrains.jet.j2k.ast.VarArg;
import org.jetbrains.jet.j2k.util.AstUtil;
import org.jetbrains.jet.j2k.visitors.J2KVisitor;
import org.jetbrains.jet.lang.types.lang.JetStandardClasses;

public class TypeVisitor
extends PsiTypeVisitor<Type>
implements J2KVisitor {
    public static final String JAVA_LANG_BYTE = "java.lang.Byte";
    public static final String JAVA_LANG_CHARACTER = "java.lang.Character";
    public static final String JAVA_LANG_DOUBLE = "java.lang.Double";
    public static final String JAVA_LANG_FLOAT = "java.lang.Float";
    public static final String JAVA_LANG_INTEGER = "java.lang.Integer";
    public static final String JAVA_LANG_LONG = "java.lang.Long";
    public static final String JAVA_LANG_SHORT = "java.lang.Short";
    public static final String JAVA_LANG_OBJECT = "java.lang.Object";
    public static final String JAVA_LANG_STRING = "java.lang.String";
    private final Converter myConverter;
    private Type myResult = Type.EMPTY_TYPE;

    public TypeVisitor(@NotNull Converter myConverter) {
        this.myConverter = myConverter;
    }

    @NotNull
    public Type getResult() {
        return this.myResult;
    }

    @Override
    public Type visitPrimitiveType(@NotNull PsiPrimitiveType primitiveType) {
        String name = primitiveType.getCanonicalText();
        IdentifierImpl identifier = new IdentifierImpl(name);
        this.myResult = name.equals("void") ? new PrimitiveType(new IdentifierImpl(JetStandardClasses.UNIT_ALIAS.getName())) : (Node.PRIMITIVE_TYPES.contains(name) ? new PrimitiveType(new IdentifierImpl(AstUtil.upperFirstCharacter(name))) : new PrimitiveType(identifier));
        return (Type)super.visitPrimitiveType(primitiveType);
    }

    @Override
    public Type visitArrayType(@NotNull PsiArrayType arrayType) {
        if (this.myResult == Type.EMPTY_TYPE) {
            this.myResult = new ArrayType(this.getConverter().typeToType(arrayType.getComponentType()));
        }
        return (Type)super.visitArrayType(arrayType);
    }

    @Override
    public Type visitClassType(@NotNull PsiClassType classType) {
        IdentifierImpl identifier = this.constructClassTypeIdentifier(classType);
        List<Type> resolvedClassTypeParams = this.createRawTypesForResolvedReference(classType);
        this.myResult = classType.getParameterCount() == 0 && resolvedClassTypeParams.size() > 0 ? new ClassType(identifier, resolvedClassTypeParams) : new ClassType(identifier, this.getConverter().typesToTypeList(classType.getParameters()));
        return (Type)super.visitClassType(classType);
    }

    @NotNull
    private IdentifierImpl constructClassTypeIdentifier(@NotNull PsiClassType classType) {
        String classTypeName;
        String qualifiedName;
        PsiClass psiClass = classType.resolve();
        if (psiClass != null && (qualifiedName = psiClass.getQualifiedName()) != null) {
            if (!qualifiedName.equals(JAVA_LANG_OBJECT) && this.getConverter().hasFlag(J2KConverterFlags.FULLY_QUALIFIED_TYPE_NAMES)) {
                return new IdentifierImpl(qualifiedName);
            }
            if (qualifiedName.equals("java.lang.Iterable")) {
                return new IdentifierImpl("java.lang.Iterable");
            }
            if (qualifiedName.equals("java.util.Iterator")) {
                return new IdentifierImpl("java.util.Iterator");
            }
        }
        if ((classTypeName = TypeVisitor.createQualifiedName(classType)).isEmpty()) {
            return new IdentifierImpl(TypeVisitor.getClassTypeName(classType));
        }
        return new IdentifierImpl(classTypeName);
    }

    @NotNull
    private static String createQualifiedName(@NotNull PsiClassType classType) {
        PsiJavaCodeReferenceElement reference;
        String classTypeName = "";
        if (classType instanceof PsiClassReferenceType && (reference = ((PsiClassReferenceType)classType).getReference()).isQualified()) {
            String result = new IdentifierImpl(reference.getReferenceName()).toKotlin();
            PsiElement qualifier = reference.getQualifier();
            while (qualifier != null) {
                PsiJavaCodeReferenceElement p = (PsiJavaCodeReferenceElement)qualifier;
                result = new IdentifierImpl(p.getReferenceName()).toKotlin() + "." + result;
                qualifier = p.getQualifier();
            }
            classTypeName = result;
        }
        return classTypeName;
    }

    @NotNull
    private List<Type> createRawTypesForResolvedReference(@NotNull PsiClassType classType) {
        PsiJavaCodeReferenceElement reference;
        PsiElement resolve;
        LinkedList<Type> typeParams = new LinkedList<Type>();
        if (classType instanceof PsiClassReferenceType && (resolve = (reference = ((PsiClassReferenceType)classType).getReference()).resolve()) != null && resolve instanceof PsiClass) {
            for (PsiTypeParameter p : ((PsiClass)resolve).getTypeParameters()) {
                Type boundType = p.getSuperTypes().length > 0 ? new ClassType(new IdentifierImpl(TypeVisitor.getClassTypeName(p.getSuperTypes()[0])), this.getConverter().typesToTypeList(p.getSuperTypes()[0].getParameters()), true) : new StarProjectionType();
                typeParams.add(boundType);
            }
        }
        return typeParams;
    }

    @NotNull
    private static String getClassTypeName(@NotNull PsiClassType classType) {
        String canonicalTypeStr = classType.getCanonicalText();
        if (canonicalTypeStr.equals(JAVA_LANG_OBJECT)) {
            return "Any";
        }
        if (canonicalTypeStr.equals(JAVA_LANG_BYTE)) {
            return "Byte";
        }
        if (canonicalTypeStr.equals(JAVA_LANG_CHARACTER)) {
            return "Char";
        }
        if (canonicalTypeStr.equals(JAVA_LANG_DOUBLE)) {
            return "Double";
        }
        if (canonicalTypeStr.equals(JAVA_LANG_FLOAT)) {
            return "Float";
        }
        if (canonicalTypeStr.equals(JAVA_LANG_INTEGER)) {
            return "Int";
        }
        if (canonicalTypeStr.equals(JAVA_LANG_LONG)) {
            return "Long";
        }
        if (canonicalTypeStr.equals(JAVA_LANG_SHORT)) {
            return "Short";
        }
        if (canonicalTypeStr.equals("java.lang.Boolean")) {
            return "Boolean";
        }
        return classType.getClassName() != null ? classType.getClassName() : classType.getCanonicalText();
    }

    @Override
    public Type visitWildcardType(@NotNull PsiWildcardType wildcardType) {
        this.myResult = wildcardType.isExtends() ? new OutProjectionType(this.getConverter().typeToType(wildcardType.getExtendsBound())) : (wildcardType.isSuper() ? new InProjectionType(this.getConverter().typeToType(wildcardType.getSuperBound())) : new StarProjectionType());
        return (Type)super.visitWildcardType(wildcardType);
    }

    @Override
    public Type visitEllipsisType(@NotNull PsiEllipsisType ellipsisType) {
        this.myResult = new VarArg(this.getConverter().typeToType(ellipsisType.getComponentType()));
        return (Type)super.visitEllipsisType(ellipsisType);
    }

    @Override
    public Type visitCapturedWildcardType(PsiCapturedWildcardType capturedWildcardType) {
        return (Type)super.visitCapturedWildcardType(capturedWildcardType);
    }

    @Override
    public Type visitDisjunctionType(PsiDisjunctionType disjunctionType) {
        return (Type)super.visitDisjunctionType(disjunctionType);
    }

    @Override
    @NotNull
    public Converter getConverter() {
        return this.myConverter;
    }
}

