/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.j2k.visitors;

import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.google.common.collect.Sets;
import org.jetbrains.jet.internal.com.intellij.psi.JavaRecursiveElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiMethod;
import org.jetbrains.jet.internal.com.intellij.psi.PsiReference;
import org.jetbrains.jet.internal.com.intellij.psi.PsiReferenceExpression;

public class ThisVisitor
extends JavaRecursiveElementVisitor {
    @NotNull
    private final Set<PsiMethod> myResolvedConstructors = Sets.newLinkedHashSet();

    @Override
    public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
        for (PsiReference r : expression.getReferences()) {
            PsiElement res;
            if (!r.getCanonicalText().equals("this") || (res = r.resolve()) == null || !(res instanceof PsiMethod) || !((PsiMethod)res).isConstructor()) continue;
            this.myResolvedConstructors.add((PsiMethod)res);
        }
    }

    @Nullable
    public PsiMethod getPrimaryConstructor() {
        if (this.myResolvedConstructors.size() > 0) {
            PsiMethod first = this.myResolvedConstructors.toArray(new PsiMethod[this.myResolvedConstructors.size()])[0];
            for (PsiMethod m : this.myResolvedConstructors) {
                if (m.hashCode() == first.hashCode()) continue;
                return null;
            }
            return first;
        }
        return null;
    }
}

