/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.j2k.visitors;

import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.psi.JavaRecursiveElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiExpressionList;
import org.jetbrains.jet.internal.com.intellij.psi.PsiMethod;
import org.jetbrains.jet.internal.com.intellij.psi.PsiMethodCallExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiReference;

public class SuperVisitor
extends JavaRecursiveElementVisitor {
    @NotNull
    private final HashSet<PsiExpressionList> myResolvedSuperCallParameters = new HashSet();

    @NotNull
    public HashSet<PsiExpressionList> getResolvedSuperCallParameters() {
        return this.myResolvedSuperCallParameters;
    }

    @Override
    public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
        super.visitMethodCallExpression(expression);
        if (SuperVisitor.isSuper(expression.getMethodExpression())) {
            this.myResolvedSuperCallParameters.add(expression.getArgumentList());
        }
    }

    static boolean isSuper(@NotNull PsiReference r) {
        PsiElement baseConstructor;
        return r.getCanonicalText().equals("super") && (baseConstructor = r.resolve()) != null && baseConstructor instanceof PsiMethod && ((PsiMethod)baseConstructor).isConstructor();
    }
}

