/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.j2k.visitors;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.psi.JavaTokenType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiAssertStatement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiBinaryExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiBlockStatement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiBreakStatement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiCodeBlock;
import org.jetbrains.jet.internal.com.intellij.psi.PsiContinueStatement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiDeclarationStatement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiDoWhileStatement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiExpressionListStatement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiExpressionStatement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiForStatement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiForeachStatement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiIfStatement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiLabeledStatement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiLocalVariable;
import org.jetbrains.jet.internal.com.intellij.psi.PsiPostfixExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiPrefixExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiReturnStatement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiStatement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiSwitchLabelStatement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiSwitchStatement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiSynchronizedStatement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiThrowStatement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiTryStatement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiWhileStatement;
import org.jetbrains.jet.internal.com.intellij.psi.tree.IElementType;
import org.jetbrains.jet.j2k.Converter;
import org.jetbrains.jet.j2k.ConverterUtil;
import org.jetbrains.jet.j2k.ast.AssertStatement;
import org.jetbrains.jet.j2k.ast.BinaryExpression;
import org.jetbrains.jet.j2k.ast.Block;
import org.jetbrains.jet.j2k.ast.BreakStatement;
import org.jetbrains.jet.j2k.ast.CaseContainer;
import org.jetbrains.jet.j2k.ast.CatchStatement;
import org.jetbrains.jet.j2k.ast.ContinueStatement;
import org.jetbrains.jet.j2k.ast.DeclarationStatement;
import org.jetbrains.jet.j2k.ast.DefaultSwitchLabelStatement;
import org.jetbrains.jet.j2k.ast.DoWhileStatement;
import org.jetbrains.jet.j2k.ast.Expression;
import org.jetbrains.jet.j2k.ast.ExpressionListStatement;
import org.jetbrains.jet.j2k.ast.ForeachStatement;
import org.jetbrains.jet.j2k.ast.ForeachWithRangeStatement;
import org.jetbrains.jet.j2k.ast.IdentifierImpl;
import org.jetbrains.jet.j2k.ast.IfStatement;
import org.jetbrains.jet.j2k.ast.LabelStatement;
import org.jetbrains.jet.j2k.ast.ReturnStatement;
import org.jetbrains.jet.j2k.ast.Statement;
import org.jetbrains.jet.j2k.ast.SwitchContainer;
import org.jetbrains.jet.j2k.ast.SwitchLabelStatement;
import org.jetbrains.jet.j2k.ast.SynchronizedStatement;
import org.jetbrains.jet.j2k.ast.ThrowStatement;
import org.jetbrains.jet.j2k.ast.TryStatement;
import org.jetbrains.jet.j2k.ast.WhileStatement;
import org.jetbrains.jet.j2k.visitors.ElementVisitor;

public class StatementVisitor
extends ElementVisitor {
    private Statement myResult = Statement.EMPTY_STATEMENT;

    public StatementVisitor(@NotNull Converter converter) {
        super(converter);
    }

    @Override
    @NotNull
    public Statement getResult() {
        return this.myResult;
    }

    @Override
    public void visitAssertStatement(@NotNull PsiAssertStatement statement) {
        super.visitAssertStatement(statement);
        this.myResult = new AssertStatement(this.getConverter().expressionToExpression(statement.getAssertCondition()), this.getConverter().expressionToExpression(statement.getAssertDescription()));
    }

    @Override
    public void visitBlockStatement(@NotNull PsiBlockStatement statement) {
        super.visitBlockStatement(statement);
        this.myResult = new Block(this.getConverter().statementsToStatementList(statement.getCodeBlock().getStatements()), true);
    }

    @Override
    public void visitBreakStatement(@NotNull PsiBreakStatement statement) {
        super.visitBreakStatement(statement);
        this.myResult = statement.getLabelIdentifier() == null ? new BreakStatement() : new BreakStatement(Converter.identifierToIdentifier(statement.getLabelIdentifier()));
    }

    @Override
    public void visitContinueStatement(@NotNull PsiContinueStatement statement) {
        super.visitContinueStatement(statement);
        this.myResult = statement.getLabelIdentifier() == null ? new ContinueStatement() : new ContinueStatement(Converter.identifierToIdentifier(statement.getLabelIdentifier()));
    }

    @Override
    public void visitDeclarationStatement(@NotNull PsiDeclarationStatement statement) {
        super.visitDeclarationStatement(statement);
        this.myResult = new DeclarationStatement(this.getConverter().elementsToElementList(statement.getDeclaredElements()));
    }

    @Override
    public void visitDoWhileStatement(@NotNull PsiDoWhileStatement statement) {
        super.visitDoWhileStatement(statement);
        PsiExpression condition = statement.getCondition();
        Expression expression = condition != null && condition.getType() != null ? this.getConverter().createSureCallOnlyForChain(condition, condition.getType()) : this.getConverter().expressionToExpression(condition);
        this.myResult = new DoWhileStatement(expression, this.getConverter().statementToStatement(statement.getBody()));
    }

    @Override
    public void visitExpressionStatement(@NotNull PsiExpressionStatement statement) {
        super.visitExpressionStatement(statement);
        this.myResult = this.getConverter().expressionToExpression(statement.getExpression());
    }

    @Override
    public void visitExpressionListStatement(@NotNull PsiExpressionListStatement statement) {
        super.visitExpressionListStatement(statement);
        this.myResult = new ExpressionListStatement(this.getConverter().expressionsToExpressionList(statement.getExpressionList().getExpressions()));
    }

    @Override
    public void visitForStatement(@NotNull PsiForStatement statement) {
        IElementType operationTokenType;
        super.visitForStatement(statement);
        PsiStatement initialization = statement.getInitialization();
        PsiStatement update = statement.getUpdate();
        PsiExpression condition = statement.getCondition();
        PsiStatement body = statement.getBody();
        PsiLocalVariable firstChild = initialization != null && initialization.getFirstChild() instanceof PsiLocalVariable ? (PsiLocalVariable)initialization.getFirstChild() : null;
        int bodyWriteCount = ConverterUtil.countWritingAccesses(firstChild, body);
        int conditionWriteCount = ConverterUtil.countWritingAccesses(firstChild, condition);
        int updateWriteCount = ConverterUtil.countWritingAccesses(firstChild, update);
        boolean onceWritableIterator = updateWriteCount == 1 && bodyWriteCount + conditionWriteCount == 0;
        IElementType iElementType = operationTokenType = condition != null && condition instanceof PsiBinaryExpression ? ((PsiBinaryExpression)condition).getOperationTokenType() : null;
        if (initialization != null && initialization instanceof PsiDeclarationStatement && initialization.getFirstChild() == initialization.getLastChild() && condition != null && update != null && update.getChildren().length == 1 && StatementVisitor.isPlusPlusExpression(update.getChildren()[0]) && operationTokenType != null && (operationTokenType == JavaTokenType.LT || operationTokenType == JavaTokenType.LE) && initialization.getFirstChild() != null && initialization.getFirstChild() instanceof PsiLocalVariable && firstChild != null && firstChild.getNameIdentifier() != null && onceWritableIterator) {
            Expression end = this.getConverter().expressionToExpression(((PsiBinaryExpression)condition).getROperand());
            Expression endExpression = operationTokenType == JavaTokenType.LT ? new BinaryExpression(end, new IdentifierImpl("1"), "-") : end;
            this.myResult = new ForeachWithRangeStatement(new IdentifierImpl(firstChild.getName()), this.getConverter().expressionToExpression(firstChild.getInitializer()), endExpression, this.getConverter().statementToStatement(body));
        } else {
            LinkedList<Statement> forStatements = new LinkedList<Statement>();
            forStatements.add(this.getConverter().statementToStatement(initialization));
            forStatements.add(new WhileStatement(this.getConverter().expressionToExpression(condition), new Block(Arrays.asList(this.getConverter().statementToStatement(body), new Block(Arrays.asList(this.getConverter().statementToStatement(update)))))));
            this.myResult = new Block(forStatements);
        }
    }

    private static boolean isPlusPlusExpression(@NotNull PsiElement psiElement) {
        return psiElement instanceof PsiPostfixExpression && ((PsiPostfixExpression)psiElement).getOperationTokenType() == JavaTokenType.PLUSPLUS || psiElement instanceof PsiPrefixExpression && ((PsiPrefixExpression)psiElement).getOperationTokenType() == JavaTokenType.PLUSPLUS;
    }

    @Override
    public void visitForeachStatement(@NotNull PsiForeachStatement statement) {
        super.visitForeachStatement(statement);
        this.myResult = new ForeachStatement(this.getConverter().parameterToParameter(statement.getIterationParameter()), this.getConverter().expressionToExpression(statement.getIteratedValue()), this.getConverter().statementToStatement(statement.getBody()));
    }

    @Override
    public void visitIfStatement(@NotNull PsiIfStatement statement) {
        super.visitIfStatement(statement);
        PsiExpression condition = statement.getCondition();
        Expression expression = condition != null && condition.getType() != null ? this.getConverter().createSureCallOnlyForChain(condition, condition.getType()) : this.getConverter().expressionToExpression(condition);
        this.myResult = new IfStatement(expression, this.getConverter().statementToStatement(statement.getThenBranch()), this.getConverter().statementToStatement(statement.getElseBranch()));
    }

    @Override
    public void visitLabeledStatement(@NotNull PsiLabeledStatement statement) {
        super.visitLabeledStatement(statement);
        this.myResult = new LabelStatement(Converter.identifierToIdentifier(statement.getLabelIdentifier()), this.getConverter().statementToStatement(statement.getStatement()));
    }

    @Override
    public void visitSwitchLabelStatement(@NotNull PsiSwitchLabelStatement statement) {
        super.visitSwitchLabelStatement(statement);
        this.myResult = statement.isDefaultCase() ? new DefaultSwitchLabelStatement() : new SwitchLabelStatement(this.getConverter().expressionToExpression(statement.getCaseValue()));
    }

    @Override
    public void visitSwitchStatement(@NotNull PsiSwitchStatement statement) {
        super.visitSwitchStatement(statement);
        this.myResult = new SwitchContainer(this.getConverter().expressionToExpression(statement.getExpression()), this.switchBodyToCases(statement.getBody()));
    }

    @NotNull
    private List<CaseContainer> switchBodyToCases(@Nullable PsiCodeBlock body) {
        List<List<PsiStatement>> cases = StatementVisitor.splitToCases(body);
        List<PsiStatement> allSwitchStatements = body != null ? Arrays.asList(body.getStatements()) : Collections.emptyList();
        LinkedList<CaseContainer> result = new LinkedList<CaseContainer>();
        LinkedList<Statement> pendingLabels = new LinkedList<Statement>();
        int i = 0;
        for (List<PsiStatement> ls : cases) {
            assert (ls.size() > 0);
            PsiStatement label = ls.get(0);
            assert (label instanceof PsiSwitchLabelStatement);
            assert (allSwitchStatements.get(i) == label) : "not a right index";
            if (ls.size() > 1) {
                pendingLabels.add(this.getConverter().statementToStatement(label));
                List<PsiStatement> slice = ls.subList(1, ls.size());
                if (!StatementVisitor.containsBreak(slice)) {
                    List<Statement> statements = this.getConverter().statementsToStatementList(slice);
                    statements.addAll(this.getConverter().statementsToStatementList(StatementVisitor.getAllToNextBreak(allSwitchStatements, i + ls.size())));
                    result.add(new CaseContainer(pendingLabels, statements));
                    pendingLabels = new LinkedList();
                } else {
                    result.add(new CaseContainer(pendingLabels, this.getConverter().statementsToStatementList(slice)));
                    pendingLabels = new LinkedList();
                }
            } else {
                pendingLabels.add(this.getConverter().statementToStatement(label));
            }
            i += ls.size();
        }
        return result;
    }

    private static boolean containsBreak(@NotNull List<PsiStatement> slice) {
        for (PsiStatement s : slice) {
            if (!(s instanceof PsiBreakStatement)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static List<PsiStatement> getAllToNextBreak(@NotNull List<PsiStatement> allStatements, int start) {
        LinkedList<PsiStatement> result = new LinkedList<PsiStatement>();
        for (int i = start; i < allStatements.size(); ++i) {
            PsiStatement s = allStatements.get(i);
            if (s instanceof PsiBreakStatement || s instanceof PsiReturnStatement) {
                return result;
            }
            if (s instanceof PsiSwitchLabelStatement) continue;
            result.add(s);
        }
        return result;
    }

    @NotNull
    private static List<List<PsiStatement>> splitToCases(@Nullable PsiCodeBlock body) {
        LinkedList<List<PsiStatement>> cases = new LinkedList<List<PsiStatement>>();
        LinkedList<PsiStatement> currentCaseStatements = new LinkedList<PsiStatement>();
        boolean isFirst = true;
        if (body != null) {
            for (PsiStatement s : body.getStatements()) {
                if (s instanceof PsiSwitchLabelStatement) {
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        cases.add(currentCaseStatements);
                        currentCaseStatements = new LinkedList();
                    }
                }
                currentCaseStatements.add(s);
            }
            cases.add(currentCaseStatements);
        }
        return cases;
    }

    @Override
    public void visitSynchronizedStatement(@NotNull PsiSynchronizedStatement statement) {
        super.visitSynchronizedStatement(statement);
        this.myResult = new SynchronizedStatement(this.getConverter().expressionToExpression(statement.getLockExpression()), this.getConverter().blockToBlock(statement.getBody()));
    }

    @Override
    public void visitThrowStatement(@NotNull PsiThrowStatement statement) {
        super.visitThrowStatement(statement);
        this.myResult = new ThrowStatement(this.getConverter().expressionToExpression(statement.getException()));
    }

    @Override
    public void visitTryStatement(@NotNull PsiTryStatement statement) {
        super.visitTryStatement(statement);
        LinkedList<CatchStatement> catches = new LinkedList<CatchStatement>();
        for (int i = 0; i < statement.getCatchBlocks().length; ++i) {
            catches.add(new CatchStatement(this.getConverter().parameterToParameter(statement.getCatchBlockParameters()[i]), this.getConverter().blockToBlock(statement.getCatchBlocks()[i], true)));
        }
        this.myResult = new TryStatement(this.getConverter().blockToBlock(statement.getTryBlock(), true), catches, this.getConverter().blockToBlock(statement.getFinallyBlock(), true));
    }

    @Override
    public void visitWhileStatement(@NotNull PsiWhileStatement statement) {
        super.visitWhileStatement(statement);
        PsiExpression condition = statement.getCondition();
        Expression expression = condition != null && condition.getType() != null ? this.getConverter().createSureCallOnlyForChain(condition, condition.getType()) : this.getConverter().expressionToExpression(condition);
        this.myResult = new WhileStatement(expression, this.getConverter().statementToStatement(statement.getBody()));
    }

    @Override
    public void visitReturnStatement(@NotNull PsiReturnStatement statement) {
        super.visitReturnStatement(statement);
        PsiExpression returnValue = statement.getReturnValue();
        PsiType methodReturnType = this.getConverter().getMethodReturnType();
        Expression expression = returnValue != null && methodReturnType != null ? this.getConverter().createSureCallOnlyForChain(returnValue, methodReturnType) : this.getConverter().expressionToExpression(returnValue);
        this.myResult = new ReturnStatement(expression);
    }
}

