/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.j2k.visitors;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.psi.PsiExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiMethodCallExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiReferenceExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiSuperExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiType;
import org.jetbrains.jet.j2k.Converter;
import org.jetbrains.jet.j2k.ast.DummyMethodCallExpression;
import org.jetbrains.jet.j2k.ast.DummyStringExpression;
import org.jetbrains.jet.j2k.ast.IdentifierImpl;
import org.jetbrains.jet.j2k.visitors.ExpressionVisitor;

public class ExpressionVisitorForDirectObjectInheritors
extends ExpressionVisitor {
    public ExpressionVisitorForDirectObjectInheritors(@NotNull Converter converter) {
        super(converter);
    }

    @Override
    public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
        if (ExpressionVisitorForDirectObjectInheritors.superMethodInvocation(expression.getMethodExpression(), "hashCode")) {
            this.myResult = new DummyMethodCallExpression(new IdentifierImpl("System"), "identityHashCode", new IdentifierImpl("this"));
        } else if (ExpressionVisitorForDirectObjectInheritors.superMethodInvocation(expression.getMethodExpression(), "equals")) {
            this.myResult = new DummyMethodCallExpression(new IdentifierImpl("this"), "identityEquals", this.getConverter().elementToElement(expression.getArgumentList()));
        } else if (ExpressionVisitorForDirectObjectInheritors.superMethodInvocation(expression.getMethodExpression(), "toString")) {
            this.myResult = new DummyStringExpression(String.format("getJavaClass<%s>.getName() + '@' + Integer.toHexString(hashCode())", ExpressionVisitorForDirectObjectInheritors.getClassName(expression.getMethodExpression())));
        } else {
            super.visitMethodCallExpression(expression);
        }
    }

    @Override
    public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
        super.visitReferenceExpression(expression);
    }

    private static boolean superMethodInvocation(@NotNull PsiReferenceExpression expression, String methodName) {
        PsiType type;
        String referenceName = expression.getReferenceName();
        PsiExpression qualifierExpression = expression.getQualifierExpression();
        return referenceName != null && referenceName.equals(methodName) && qualifierExpression instanceof PsiSuperExpression && (type = qualifierExpression.getType()) != null && type.getCanonicalText().equals("java.lang.Object");
    }
}

