/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.j2k.visitors;

import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.psi.JavaTokenType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiAnonymousClass;
import org.jetbrains.jet.internal.com.intellij.psi.PsiArrayAccessExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiArrayInitializerExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiAssignmentExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiBinaryExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiCallExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClass;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClassObjectAccessExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiConditionalExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiExpressionList;
import org.jetbrains.jet.internal.com.intellij.psi.PsiField;
import org.jetbrains.jet.internal.com.intellij.psi.PsiIdentifier;
import org.jetbrains.jet.internal.com.intellij.psi.PsiInstanceOfExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiLiteralExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiMethod;
import org.jetbrains.jet.internal.com.intellij.psi.PsiMethodCallExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiNewExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiParenthesizedExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiPolyadicExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiPostfixExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiPrefixExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiReference;
import org.jetbrains.jet.internal.com.intellij.psi.PsiReferenceExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiSuperExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiThisExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiTypeCastExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiTypeElement;
import org.jetbrains.jet.internal.com.intellij.psi.tree.IElementType;
import org.jetbrains.jet.j2k.Converter;
import org.jetbrains.jet.j2k.ast.ArrayAccessExpression;
import org.jetbrains.jet.j2k.ast.ArrayInitializerExpression;
import org.jetbrains.jet.j2k.ast.ArrayWithoutInitializationExpression;
import org.jetbrains.jet.j2k.ast.AssignmentExpression;
import org.jetbrains.jet.j2k.ast.BinaryExpression;
import org.jetbrains.jet.j2k.ast.CallChainExpression;
import org.jetbrains.jet.j2k.ast.ClassObjectAccessExpression;
import org.jetbrains.jet.j2k.ast.DummyMethodCallExpression;
import org.jetbrains.jet.j2k.ast.Expression;
import org.jetbrains.jet.j2k.ast.ExpressionList;
import org.jetbrains.jet.j2k.ast.Identifier;
import org.jetbrains.jet.j2k.ast.IdentifierImpl;
import org.jetbrains.jet.j2k.ast.IfStatement;
import org.jetbrains.jet.j2k.ast.IsOperator;
import org.jetbrains.jet.j2k.ast.LiteralExpression;
import org.jetbrains.jet.j2k.ast.MethodCallExpression;
import org.jetbrains.jet.j2k.ast.NewClassExpression;
import org.jetbrains.jet.j2k.ast.ParenthesizedExpression;
import org.jetbrains.jet.j2k.ast.PolyadicExpression;
import org.jetbrains.jet.j2k.ast.PostfixOperator;
import org.jetbrains.jet.j2k.ast.PrefixOperator;
import org.jetbrains.jet.j2k.ast.SuperExpression;
import org.jetbrains.jet.j2k.ast.ThisExpression;
import org.jetbrains.jet.j2k.ast.Type;
import org.jetbrains.jet.j2k.ast.TypeCastExpression;
import org.jetbrains.jet.j2k.visitors.StatementVisitor;
import org.jetbrains.jet.j2k.visitors.SuperVisitor;
import org.jetbrains.jet.lang.types.expressions.OperatorConventions;

public class ExpressionVisitor
extends StatementVisitor {
    @NotNull
    Expression myResult = Expression.EMPTY_EXPRESSION;

    public ExpressionVisitor(@NotNull Converter converter) {
        super(converter);
    }

    @Override
    public void visitExpression(PsiExpression expression) {
        this.myResult = Expression.EMPTY_EXPRESSION;
    }

    @Override
    @NotNull
    public Expression getResult() {
        return this.myResult;
    }

    @Override
    public void visitArrayAccessExpression(@NotNull PsiArrayAccessExpression expression) {
        super.visitArrayAccessExpression(expression);
        this.myResult = new ArrayAccessExpression(this.getConverter().expressionToExpression(expression.getArrayExpression()), this.getConverter().expressionToExpression(expression.getIndexExpression()));
    }

    @Override
    public void visitArrayInitializerExpression(@NotNull PsiArrayInitializerExpression expression) {
        super.visitArrayInitializerExpression(expression);
        this.myResult = new ArrayInitializerExpression(this.getConverter().typeToType(expression.getType()), this.getConverter().expressionsToExpressionList(expression.getInitializers()));
    }

    @Override
    public void visitAssignmentExpression(@NotNull PsiAssignmentExpression expression) {
        super.visitAssignmentExpression(expression);
        IElementType tokenType = expression.getOperationSign().getTokenType();
        String secondOp = "";
        if (tokenType == JavaTokenType.GTGTEQ) {
            secondOp = "shr";
        }
        if (tokenType == JavaTokenType.LTLTEQ) {
            secondOp = "shl";
        }
        if (tokenType == JavaTokenType.XOREQ) {
            secondOp = "xor";
        }
        if (tokenType == JavaTokenType.ANDEQ) {
            secondOp = "and";
        }
        if (tokenType == JavaTokenType.OREQ) {
            secondOp = "or";
        }
        if (tokenType == JavaTokenType.GTGTGTEQ) {
            secondOp = "ushr";
        }
        this.myResult = !secondOp.isEmpty() ? new AssignmentExpression(this.getConverter().expressionToExpression(expression.getLExpression()), new BinaryExpression(this.getConverter().expressionToExpression(expression.getLExpression()), this.getConverter().expressionToExpression(expression.getRExpression()), secondOp), "=") : new AssignmentExpression(this.getConverter().expressionToExpression(expression.getLExpression()), this.getConverter().expressionToExpression(expression.getRExpression()), expression.getOperationSign().getText());
    }

    @NotNull
    private static String getOperatorString(@NotNull IElementType tokenType) {
        if (tokenType == JavaTokenType.PLUS) {
            return "+";
        }
        if (tokenType == JavaTokenType.MINUS) {
            return "-";
        }
        if (tokenType == JavaTokenType.ASTERISK) {
            return "*";
        }
        if (tokenType == JavaTokenType.DIV) {
            return "/";
        }
        if (tokenType == JavaTokenType.PERC) {
            return "%";
        }
        if (tokenType == JavaTokenType.GTGT) {
            return "shr";
        }
        if (tokenType == JavaTokenType.LTLT) {
            return "shl";
        }
        if (tokenType == JavaTokenType.XOR) {
            return "xor";
        }
        if (tokenType == JavaTokenType.AND) {
            return "and";
        }
        if (tokenType == JavaTokenType.OR) {
            return "or";
        }
        if (tokenType == JavaTokenType.GTGTGT) {
            return "ushr";
        }
        if (tokenType == JavaTokenType.GT) {
            return ">";
        }
        if (tokenType == JavaTokenType.LT) {
            return "<";
        }
        if (tokenType == JavaTokenType.GE) {
            return ">=";
        }
        if (tokenType == JavaTokenType.LE) {
            return "<=";
        }
        if (tokenType == JavaTokenType.EQEQ) {
            return "==";
        }
        if (tokenType == JavaTokenType.NE) {
            return "!=";
        }
        if (tokenType == JavaTokenType.ANDAND) {
            return "&&";
        }
        if (tokenType == JavaTokenType.OROR) {
            return "||";
        }
        if (tokenType == JavaTokenType.PLUSPLUS) {
            return "++";
        }
        if (tokenType == JavaTokenType.MINUSMINUS) {
            return "--";
        }
        if (tokenType == JavaTokenType.EXCL) {
            return "!";
        }
        System.out.println("UNSUPPORTED TOKEN TYPE: " + tokenType.toString());
        return "";
    }

    @Override
    public void visitBinaryExpression(@NotNull PsiBinaryExpression expression) {
        super.visitBinaryExpression(expression);
        this.myResult = expression.getOperationSign().getTokenType() == JavaTokenType.GTGTGT ? new DummyMethodCallExpression(this.getConverter().expressionToExpression(expression.getLOperand()), "ushr", this.getConverter().expressionToExpression(expression.getROperand())) : new BinaryExpression(this.getConverter().expressionToExpression(expression.getLOperand()), this.getConverter().expressionToExpression(expression.getROperand()), ExpressionVisitor.getOperatorString(expression.getOperationSign().getTokenType()), this.getConverter().createConversions(expression, PsiType.BOOLEAN));
    }

    @Override
    public void visitClassObjectAccessExpression(@NotNull PsiClassObjectAccessExpression expression) {
        super.visitClassObjectAccessExpression(expression);
        this.myResult = new ClassObjectAccessExpression(this.getConverter().elementToElement(expression.getOperand()));
    }

    @Override
    public void visitConditionalExpression(@NotNull PsiConditionalExpression expression) {
        super.visitConditionalExpression(expression);
        PsiExpression condition = expression.getCondition();
        PsiType type = condition.getType();
        Expression e = type != null ? this.getConverter().createSureCallOnlyForChain(condition, type) : this.getConverter().expressionToExpression(condition);
        this.myResult = new ParenthesizedExpression(new IfStatement(e, this.getConverter().expressionToExpression(expression.getThenExpression()), this.getConverter().expressionToExpression(expression.getElseExpression())));
    }

    @Override
    public void visitExpressionList(@NotNull PsiExpressionList list) {
        super.visitExpressionList(list);
        this.myResult = new ExpressionList(this.getConverter().expressionsToExpressionList(list.getExpressions()));
    }

    @Override
    public void visitInstanceOfExpression(@NotNull PsiInstanceOfExpression expression) {
        super.visitInstanceOfExpression(expression);
        this.myResult = new IsOperator(this.getConverter().expressionToExpression(expression.getOperand()), this.getConverter().elementToElement(expression.getCheckType()));
    }

    @Override
    public void visitLiteralExpression(@NotNull PsiLiteralExpression expression) {
        super.visitLiteralExpression(expression);
        Object value = expression.getValue();
        String text = expression.getText();
        boolean isQuotingNeeded = true;
        PsiType type = expression.getType();
        if (type != null) {
            String canonicalTypeStr = type.getCanonicalText();
            if (canonicalTypeStr.equals("double") || canonicalTypeStr.equals("java.lang.Double")) {
                text = text.replace("D", "").replace("d", "");
            }
            if (canonicalTypeStr.equals("float") || canonicalTypeStr.equals("java.lang.Float")) {
                text = text.replace("F", "").replace("f", "") + "." + OperatorConventions.FLOAT + "()";
            }
            if (canonicalTypeStr.equals("long") || canonicalTypeStr.equals("java.lang.Long")) {
                text = text.replace("L", "").replace("l", "");
            }
            if (canonicalTypeStr.equals("int") || canonicalTypeStr.equals("java.lang.Integer")) {
                String string = text = value != null ? value.toString() : text;
            }
            if (canonicalTypeStr.equals("java.lang.String")) {
                isQuotingNeeded = false;
            }
            if (canonicalTypeStr.equals("char") || canonicalTypeStr.equals("java.lang.Character")) {
                isQuotingNeeded = false;
            }
        }
        this.myResult = new LiteralExpression(new IdentifierImpl(text, false, isQuotingNeeded));
    }

    @Override
    public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
        super.visitMethodCallExpression(expression);
        if (!SuperVisitor.isSuper(expression.getMethodExpression()) || !ExpressionVisitor.isInsidePrimaryConstructor(expression)) {
            this.myResult = new MethodCallExpression(this.getConverter().expressionToExpression(expression.getMethodExpression()), this.getConverter().expressionsToExpressionList(expression.getArgumentList().getExpressions()), this.getConverter().createConversions(expression), this.getConverter().typeToType(expression.getType()).isNullable(), this.getConverter().typesToTypeList(expression.getTypeArguments()));
        }
    }

    @Override
    public void visitCallExpression(PsiCallExpression callExpression) {
        super.visitCallExpression(callExpression);
    }

    @Override
    public void visitNewExpression(@NotNull PsiNewExpression expression) {
        super.visitNewExpression(expression);
        this.myResult = expression.getArrayInitializer() != null ? this.createNewEmptyArray(expression) : (expression.getArrayDimensions().length > 0 ? this.createNewEmptyArrayWithoutInitialization(expression) : this.createNewClassExpression(expression));
    }

    @NotNull
    private Expression createNewClassExpression(@NotNull PsiNewExpression expression) {
        PsiExpression[] arguments;
        PsiAnonymousClass anonymousClass = expression.getAnonymousClass();
        PsiMethod constructor = expression.resolveMethod();
        PsiJavaCodeReferenceElement classReference = expression.getClassOrAnonymousClassReference();
        boolean isNotConvertedClass = classReference != null && !this.getConverter().getClassIdentifiers().contains(classReference.getQualifiedName());
        PsiExpressionList argumentList = expression.getArgumentList();
        PsiExpression[] psiExpressionArray = arguments = argumentList != null ? argumentList.getExpressions() : new PsiExpression[]{};
        if (constructor == null || Converter.isConstructorPrimary(constructor) || isNotConvertedClass) {
            return new NewClassExpression(this.getConverter().expressionToExpression(expression.getQualifier()), this.getConverter().elementToElement(classReference), this.getConverter().expressionsToExpressionList(arguments), this.getConverter().createConversions(expression), anonymousClass != null ? this.getConverter().anonymousClassToAnonymousClass(anonymousClass) : null);
        }
        PsiJavaCodeReferenceElement reference = expression.getClassReference();
        List<Type> typeParameters = reference != null ? this.getConverter().typesToTypeList(reference.getTypeParameters()) : Collections.emptyList();
        return new CallChainExpression(new IdentifierImpl(constructor.getName(), false), new MethodCallExpression(new IdentifierImpl("init"), this.getConverter().expressionsToExpressionList(arguments), typeParameters));
    }

    @NotNull
    private Expression createNewEmptyArrayWithoutInitialization(@NotNull PsiNewExpression expression) {
        return new ArrayWithoutInitializationExpression(this.getConverter().typeToType(expression.getType(), true), this.getConverter().expressionsToExpressionList(expression.getArrayDimensions()));
    }

    @NotNull
    private Expression createNewEmptyArray(@NotNull PsiNewExpression expression) {
        return this.getConverter().expressionToExpression(expression.getArrayInitializer());
    }

    @Override
    public void visitParenthesizedExpression(@NotNull PsiParenthesizedExpression expression) {
        super.visitParenthesizedExpression(expression);
        this.myResult = new ParenthesizedExpression(this.getConverter().expressionToExpression(expression.getExpression()));
    }

    @Override
    public void visitPostfixExpression(@NotNull PsiPostfixExpression expression) {
        super.visitPostfixExpression(expression);
        this.myResult = new PostfixOperator(ExpressionVisitor.getOperatorString(expression.getOperationSign().getTokenType()), this.getConverter().expressionToExpression(expression.getOperand()));
    }

    @Override
    public void visitPrefixExpression(@NotNull PsiPrefixExpression expression) {
        super.visitPrefixExpression(expression);
        this.myResult = expression.getOperationTokenType() == JavaTokenType.TILDE ? new DummyMethodCallExpression(new ParenthesizedExpression(this.getConverter().expressionToExpression(expression.getOperand())), "inv", Expression.EMPTY_EXPRESSION) : new PrefixOperator(ExpressionVisitor.getOperatorString(expression.getOperationSign().getTokenType()), this.getConverter().expressionToExpression(expression.getOperand()));
    }

    @Override
    public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
        super.visitReferenceExpression(expression);
        boolean isFieldReference = ExpressionVisitor.isFieldReference(expression, ExpressionVisitor.getContainingClass(expression));
        boolean insideSecondaryConstructor = ExpressionVisitor.isInsideSecondaryConstructor(expression);
        boolean hasReceiver = isFieldReference && insideSecondaryConstructor;
        boolean isThis = ExpressionVisitor.isThisExpression(expression);
        boolean isNullable = this.getConverter().typeToType(expression.getType()).isNullable();
        String className = ExpressionVisitor.getClassNameWithConstructor(expression);
        Expression identifier = new IdentifierImpl(expression.getReferenceName(), isNullable);
        String __ = "__";
        if (hasReceiver) {
            identifier = new CallChainExpression(new IdentifierImpl("__", false), new IdentifierImpl(expression.getReferenceName(), isNullable));
        } else if (insideSecondaryConstructor && isThis) {
            identifier = new IdentifierImpl("val __ = " + className);
        }
        this.myResult = new CallChainExpression(this.getConverter().expressionToExpression(expression.getQualifierExpression()), identifier);
    }

    @NotNull
    private static String getClassNameWithConstructor(@NotNull PsiReferenceExpression expression) {
        for (PsiElement context = expression.getContext(); context != null; context = context.getContext()) {
            PsiIdentifier identifier;
            PsiClass containingClass;
            if (!(context instanceof PsiMethod) || !((PsiMethod)context).isConstructor() || (containingClass = ((PsiMethod)context).getContainingClass()) == null || (identifier = containingClass.getNameIdentifier()) == null) continue;
            return identifier.getText();
        }
        return "";
    }

    @NotNull
    static String getClassName(@NotNull PsiExpression expression) {
        for (PsiElement context = expression.getContext(); context != null; context = context.getContext()) {
            PsiClass containingClass;
            PsiIdentifier identifier;
            if (!(context instanceof PsiClass) || (identifier = (containingClass = (PsiClass)context).getNameIdentifier()) == null) continue;
            return identifier.getText();
        }
        return "";
    }

    private static boolean isFieldReference(@NotNull PsiReferenceExpression expression, PsiClass currentClass) {
        PsiElement resolvedReference;
        PsiReference reference = expression.getReference();
        if (reference != null && (resolvedReference = reference.resolve()) != null && resolvedReference instanceof PsiField) {
            return ((PsiField)resolvedReference).getContainingClass() == currentClass;
        }
        return false;
    }

    private static boolean isInsideSecondaryConstructor(@NotNull PsiReferenceExpression expression) {
        for (PsiElement context = expression.getContext(); context != null; context = context.getContext()) {
            if (!(context instanceof PsiMethod) || !((PsiMethod)context).isConstructor()) continue;
            return !Converter.isConstructorPrimary((PsiMethod)context);
        }
        return false;
    }

    private static boolean isInsidePrimaryConstructor(@NotNull PsiExpression expression) {
        for (PsiElement context = expression.getContext(); context != null; context = context.getContext()) {
            if (!(context instanceof PsiMethod) || !((PsiMethod)context).isConstructor()) continue;
            return Converter.isConstructorPrimary((PsiMethod)context);
        }
        return false;
    }

    @Nullable
    private static PsiClass getContainingClass(@NotNull PsiExpression expression) {
        for (PsiElement context = expression.getContext(); context != null; context = context.getContext()) {
            if (!(context instanceof PsiMethod) || !((PsiMethod)context).isConstructor()) continue;
            return ((PsiMethod)context).getContainingClass();
        }
        return null;
    }

    private static boolean isThisExpression(@NotNull PsiReferenceExpression expression) {
        for (PsiReference r : expression.getReferences()) {
            PsiElement res;
            if (!r.getCanonicalText().equals("this") || (res = r.resolve()) == null || !(res instanceof PsiMethod) || !((PsiMethod)res).isConstructor()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void visitSuperExpression(@NotNull PsiSuperExpression expression) {
        super.visitSuperExpression(expression);
        PsiJavaCodeReferenceElement qualifier = expression.getQualifier();
        this.myResult = new SuperExpression(qualifier != null ? new IdentifierImpl(qualifier.getQualifiedName()) : Identifier.EMPTY_IDENTIFIER);
    }

    @Override
    public void visitThisExpression(@NotNull PsiThisExpression expression) {
        super.visitThisExpression(expression);
        PsiJavaCodeReferenceElement qualifier = expression.getQualifier();
        this.myResult = new ThisExpression(qualifier != null ? new IdentifierImpl(qualifier.getQualifiedName()) : Identifier.EMPTY_IDENTIFIER);
    }

    @Override
    public void visitTypeCastExpression(@NotNull PsiTypeCastExpression expression) {
        super.visitTypeCastExpression(expression);
        PsiTypeElement castType = expression.getCastType();
        if (castType != null) {
            this.myResult = new TypeCastExpression(this.getConverter().typeToType(castType.getType()), this.getConverter().expressionToExpression(expression.getOperand()));
        }
    }

    @Override
    public void visitPolyadicExpression(@NotNull PsiPolyadicExpression expression) {
        super.visitPolyadicExpression(expression);
        this.myResult = new PolyadicExpression(this.getConverter().expressionsToExpressionList(expression.getOperands()), ExpressionVisitor.getOperatorString(expression.getOperationTokenType()), this.getConverter().createConversions(expression, PsiType.BOOLEAN));
    }
}

