/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.j2k.visitors;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiExpressionList;
import org.jetbrains.jet.internal.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiLocalVariable;
import org.jetbrains.jet.internal.com.intellij.psi.PsiParameterList;
import org.jetbrains.jet.internal.com.intellij.psi.PsiTypeElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.jet.j2k.Converter;
import org.jetbrains.jet.j2k.ConverterUtil;
import org.jetbrains.jet.j2k.ast.Element;
import org.jetbrains.jet.j2k.ast.ExpressionList;
import org.jetbrains.jet.j2k.ast.IdentifierImpl;
import org.jetbrains.jet.j2k.ast.LocalVariable;
import org.jetbrains.jet.j2k.ast.ParameterList;
import org.jetbrains.jet.j2k.ast.ReferenceElement;
import org.jetbrains.jet.j2k.ast.Type;
import org.jetbrains.jet.j2k.ast.TypeElement;
import org.jetbrains.jet.j2k.ast.TypeParameter;
import org.jetbrains.jet.j2k.visitors.J2KVisitor;

public class ElementVisitor
extends JavaElementVisitor
implements J2KVisitor {
    private final Converter myConverter;
    @NotNull
    private Element myResult = Element.EMPTY_ELEMENT;

    public ElementVisitor(@NotNull Converter converter) {
        this.myConverter = converter;
    }

    @Override
    @NotNull
    public Converter getConverter() {
        return this.myConverter;
    }

    @NotNull
    public Element getResult() {
        return this.myResult;
    }

    @Override
    public void visitLocalVariable(@NotNull PsiLocalVariable variable) {
        super.visitLocalVariable(variable);
        this.myResult = new LocalVariable(new IdentifierImpl(variable.getName()), Converter.modifiersListToModifiersSet(variable.getModifierList()), this.getConverter().typeToType(variable.getType(), ConverterUtil.isAnnotatedAsNotNull(variable.getModifierList())), this.getConverter().createSureCallOnlyForChain(variable.getInitializer(), variable.getType()));
    }

    @Override
    public void visitExpressionList(@NotNull PsiExpressionList list) {
        super.visitExpressionList(list);
        this.myResult = new ExpressionList(this.getConverter().expressionsToExpressionList(list.getExpressions()), this.getConverter().typesToTypeList(list.getExpressionTypes()));
    }

    @Override
    public void visitReferenceElement(@NotNull PsiJavaCodeReferenceElement reference) {
        super.visitReferenceElement(reference);
        List<Type> types = this.getConverter().typesToTypeList(reference.getTypeParameters());
        if (!reference.isQualified()) {
            this.myResult = new ReferenceElement(new IdentifierImpl(reference.getReferenceName()), types);
        } else {
            String result = new IdentifierImpl(reference.getReferenceName()).toKotlin();
            PsiElement qualifier = reference.getQualifier();
            while (qualifier != null) {
                PsiJavaCodeReferenceElement p = (PsiJavaCodeReferenceElement)qualifier;
                result = new IdentifierImpl(p.getReferenceName()).toKotlin() + "." + result;
                qualifier = p.getQualifier();
            }
            this.myResult = new ReferenceElement(new IdentifierImpl(result), types);
        }
    }

    @Override
    public void visitTypeElement(@NotNull PsiTypeElement type) {
        super.visitTypeElement(type);
        this.myResult = new TypeElement(this.getConverter().typeToType(type.getType()));
    }

    @Override
    public void visitTypeParameter(@NotNull PsiTypeParameter classParameter) {
        super.visitTypeParameter(classParameter);
        this.myResult = new TypeParameter(new IdentifierImpl(classParameter.getName()), this.getConverter().typesToTypeList(classParameter.getExtendsListTypes()));
    }

    @Override
    public void visitParameterList(@NotNull PsiParameterList list) {
        super.visitParameterList(list);
        this.myResult = new ParameterList(this.getConverter().parametersToParameterList(list.getParameters()));
    }
}

