/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.j2k.util;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.j2k.ast.INode;

public class AstUtil {
    private AstUtil() {
    }

    private static String join(@NotNull String[] array, @Nullable String delimiter) {
        StringBuilder buffer = new StringBuilder();
        boolean haveDelimiter = delimiter != null;
        for (int i = 0; i < array.length; ++i) {
            buffer.append(array[i]);
            if (!haveDelimiter || i + 1 >= array.length) continue;
            buffer.append(delimiter);
        }
        return buffer.toString();
    }

    public static String joinNodes(@NotNull List<? extends INode> nodes, String delimiter) {
        return AstUtil.join(AstUtil.nodesToKotlin(nodes), delimiter);
    }

    public static String join(@NotNull List<String> array, String delimiter) {
        return AstUtil.join(array.toArray(new String[array.size()]), delimiter);
    }

    @NotNull
    public static List<String> nodesToKotlin(@NotNull List<? extends INode> nodes) {
        LinkedList<String> result = new LinkedList<String>();
        for (INode iNode : nodes) {
            result.add(iNode.toKotlin());
        }
        return result;
    }

    @NotNull
    public static String upperFirstCharacter(@NotNull String string) {
        return string.substring(0, 1).toUpperCase() + string.substring(1);
    }

    @NotNull
    public static String lowerFirstCharacter(@NotNull String string) {
        return string.substring(0, 1).toLowerCase() + string.substring(1);
    }

    @NotNull
    public static <T> List<String> createListWithEmptyString(@NotNull List<T> arguments) {
        LinkedList<String> conversions = new LinkedList<String>();
        for (T argument : arguments) {
            conversions.add("");
        }
        return conversions;
    }

    @NotNull
    public static List<String> applyConversions(@NotNull List<String> first, @NotNull List<String> second) {
        LinkedList<String> result = new LinkedList<String>();
        assert (first.size() == second.size()) : "Lists must have the same size.";
        for (int i = 0; i < first.size(); ++i) {
            result.add(AstUtil.applyConversionForOneItem(first.get(i), second.get(i)));
        }
        return result;
    }

    @NotNull
    public static String applyConversionForOneItem(@NotNull String f, @NotNull String s) {
        if (s.isEmpty()) {
            return f;
        }
        return "(" + f + ")" + s;
    }

    @NotNull
    public static <T> T getOrElse(@NotNull Map<T, T> map, @NotNull T e, @NotNull T orElse) {
        if (map.containsKey(e)) {
            return map.get(e);
        }
        return orElse;
    }

    @NotNull
    public static String replaceLastQuest(@NotNull String str) {
        if (str.endsWith("?")) {
            return str.substring(0, str.length() - 1);
        }
        return str;
    }
}

