/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.j2k.ast;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.j2k.ast.Element;
import org.jetbrains.jet.j2k.ast.Identifier;
import org.jetbrains.jet.j2k.ast.Type;

public class TypeParameter
extends Element {
    private final Identifier myName;
    private final List<Type> myExtendsTypes;

    public TypeParameter(Identifier name, List<Type> extendsTypes) {
        this.myName = name;
        this.myExtendsTypes = extendsTypes;
    }

    public boolean hasWhere() {
        return this.myExtendsTypes.size() > 1;
    }

    @NotNull
    public String getWhereToKotlin() {
        if (this.hasWhere()) {
            return this.myName.toKotlin() + " " + ":" + " " + this.myExtendsTypes.get(1).toKotlin();
        }
        return "";
    }

    @Override
    @NotNull
    public String toKotlin() {
        if (this.myExtendsTypes.size() > 0) {
            return this.myName.toKotlin() + " " + ":" + " " + this.myExtendsTypes.get(0).toKotlin();
        }
        return this.myName.toKotlin();
    }
}

