/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.j2k.ast;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.j2k.ast.Block;
import org.jetbrains.jet.j2k.ast.CatchStatement;
import org.jetbrains.jet.j2k.ast.Statement;
import org.jetbrains.jet.j2k.util.AstUtil;

public class TryStatement
extends Statement {
    private final Block myBlock;
    private final List<CatchStatement> myCatches;
    private final Block myFinallyBlock;

    public TryStatement(Block block, List<CatchStatement> catches, Block finallyBlock) {
        this.myBlock = block;
        this.myCatches = catches;
        this.myFinallyBlock = finallyBlock;
    }

    @Override
    @NotNull
    public String toKotlin() {
        return "try\n" + this.myBlock.toKotlin() + "\n" + AstUtil.joinNodes(this.myCatches, "\n") + "\n" + (this.myFinallyBlock.isEmpty() ? "" : "finally\n" + this.myFinallyBlock.toKotlin());
    }
}

