/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.j2k.ast;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.j2k.ast.Expression;
import org.jetbrains.jet.j2k.ast.INode;
import org.jetbrains.jet.j2k.ast.Identifier;
import org.jetbrains.jet.j2k.ast.IdentifierImpl;
import org.jetbrains.jet.j2k.ast.Type;

public class Parameter
extends Expression {
    private final Identifier myIdentifier;
    private final Type myType;
    private boolean myReadOnly;

    public Parameter(Identifier identifier, Type type) {
        this.myIdentifier = identifier;
        this.myType = type;
        this.myReadOnly = true;
    }

    public Parameter(IdentifierImpl identifier, Type type, boolean readOnly) {
        this(identifier, type);
        this.myReadOnly = readOnly;
    }

    @Override
    @NotNull
    public String toKotlin() {
        String vararg = this.myType.getKind() == INode.Kind.VARARG ? "vararg " : "";
        String var = this.myReadOnly ? "" : "var ";
        return vararg + var + this.myIdentifier.toKotlin() + " " + ":" + " " + this.myType.toKotlin();
    }
}

